/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.processor.BaseProcessor;

public class ScriptProcessorRegistry {
    private static final Log logger = LogFactory.getLog(ScriptProcessorRegistry.class);
    private String defaultScriptProcessorName = "javascript";
    private Map<String, ScriptProcessor> scriptProcessors = new HashMap<String, ScriptProcessor>(8);
    private Map<String, String> scriptProcessorNamesByExtension = new HashMap<String, String>(8);

    public void setDefaultScriptProcessor(String defaultScriptProcessorName) {
        this.defaultScriptProcessorName = defaultScriptProcessorName;
    }

    public void registerScriptProcessor(ScriptProcessor scriptProcessor) {
        this.registerScriptProcessor(scriptProcessor, null, null);
    }

    public void registerScriptProcessor(ScriptProcessor scriptProcessor, String extension, String name) {
        if (name == null && extension == null && scriptProcessor instanceof BaseProcessor) {
            name = ((BaseProcessor)((Object)scriptProcessor)).getName();
            extension = ((BaseProcessor)((Object)scriptProcessor)).getExtension();
        }
        if (name != null && extension != null) {
            this.scriptProcessors.put(name, scriptProcessor);
            this.scriptProcessorNamesByExtension.put(extension, name);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registered script processor " + name + " for extension " + extension));
            }
        }
    }

    protected ScriptProcessor getDefaultScriptProcessor() {
        return this.scriptProcessors.get(this.defaultScriptProcessorName);
    }

    public ScriptProcessor getScriptProcessor(String path) {
        ScriptProcessor processor = null;
        int i = path.lastIndexOf(46);
        if (i != -1) {
            String extension = path.substring(i + 1);
            processor = this.getScriptProcessorByExtension(extension);
        }
        if (processor == null) {
            processor = this.getDefaultScriptProcessor();
        }
        return processor;
    }

    public ScriptProcessor getScriptProcessor(ScriptContent scriptContent) {
        return this.getScriptProcessor(scriptContent.getPath());
    }

    public ScriptProcessor getScriptProcessorByExtension(String extension) {
        ScriptProcessor processor = null;
        String scriptProcessorName = this.scriptProcessorNamesByExtension.get(extension);
        if (scriptProcessorName != null) {
            processor = this.scriptProcessors.get(scriptProcessorName);
        }
        return processor;
    }

    public String findValidScriptPath(String path) {
        String extension;
        ScriptProcessor processor;
        String validScriptPath = null;
        int i = path.lastIndexOf(46);
        if (i != -1 && (processor = this.getScriptProcessorByExtension(extension = path.substring(i + 1))) != null && processor.findScript(path) != null) {
            validScriptPath = path;
        }
        if (validScriptPath == null) {
            String[] extensions = this.getRegisteredExtensions();
            for (int n = 0; n < extensions.length; ++n) {
                String script;
                String extension2 = extensions[n];
                ScriptProcessor processor2 = this.getScriptProcessorByExtension(extension2);
                if (processor2.findScript(script = path + '.' + extension2) == null) continue;
                validScriptPath = script;
                break;
            }
        }
        return validScriptPath;
    }

    public String[] getRegisteredExtensions() {
        return this.scriptProcessorNamesByExtension.keySet().toArray(new String[this.scriptProcessorNamesByExtension.keySet().size()]);
    }

    public String getExtensionForProcessor(ScriptProcessor scriptProcessor) {
        String ext = null;
        String[] extensions = this.getRegisteredExtensions();
        for (int n = 0; n < extensions.length; ++n) {
            String extension = extensions[n];
            ScriptProcessor processor = this.getScriptProcessorByExtension(extension);
            if (processor != scriptProcessor) continue;
            ext = extension;
            break;
        }
        return ext;
    }

    public void reset() {
        for (ScriptProcessor p : this.scriptProcessors.values()) {
            p.reset();
        }
    }
}

