/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;
import org.springframework.extensions.webscripts.ScriptValueConverter;
import org.springframework.extensions.webscripts.ScriptableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptableWrappedMap
implements ScriptableMap,
Wrapper {
    private Map map;
    private Scriptable parentScope;
    private Scriptable prototype;

    public static ScriptableWrappedMap wrap(Scriptable scope, Map<Object, Object> map) {
        return new ScriptableWrappedMap(scope, map);
    }

    public ScriptableWrappedMap(Map map) {
        this.map = map;
    }

    public ScriptableWrappedMap(Scriptable scope, Map map) {
        this.parentScope = scope;
        this.map = map;
    }

    public Object unwrap() {
        return this.map;
    }

    public String getClassName() {
        return "ScriptableWrappedMap";
    }

    public Object get(String name, Scriptable start) {
        if ("length".equals(name)) {
            return this.map.size();
        }
        return ScriptValueConverter.wrapValue(this.parentScope != null ? this.parentScope : start, this.map.get(name));
    }

    public Object get(int index, Scriptable start) {
        Object value = null;
        int i = 0;
        Iterator itrValues = this.map.values().iterator();
        while (i++ <= index && itrValues.hasNext()) {
            value = itrValues.next();
        }
        return ScriptValueConverter.wrapValue(this.parentScope != null ? this.parentScope : start, value);
    }

    public boolean has(String name, Scriptable start) {
        return this.map.containsKey(name);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && this.map.values().size() > index;
    }

    public void put(String name, Scriptable start, Object value) {
        this.map.put(name, ScriptValueConverter.unwrapValue(value));
    }

    public void put(int index, Scriptable start, Object value) {
    }

    public void delete(String name) {
        this.map.remove(name);
    }

    public void delete(int index) {
        int i = 0;
        Iterator itrKeys = this.map.keySet().iterator();
        while (i <= index && itrKeys.hasNext()) {
            Object key = itrKeys.next();
            if (i != index) continue;
            this.map.remove(key);
            break;
        }
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.parentScope = parent;
    }

    public Object[] getIds() {
        return this.map.keySet().toArray();
    }

    public Object getDefaultValue(Class hint) {
        return null;
    }

    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Object instance = ((Wrapper)value).unwrap();
        return Map.class.isInstance(instance);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map t) {
        this.map.putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection values() {
        return this.map.values();
    }

    public String toString() {
        return this.map != null ? this.map.toString() : super.toString();
    }
}

