/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.ArrayList;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;

public class StoreRegistrar
implements ApplicationContextAware {
    private static final String WEBSCRIPTS_SEARCHPATH_ID = "webscripts.searchpath";
    private ApplicationContext applicationContext;
    protected SearchPath searchPath;
    protected Store store;
    protected boolean prepend = false;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setPrepend(boolean prepend) {
        this.prepend = prepend;
    }

    protected String getSearchPathId() {
        return WEBSCRIPTS_SEARCHPATH_ID;
    }

    public void init() {
        if (this.searchPath == null) {
            this.searchPath = (SearchPath)this.getApplicationContext().getBean(this.getSearchPathId());
        }
        this.plugin(this.store, this.searchPath, this.prepend);
    }

    protected void plugin(Store store, SearchPath searchPath, boolean prepend) {
        ArrayList<Store> storeList = new ArrayList<Store>(searchPath.getStoresInternal());
        if (prepend) {
            storeList.add(0, store);
        } else {
            storeList.add(store);
        }
        searchPath.setSearchPath(storeList);
    }
}

