/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.CredentialVaultProviderException;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.ReflectionHelper;
import org.springframework.extensions.webscripts.connector.AuthenticatingConnector;
import org.springframework.extensions.webscripts.connector.Authenticator;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.CredentialVaultProvider;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;
import org.springframework.extensions.webscripts.connector.UserContext;

public class ConnectorService
implements ApplicationListener,
ApplicationContextAware {
    private static final String PREFIX_CONNECTOR_SESSION = "_alfwsf_consession_";
    private static final String PREFIX_VAULT_SESSION = "_alfwsf_vaults_";
    private static Log logger = LogFactory.getLog(ConnectorService.class);
    private ConfigService configService;
    private RemoteConfigElement remoteConfig;
    private ApplicationContext applicationContext;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext == this.applicationContext) {
            this.remoteConfig = (RemoteConfigElement)this.getConfigService().getConfig((Object)"Remote").getConfigElement("remote");
            if (this.remoteConfig == null) {
                throw new WebScriptsPlatformException("The 'Remote' configuration was not found.");
            }
        }
    }

    public Connector getConnector(String endpointId) throws ConnectorServiceException {
        if (endpointId == null) {
            throw new IllegalArgumentException("EndpointId cannot be null.");
        }
        return this.getConnector(endpointId, (UserContext)null, (HttpSession)null);
    }

    public Connector getConnector(String endpointId, HttpSession session) throws ConnectorServiceException {
        if (endpointId == null) {
            throw new IllegalArgumentException("EndpointId cannot be null.");
        }
        return this.getConnector(endpointId, (String)null, session);
    }

    public Connector getConnector(String endpointId, String userId, HttpSession session) throws ConnectorServiceException {
        if (endpointId == null) {
            throw new IllegalArgumentException("EndpointId cannot be null.");
        }
        if (session == null) {
            throw new IllegalArgumentException("HttpSession cannot be null.");
        }
        Credentials credentials = null;
        if (userId != null) {
            try {
                CredentialVault vault = this.getCredentialVault(session, userId);
                if (vault != null) {
                    credentials = vault.retrieve(endpointId);
                }
            }
            catch (CredentialVaultProviderException cvpe) {
                throw new ConnectorServiceException("Unable to acquire credential vault", cvpe);
            }
        }
        ConnectorSession connectorSession = this.getConnectorSession(session, endpointId);
        UserContext userContext = new UserContext(userId, credentials, connectorSession);
        return this.getConnector(endpointId, userContext, session);
    }

    public Connector getConnector(String endpointId, UserContext userContext, HttpSession session) throws ConnectorServiceException {
        if (endpointId == null) {
            throw new IllegalArgumentException("EndpointId cannot be null.");
        }
        RemoteConfigElement.EndpointDescriptor endpointDescriptor = this.remoteConfig.getEndpointDescriptor(endpointId);
        if (endpointDescriptor == null) {
            throw new ConnectorServiceException("Unable to find endpoint definition for endpoint id: " + endpointId);
        }
        String connectorId = endpointDescriptor.getConnectorId();
        if (connectorId == null) {
            throw new ConnectorServiceException("The connector id property on the endpoint definition '" + endpointId + "' was empty");
        }
        RemoteConfigElement.ConnectorDescriptor connectorDescriptor = this.remoteConfig.getConnectorDescriptor(connectorId);
        if (connectorDescriptor == null) {
            throw new ConnectorServiceException("Unable to find connector definition for connector id: " + connectorId + " on endpoint id: " + endpointId);
        }
        String url = endpointDescriptor.getEndpointUrl();
        Connector connector = ConnectorService.buildConnector(connectorDescriptor, url);
        if (connector == null) {
            throw new ConnectorServiceException("Unable to construct Connector for class: " + connectorDescriptor.getImplementationClass() + ", connector id: " + connectorId);
        }
        String authId = connectorDescriptor.getAuthenticatorId();
        if (authId != null) {
            RemoteConfigElement.AuthenticatorDescriptor authDescriptor = this.remoteConfig.getAuthenticatorDescriptor(authId);
            if (authDescriptor == null) {
                throw new ConnectorServiceException("Unable to find authenticator definition for authenticator id: " + authId + " on connector id: " + connectorId);
            }
            String authClass = authDescriptor.getImplementationClass();
            Authenticator authenticator = ConnectorService.buildAuthenticator(authClass);
            connector = new AuthenticatingConnector(connector, authenticator);
        }
        RemoteConfigElement.IdentityType identity = endpointDescriptor.getIdentity();
        switch (identity) {
            case DECLARED: {
                Credentials credentials = null;
                if (userContext != null && userContext.getCredentials() != null) {
                    credentials = userContext.getCredentials();
                }
                if (credentials == null) {
                    String username = endpointDescriptor.getUsername();
                    String password = endpointDescriptor.getPassword();
                    credentials = new CredentialsImpl(endpointId);
                    credentials.setProperty("cleartextUsername", username);
                    credentials.setProperty("cleartextPassword", password);
                    if (session != null) {
                        try {
                            CredentialVault vault = this.getCredentialVault(session, username);
                            if (vault != null) {
                                vault.store(credentials);
                            }
                        }
                        catch (CredentialVaultProviderException cvpe) {
                            throw new ConnectorServiceException("Unable to acquire credential vault", cvpe);
                        }
                    }
                }
                connector.setCredentials(credentials);
                break;
            }
            case USER: {
                Credentials credentials = null;
                if (userContext != null) {
                    if (userContext.getCredentials() != null) {
                        credentials = userContext.getCredentials();
                    } else if (endpointDescriptor.getExternalAuth()) {
                        credentials = new CredentialsImpl(endpointId);
                        credentials.setProperty("cleartextUsername", userContext.getUserId());
                    }
                }
                if (credentials != null) {
                    connector.setCredentials(credentials);
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                if (userContext != null) {
                    logger.debug((Object)("Unable to find credentials for user: " + userContext.getUserId() + " and endpoint: " + endpointId));
                    break;
                }
                logger.debug((Object)("Unable to find credentials for endpoint: " + endpointId));
            }
        }
        ConnectorSession connectorSession = null;
        if (userContext != null && userContext.getConnectorSession() != null) {
            connectorSession = userContext.getConnectorSession();
        }
        if (connectorSession == null) {
            connectorSession = new ConnectorSession(endpointId);
        }
        connector.setConnectorSession(connectorSession);
        return connector;
    }

    public Authenticator getAuthenticator(String id) throws ConnectorServiceException {
        if (id == null) {
            throw new IllegalArgumentException("Authenticator ID cannot be null.");
        }
        RemoteConfigElement.AuthenticatorDescriptor descriptor = this.remoteConfig.getAuthenticatorDescriptor(id);
        if (descriptor == null) {
            throw new ConnectorServiceException("Unable to find authenticator for id: " + id);
        }
        return ConnectorService.buildAuthenticator(descriptor.getImplementationClass());
    }

    public ConnectorSession getConnectorSession(HttpSession session, String endpointId) {
        if (session == null) {
            throw new IllegalArgumentException("HttpSession cannot be null.");
        }
        String key = ConnectorService.getSessionEndpointKey(endpointId);
        ConnectorSession cs = (ConnectorSession)session.getAttribute(key);
        if (cs == null) {
            cs = new ConnectorSession(key);
            session.setAttribute(key, (Object)cs);
        }
        return cs;
    }

    public void removeConnectorSession(HttpSession session, String endpointId) {
        if (session == null) {
            throw new IllegalArgumentException("HttpSession cannot be null.");
        }
        String key = ConnectorService.getSessionEndpointKey(endpointId);
        session.removeAttribute(key);
    }

    public CredentialVault getCredentialVault(HttpSession session, String userId) throws CredentialVaultProviderException {
        return this.getCredentialVault(session, userId, null);
    }

    public CredentialVault getCredentialVault(HttpSession session, String userId, String vaultProviderId) throws CredentialVaultProviderException {
        CredentialVaultProvider provider;
        if (session == null) {
            throw new IllegalArgumentException("HttpSession cannot be null.");
        }
        if (userId == null) {
            throw new IllegalArgumentException("UserId is mandatory.");
        }
        if (vaultProviderId == null) {
            vaultProviderId = this.getRemoteConfig().getDefaultCredentialVaultProviderId();
        }
        if ((provider = (CredentialVaultProvider)this.applicationContext.getBean(vaultProviderId)) == null) {
            throw new CredentialVaultProviderException("Unable to find credential vault provider: " + vaultProviderId);
        }
        String cacheKey = PREFIX_VAULT_SESSION + provider.generateKey(vaultProviderId, userId);
        CredentialVault vault = (CredentialVault)session.getAttribute(cacheKey);
        if (vault == null) {
            vault = provider.provide(userId);
            vault.load();
            session.setAttribute(cacheKey, (Object)vault);
        }
        return vault;
    }

    private static Authenticator buildAuthenticator(String className) throws ConnectorServiceException {
        Authenticator auth = (Authenticator)ReflectionHelper.newObject((String)className);
        if (auth == null) {
            throw new ConnectorServiceException("Unable to instantiate Authenticator: " + className);
        }
        return auth;
    }

    private static Connector buildConnector(RemoteConfigElement.ConnectorDescriptor descriptor, String url) {
        Class[] argTypes = new Class[]{descriptor.getClass(), url.getClass()};
        Object[] args = new Object[]{descriptor, url};
        return (Connector)ReflectionHelper.newObject((String)descriptor.getImplementationClass(), (Class[])argTypes, (Object[])args);
    }

    private static String getSessionEndpointKey(String endpointId) {
        return PREFIX_CONNECTOR_SESSION + endpointId;
    }

    private RemoteConfigElement getRemoteConfig() {
        return (RemoteConfigElement)this.configService.getConfig((Object)"Remote").getConfigElement("remote");
    }
}

