/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.extensions.webscripts.connector.ResponseStatus;

public class Response {
    private String data;
    private InputStream is;
    private ResponseStatus status;
    private String encoding = null;

    Response(ResponseStatus status) {
        this.status = status;
    }

    Response(String data, ResponseStatus status) {
        this.data = data;
        this.status = status;
    }

    Response(InputStream is, ResponseStatus status) {
        this.is = is;
        this.status = status;
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getResponse() {
        return this.data;
    }

    public String getText() {
        return this.getResponse();
    }

    public InputStream getResponseStream() {
        try {
            return this.is != null ? this.is : new ByteArrayInputStream(this.data.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException: " + this.encoding);
        }
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return this.data;
    }
}

