/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;

public class SimpleCredentialVault
implements CredentialVault,
Serializable {
    public String id;
    public Map<String, Credentials> credentialsMap = new HashMap<String, Credentials>(8, 1.0f);

    public SimpleCredentialVault(String id) {
        this.id = id;
    }

    public void store(Credentials credentials) {
        this.credentialsMap.put(credentials.getEndpointId(), credentials);
    }

    public Credentials retrieve(String endpointId) {
        return this.credentialsMap.get(endpointId);
    }

    public void remove(String endpointId) {
        this.credentialsMap.remove(endpointId);
    }

    public boolean hasCredentials(String endpointId) {
        return this.retrieve(endpointId) != null;
    }

    public String[] getStoredIds() {
        return this.credentialsMap.keySet().toArray(new String[this.credentialsMap.size()]);
    }

    public Credentials newCredentials(String endpointId) {
        CredentialsImpl credentials = new CredentialsImpl(endpointId);
        this.store(credentials);
        return credentials;
    }

    public boolean load() {
        return true;
    }

    public boolean save() {
        return true;
    }

    public String toString() {
        return "SimpleCredentialVault - " + this.id;
    }
}

