/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.jsf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlFormRendererBase;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptResponseImpl;
import org.springframework.extensions.webscripts.jsf.UIWebScript;
import org.springframework.extensions.webscripts.ui.common.JSFUtils;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class WebScriptJSFResponse
extends WebScriptResponseImpl
implements WebScriptResponse {
    private FacesContext fc;
    private UIWebScript component;
    private static final String ENCODE_SCRIPT_URL_FUNCTION = "{ $name$: function(url) { var out = ''; out += \"#\\\" onclick=\\\"document.forms['$formClientId$']['$fieldId$'].value='\"; out += escape(url); out += \"';document.forms['$formClientId$'].submit();return false;\"; return out; } }";
    private static final String ENCODE_RESOURCE_URL_FUNCTION = "{ $name$: function(url) { return url; } }";

    WebScriptJSFResponse(Runtime container, FacesContext fc, UIWebScript component) {
        super(container);
        this.fc = fc;
        this.component = component;
    }

    public String encodeScriptUrl(String url) {
        UIForm form = JSFUtils.getParentForm(this.fc, (UIComponent)this.component);
        if (form == null) {
            throw new IllegalStateException("Must nest components inside UIForm to generate form submit!");
        }
        String fieldId = this.component.getClientId(this.fc);
        String formClientId = form.getClientId(this.fc);
        StringBuilder buf = new StringBuilder(256);
        buf.append("#\" onclick=\"");
        buf.append("document.forms[");
        buf.append("'");
        buf.append(formClientId);
        buf.append("'");
        buf.append("]['");
        buf.append(fieldId);
        buf.append("'].value=");
        buf.append("'");
        buf.append(URLEncoder.encode((String)url));
        buf.append("'");
        buf.append(";");
        buf.append("document.forms[");
        buf.append("'");
        buf.append(formClientId);
        buf.append("'");
        buf.append("].submit();");
        buf.append("return false;");
        HtmlFormRendererBase.addHiddenCommandParameter((FacesContext)this.fc, (UIComponent)form, (String)fieldId);
        return buf.toString();
    }

    public void reset() {
    }

    public OutputStream getOutputStream() throws IOException {
        return this.fc.getResponseStream();
    }

    public Writer getWriter() throws IOException {
        return this.fc.getResponseWriter();
    }

    public void setStatus(int status) {
    }

    public void setHeader(String name, String value) {
    }

    public void addHeader(String name, String value) {
    }

    public void setCache(Cache cache) {
    }

    public void setContentType(String contentType) {
    }

    public void setContentEncoding(String contentEncoding) {
    }

    public String getEncodeScriptUrlFunction(String name) {
        UIForm form = JSFUtils.getParentForm(this.fc, (UIComponent)this.component);
        if (form == null) {
            throw new IllegalStateException("Must nest components inside UIForm to generate form submit!");
        }
        String fieldId = this.component.getClientId(this.fc);
        String formClientId = form.getClientId(this.fc);
        HtmlFormRendererBase.addHiddenCommandParameter((FacesContext)this.fc, (UIComponent)form, (String)fieldId);
        String func = ENCODE_SCRIPT_URL_FUNCTION.replace("$name$", name);
        func = func.replace("$formClientId$", formClientId);
        func = func.replace("$fieldId$", fieldId);
        return StringUtils.encodeJavascript(func);
    }

    public String encodeResourceUrl(String url) {
        return url;
    }

    public String getEncodeResourceUrlFunction(String name) {
        String func = ENCODE_RESOURCE_URL_FUNCTION.replace("$name$", name);
        return StringUtils.encodeJavascript(func);
    }
}

