/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public final class JSONWriter {
    private Writer out;
    private Stack<Boolean> stack = new Stack();

    public JSONWriter(Writer out) {
        this.out = out;
        this.stack.push(Boolean.FALSE);
    }

    public void startArray() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("[");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
    }

    public void endArray() throws IOException {
        this.out.write("]");
        this.stack.pop();
    }

    public void startObject() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("{");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
    }

    public void endObject() throws IOException {
        this.out.write("}");
        this.stack.pop();
    }

    public void startValue(String name) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
    }

    public void endValue() {
        this.stack.pop();
    }

    public void writeValue(String name, String value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": \"");
        this.out.write(JSONWriter.encodeJSONString(value));
        this.out.write(34);
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeValue(String name, int value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Integer.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeValue(String name, float value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Float.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeValue(String name, boolean value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Boolean.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeValue(String value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", \"");
        }
        this.out.write(JSONWriter.encodeJSONString(value));
        this.out.write(34);
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeValue(int value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Integer.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeValue(float value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Float.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeValue(boolean value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Boolean.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeNullValue() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("null");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public void writeNullValue(String name) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": null");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
    }

    public static String encodeJSONString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            String enc = null;
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    enc = "\\\\";
                    break;
                }
                case '\"': {
                    enc = "\\\"";
                    break;
                }
                case '/': {
                    enc = "\\/";
                    break;
                }
                case '\b': {
                    enc = "\\b";
                    break;
                }
                case '\t': {
                    enc = "\\t";
                    break;
                }
                case '\n': {
                    enc = "\\n";
                    break;
                }
                case '\f': {
                    enc = "\\f";
                    break;
                }
                case '\r': {
                    enc = "\\r";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    String u = "000" + Integer.toHexString(c);
                    enc = "\\u" + u.substring(u.length() - 4);
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = s.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }
}

