/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jooreports.converter.DocumentFamily;

public class DocumentFormat {
    private String name;
    private DocumentFamily family;
    private String mimeType;
    private String fileExtension;
    private Map exportFilters = new HashMap();
    private Map exportOptions = new HashMap();

    public DocumentFormat() {
    }

    public DocumentFormat(String name, String mimeType, String extension) {
        this.name = name;
        this.mimeType = mimeType;
        this.fileExtension = extension;
    }

    public DocumentFormat(String name, DocumentFamily family, String mimeType, String extension) {
        this.name = name;
        this.family = family;
        this.mimeType = mimeType;
        this.fileExtension = extension;
    }

    public String getName() {
        return this.name;
    }

    public DocumentFamily getFamily() {
        return this.family;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getExportFilter(DocumentFamily family) {
        return (String)this.exportFilters.get(family);
    }

    public boolean isImportable() {
        return this.family != null;
    }

    public boolean isExportOnly() {
        return !this.isImportable();
    }

    public boolean isExportableTo(DocumentFormat otherFormat) {
        return otherFormat.isExportableFrom(this.family);
    }

    public boolean isExportableFrom(DocumentFamily family) {
        return this.exportFilters.containsKey(family);
    }

    public void setExportFilter(DocumentFamily family, String filter) {
        this.exportFilters.put(family, filter);
    }

    public void setExportOption(String name, Object value) {
        this.exportOptions.put(name, value);
    }

    public Map getExportOptions() {
        if (this.exportOptions == null) {
            return Collections.EMPTY_MAP;
        }
        return this.exportOptions;
    }
}

