/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.converter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.basic.AbstractBasicConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import net.sf.jooreports.converter.BasicDocumentFormatRegistry;
import net.sf.jooreports.converter.DocumentFamily;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import org.apache.commons.io.IOUtils;

public class XmlDocumentFormatRegistry
extends BasicDocumentFormatRegistry
implements DocumentFormatRegistry {
    private static final String DEFAULT_CONFIGURATION = "/" + (class$net$sf$jooreports$converter$XmlDocumentFormatRegistry == null ? (class$net$sf$jooreports$converter$XmlDocumentFormatRegistry = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.XmlDocumentFormatRegistry")) : class$net$sf$jooreports$converter$XmlDocumentFormatRegistry).getPackage().getName().replace('.', '/') + "/document-formats.xml";
    static /* synthetic */ Class class$net$sf$jooreports$converter$XmlDocumentFormatRegistry;
    static /* synthetic */ Class class$net$sf$jooreports$converter$DocumentFormat;
    static /* synthetic */ Class class$net$sf$jooreports$converter$DocumentFamily;

    public XmlDocumentFormatRegistry() {
        this.load(this.getClass().getResourceAsStream(DEFAULT_CONFIGURATION));
    }

    public XmlDocumentFormatRegistry(InputStream inputStream) {
        this.load(inputStream);
    }

    private void load(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        XStream xstream = this.createXStream();
        try {
            ObjectInputStream in = xstream.createObjectInputStream((Reader)new InputStreamReader(inputStream));
            try {
                while (true) {
                    this.addDocumentFormat((DocumentFormat)in.readObject());
                }
            }
            catch (EOFException endOfFile) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException("invalid registry configuration", exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
        }
    }

    private XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.setMode(1001);
        xstream.alias("document-format", class$net$sf$jooreports$converter$DocumentFormat == null ? (class$net$sf$jooreports$converter$DocumentFormat = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.DocumentFormat")) : class$net$sf$jooreports$converter$DocumentFormat);
        xstream.aliasField("mime-type", class$net$sf$jooreports$converter$DocumentFormat == null ? (class$net$sf$jooreports$converter$DocumentFormat = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.DocumentFormat")) : class$net$sf$jooreports$converter$DocumentFormat, "mimeType");
        xstream.aliasField("file-extension", class$net$sf$jooreports$converter$DocumentFormat == null ? (class$net$sf$jooreports$converter$DocumentFormat = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.DocumentFormat")) : class$net$sf$jooreports$converter$DocumentFormat, "fileExtension");
        xstream.aliasField("export-filters", class$net$sf$jooreports$converter$DocumentFormat == null ? (class$net$sf$jooreports$converter$DocumentFormat = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.DocumentFormat")) : class$net$sf$jooreports$converter$DocumentFormat, "exportFilters");
        xstream.aliasField("export-options", class$net$sf$jooreports$converter$DocumentFormat == null ? (class$net$sf$jooreports$converter$DocumentFormat = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.DocumentFormat")) : class$net$sf$jooreports$converter$DocumentFormat, "exportOptions");
        xstream.alias("family", class$net$sf$jooreports$converter$DocumentFamily == null ? (class$net$sf$jooreports$converter$DocumentFamily = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.DocumentFamily")) : class$net$sf$jooreports$converter$DocumentFamily);
        xstream.registerConverter((Converter)new AbstractBasicConverter(){

            public boolean canConvert(Class type) {
                return type.equals(class$net$sf$jooreports$converter$DocumentFamily == null ? (class$net$sf$jooreports$converter$DocumentFamily = XmlDocumentFormatRegistry.class$("net.sf.jooreports.converter.DocumentFamily")) : class$net$sf$jooreports$converter$DocumentFamily);
            }

            protected Object fromString(String name) {
                return DocumentFamily.getFamily(name);
            }
        });
        return xstream;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

