/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.openoffice.connection;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.net.ConnectException;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOpenOfficeConnection
implements OpenOfficeConnection,
XEventListener {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String connectionString;
    private XComponent bridgeComponent;
    private XMultiComponentFactory serviceManager;
    private XComponentContext componentContext;
    private boolean connected = false;
    private boolean expectingDisconnection = false;
    static /* synthetic */ Class class$com$sun$star$connection$XConnector;
    static /* synthetic */ Class class$com$sun$star$bridge$XBridgeFactory;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiComponentFactory;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$uno$XComponentContext;
    static /* synthetic */ Class class$com$sun$star$frame$XComponentLoader;
    static /* synthetic */ Class class$com$sun$star$ucb$XFileIdentifierConverter;

    protected AbstractOpenOfficeConnection(String connectionString) {
        this.connectionString = connectionString;
    }

    public synchronized void connect() throws ConnectException {
        this.logger.debug((Object)"connecting");
        try {
            XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory localServiceManager = localContext.getServiceManager();
            XConnector connector = (XConnector)UnoRuntime.queryInterface((Class)(class$com$sun$star$connection$XConnector == null ? (class$com$sun$star$connection$XConnector = AbstractOpenOfficeConnection.class$("com.sun.star.connection.XConnector")) : class$com$sun$star$connection$XConnector), (Object)localServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", localContext));
            XConnection connection = connector.connect(this.connectionString);
            XBridgeFactory bridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$bridge$XBridgeFactory == null ? (class$com$sun$star$bridge$XBridgeFactory = AbstractOpenOfficeConnection.class$("com.sun.star.bridge.XBridgeFactory")) : class$com$sun$star$bridge$XBridgeFactory), (Object)localServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", localContext));
            XBridge bridge = bridgeFactory.createBridge("", "urp", connection, null);
            this.bridgeComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = AbstractOpenOfficeConnection.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)bridge);
            this.bridgeComponent.addEventListener((XEventListener)this);
            this.serviceManager = (XMultiComponentFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiComponentFactory == null ? (class$com$sun$star$lang$XMultiComponentFactory = AbstractOpenOfficeConnection.class$("com.sun.star.lang.XMultiComponentFactory")) : class$com$sun$star$lang$XMultiComponentFactory), (Object)bridge.getInstance("StarOffice.ServiceManager"));
            XPropertySet properties = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = AbstractOpenOfficeConnection.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.serviceManager);
            this.componentContext = (XComponentContext)UnoRuntime.queryInterface((Class)(class$com$sun$star$uno$XComponentContext == null ? (class$com$sun$star$uno$XComponentContext = AbstractOpenOfficeConnection.class$("com.sun.star.uno.XComponentContext")) : class$com$sun$star$uno$XComponentContext), (Object)properties.getPropertyValue("DefaultContext"));
            this.connected = true;
            this.logger.info((Object)"connected");
        }
        catch (NoConnectException connectException) {
            throw new ConnectException("connection failed: " + this.connectionString + ": " + connectException.getMessage());
        }
        catch (Exception exception) {
            throw new OpenOfficeException("connection failed: " + this.connectionString, exception);
        }
    }

    public synchronized void disconnect() {
        this.logger.debug((Object)"disconnecting");
        this.expectingDisconnection = true;
        this.bridgeComponent.dispose();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disposing(EventObject event) {
        this.connected = false;
        if (this.expectingDisconnection) {
            this.logger.info((Object)"disconnected");
        } else {
            this.logger.error((Object)"disconnected unexpectedly");
        }
        this.expectingDisconnection = false;
    }

    void simulateUnexpectedDisconnection() {
        this.disposing(null);
        this.bridgeComponent.dispose();
    }

    private Object getService(String className) {
        try {
            if (!this.connected) {
                this.logger.info((Object)"trying to (re)connect");
                this.connect();
            }
            return this.serviceManager.createInstanceWithContext(className, this.componentContext);
        }
        catch (Exception exception) {
            throw new OpenOfficeException("could not obtain service: " + className, exception);
        }
    }

    public XComponentLoader getDesktop() {
        return (XComponentLoader)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XComponentLoader == null ? (class$com$sun$star$frame$XComponentLoader = AbstractOpenOfficeConnection.class$("com.sun.star.frame.XComponentLoader")) : class$com$sun$star$frame$XComponentLoader), (Object)this.getService("com.sun.star.frame.Desktop"));
    }

    public XFileIdentifierConverter getFileContentProvider() {
        return (XFileIdentifierConverter)UnoRuntime.queryInterface((Class)(class$com$sun$star$ucb$XFileIdentifierConverter == null ? (class$com$sun$star$ucb$XFileIdentifierConverter = AbstractOpenOfficeConnection.class$("com.sun.star.ucb.XFileIdentifierConverter")) : class$com$sun$star$ucb$XFileIdentifierConverter), (Object)this.getService("com.sun.star.ucb.FileContentProvider"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

