/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.farng.mp3.AbstractMP3FileItem;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.object.AbstractMP3Object;

public abstract class AbstractMP3FragmentBody
extends AbstractMP3FileItem {
    private static final int SIZE_OBJECT_LIST = 16;
    private static final int SIZE_BRIEF_DESCRIPTION = 64;
    private static final int SIZE_DESCRIPTION = 256;
    private List objectList = new ArrayList(16);

    protected AbstractMP3FragmentBody() {
        this.setupObjectList();
    }

    protected AbstractMP3FragmentBody(AbstractMP3FragmentBody copyObject) {
        super(copyObject);
        Iterator iterator = copyObject.iterator();
        while (iterator.hasNext()) {
            AbstractMP3Object oldObject = (AbstractMP3Object)iterator.next();
            AbstractMP3Object newObject = (AbstractMP3Object)TagUtility.copyObject(oldObject);
            this.objectList.add(newObject);
        }
    }

    public String getBriefDescription() {
        StringBuffer stringBuffer = new StringBuffer(64);
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            String objectToString = object.toString();
            if (objectToString == null || objectToString.length() <= 0) continue;
            String identifier = object.getIdentifier();
            stringBuffer.append(identifier);
            stringBuffer.append("=\"");
            stringBuffer.append(objectToString);
            stringBuffer.append("\"; ");
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer(256);
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            String identifier = object.getIdentifier();
            stringBuffer.append(identifier);
            stringBuffer.append(" = ");
            String string = object.toString();
            stringBuffer.append(string);
            stringBuffer.append(TagConstant.SEPERATOR_LINE);
        }
        String toString = stringBuffer.toString();
        return toString.trim();
    }

    public Iterator getObjectListIterator() {
        return this.objectList.listIterator();
    }

    public void setObject(String identifier, Object object) {
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)iterator.next();
            String currentIdentifier = abstractMP3Object.getIdentifier();
            if (!currentIdentifier.equals(identifier)) continue;
            abstractMP3Object.setValue(object);
        }
    }

    public Object getObject(String identifier) {
        Object object = null;
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)iterator.next();
            String currentIdentifier = abstractMP3Object.getIdentifier();
            if (!currentIdentifier.equals(identifier)) continue;
            object = abstractMP3Object.getValue();
        }
        return object;
    }

    public int getSize() {
        int size = 0;
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            size += object.getSize();
        }
        return size;
    }

    public boolean isSubsetOf(Object object) {
        if (!super.isSubsetOf(object)) {
            return false;
        }
        if (!(object instanceof AbstractMP3FragmentBody)) {
            return false;
        }
        List superset = ((AbstractMP3FragmentBody)object).objectList;
        int objectListSize = this.objectList.size();
        for (int i = 0; i < objectListSize; ++i) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)this.objectList.get(i);
            if (abstractMP3Object.getValue() == null || superset.contains(abstractMP3Object)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractMP3FragmentBody)) {
            return false;
        }
        AbstractMP3FragmentBody abstractMP3FragmentBody = (AbstractMP3FragmentBody)obj;
        if (!((Object)this.objectList).equals(abstractMP3FragmentBody.objectList)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        return this.objectList.iterator();
    }

    protected void appendToObjectList(AbstractMP3Object object) {
        this.objectList.add(object);
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        int size = this.readHeader(file);
        byte[] buffer = new byte[size];
        file.read(buffer);
        ListIterator iterator = this.objectList.listIterator();
        int offset = 0;
        while (iterator.hasNext()) {
            if (offset > size - 1) {
                throw new InvalidTagException("Invalid size for Frame Body");
            }
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            object.readByteArray(buffer, offset);
            offset += object.getSize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        String thisIdentifier = this.getIdentifier();
        stringBuffer.append(thisIdentifier);
        stringBuffer.append(TagConstant.SEPERATOR_LINE);
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            String objectIdentifier = object.getIdentifier();
            stringBuffer.append(objectIdentifier);
            stringBuffer.append(" = ");
            String string = object.toString();
            stringBuffer.append(string);
            stringBuffer.append(TagConstant.SEPERATOR_LINE);
        }
        return stringBuffer.toString();
    }

    public void write(RandomAccessFile file) throws IOException {
        int size = this.getSize();
        this.writeHeader(file, size);
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            byte[] buffer = object.writeByteArray();
            file.write(buffer);
        }
    }

    protected abstract int readHeader(RandomAccessFile var1) throws IOException, InvalidTagException;

    protected abstract void setupObjectList();

    protected abstract void writeHeader(RandomAccessFile var1, int var2) throws IOException;

    protected static boolean has6ByteHeader() {
        Exception exception = new Exception();
        StackTraceElement[] stackArray = exception.getStackTrace();
        String id3v2_2name = ID3v2_2.class.getName();
        String id3v2_3name = ID3v2_3.class.getName();
        String id3v2_4name = ID3v2_4.class.getName();
        boolean has6ByteHeader = false;
        boolean withinTag = false;
        for (int i = stackArray.length - 1; i >= 0; --i) {
            String className = stackArray[i].getClassName();
            if (id3v2_2name.equals(className)) {
                has6ByteHeader = true;
                withinTag = true;
                continue;
            }
            if (id3v2_3name.equals(className)) {
                has6ByteHeader = false;
                withinTag = true;
                continue;
            }
            if (!id3v2_4name.equals(className)) continue;
            has6ByteHeader = false;
            withinTag = true;
        }
        if (!withinTag) {
            throw new UnsupportedOperationException("FragmentBody not called within ID3v2 tag.");
        }
        return has6ByteHeader;
    }
}

