/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectGroupRepeated;
import org.farng.mp3.object.ObjectNumberFixedLength;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;

public class FrameBodyEQU2
extends AbstractID3v2FrameBody {
    public FrameBodyEQU2() {
    }

    public FrameBodyEQU2(FrameBodyEQU2 body) {
        super(body);
    }

    public FrameBodyEQU2(byte interpolationMethod, String owner, short frequency, short volumeAdjustment) {
        this.setObject("Interpolation Method", new Byte(interpolationMethod));
        this.setObject("Owner", owner);
        this.addGroup(frequency, volumeAdjustment);
    }

    public FrameBodyEQU2(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public String getIdentifier() {
        return "EQU2\u0000" + this.getOwner();
    }

    public String getOwner() {
        return (String)this.getObject("Owner");
    }

    public void getOwner(String description) {
        this.setObject("Owner", description);
    }

    public void addGroup(short frequency, short volumeAdjustment) {
        ObjectGroupRepeated group = (ObjectGroupRepeated)this.getObject("Data");
        ObjectNumberFixedLength freq = new ObjectNumberFixedLength("Frequency", 2);
        ObjectNumberFixedLength volume = new ObjectNumberFixedLength("Volume Adjustment", 2);
        group.addObject(freq);
        group.addObject(volume);
        this.setObject("Data", group);
    }

    protected void setupObjectList() {
        this.appendToObjectList(new ObjectNumberHashMap("Interpolation Method", 1));
        this.appendToObjectList(new ObjectStringNullTerminated("Owner"));
        ObjectGroupRepeated group = new ObjectGroupRepeated("Data");
        group.addProperty(new ObjectNumberFixedLength("Frequency", 2));
        group.addProperty(new ObjectNumberFixedLength("Volume Adjustment", 2));
        this.appendToObjectList(group);
    }
}

