/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3Line;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class FrameBodySYLT
extends AbstractID3v2FrameBody {
    LinkedList lines = new LinkedList();
    String description = "";
    String language = "";
    byte contentType = 0;
    byte textEncoding = 0;
    byte timeStampFormat = 0;

    public FrameBodySYLT() {
    }

    public FrameBodySYLT(FrameBodySYLT copyObject) {
        super(copyObject);
        this.description = new String(copyObject.description);
        this.language = new String(copyObject.language);
        this.contentType = copyObject.contentType;
        this.textEncoding = copyObject.textEncoding;
        this.timeStampFormat = copyObject.timeStampFormat;
        for (int i = 0; i < copyObject.lines.size(); ++i) {
            ObjectID3v2LyricLine newLine = new ObjectID3v2LyricLine((ObjectID3v2LyricLine)copyObject.lines.get(i));
            this.lines.add(newLine);
        }
    }

    public FrameBodySYLT(byte textEncoding, String language, byte timeStampFormat, byte contentType, String description) {
        this.textEncoding = textEncoding;
        this.language = language;
        this.timeStampFormat = timeStampFormat;
        this.contentType = contentType;
        this.description = description;
    }

    public FrameBodySYLT(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public byte getContentType() {
        return this.contentType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return "SYLT";
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLyric() {
        String lyrics = "";
        for (int i = 0; i < this.lines.size(); ++i) {
            lyrics = lyrics + this.lines.get(i);
        }
        return lyrics;
    }

    public int getSize() {
        int size = 6 + this.description.length();
        for (int i = 0; i < this.lines.size(); ++i) {
            size += ((ObjectID3v2LyricLine)this.lines.get(i)).getSize();
        }
        return size;
    }

    public byte getTextEncoding() {
        return this.textEncoding;
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void addLyric(int timeStamp, String text) {
        ObjectID3v2LyricLine line = new ObjectID3v2LyricLine("Lyric Line");
        line.setTimeStamp(timeStamp);
        line.setText(text);
        this.lines.add(line);
    }

    public void addLyric(ObjectLyrics3Line line) {
        Iterator iterator = line.getTimeStamp();
        String lyric = line.getLyric();
        ObjectID3v2LyricLine id3Line = new ObjectID3v2LyricLine("Lyric Line");
        if (!iterator.hasNext()) {
            long time = 0L;
            id3Line.setTimeStamp(time);
            id3Line.setText(lyric);
            this.lines.add(id3Line);
        } else {
            while (iterator.hasNext()) {
                ObjectLyrics3TimeStamp timeStamp = (ObjectLyrics3TimeStamp)iterator.next();
                long time = timeStamp.getMinute() * 60L + timeStamp.getSecond();
                id3Line.setTimeStamp(time *= 1000L);
                id3Line.setText(lyric);
                this.lines.add(id3Line);
            }
        }
    }

    public void equals() {
        throw new UnsupportedOperationException("Method equals() not yet implemented.");
    }

    public Iterator iterator() {
        return this.lines.iterator();
    }

    protected void setupObjectList() {
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        int offset = 0;
        int size = this.readHeader(file);
        byte[] buffer = new byte[size];
        file.read(buffer);
        String str = new String(buffer);
        this.textEncoding = buffer[offset++];
        this.language = str.substring(offset, offset + 3);
        offset += 3;
        this.timeStampFormat = buffer[offset++];
        this.contentType = buffer[offset++];
        int delim = str.indexOf(0, offset);
        this.description = str.substring(offset, delim);
        offset = delim + 1;
        byte[] data = new byte[size - offset];
        System.arraycopy(buffer, offset, data, 0, size - offset);
        this.readByteArray(data);
    }

    public void readByteArray(byte[] arr) {
        int offset = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != 0) continue;
            int delim = i;
            byte[] line = new byte[offset - delim + 4];
            System.arraycopy(arr, offset, line, 0, offset - delim + 4);
            this.lines.add(new ObjectID3v2LyricLine("Lyric Line"));
            i += 4;
            offset += 4;
        }
    }

    public String toString() {
        String str = this.getIdentifier() + " " + this.textEncoding + " " + this.language + " " + this.timeStampFormat + " " + this.contentType + " " + this.description;
        for (int i = 0; i < this.lines.size(); ++i) {
            str = str + this.lines.get(i).toString();
        }
        return str;
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        int offset = 0;
        this.writeHeader(file, this.getSize());
        byte[] buffer = new byte[this.getSize()];
        buffer[offset++] = this.textEncoding;
        this.language = TagUtility.truncate(this.language, 3);
        for (i = 0; i < this.language.length(); ++i) {
            buffer[i + offset] = (byte)this.language.charAt(i);
        }
        offset += this.language.length();
        buffer[offset++] = this.timeStampFormat;
        buffer[offset++] = this.contentType;
        for (i = 0; i < this.description.length(); ++i) {
            buffer[i + offset] = (byte)this.description.charAt(i);
        }
        offset += this.description.length();
        buffer[offset++] = 0;
        System.arraycopy(this.writeByteArray(), 0, buffer, offset, buffer.length - offset);
        file.write(buffer);
    }

    public byte[] writeByteArray() {
        int i;
        ObjectID3v2LyricLine line = null;
        int offset = 0;
        int size = 0;
        for (i = 0; i < this.lines.size(); ++i) {
            line = (ObjectID3v2LyricLine)this.lines.get(i);
            size += line.getSize();
        }
        byte[] arr = new byte[size];
        for (i = 0; i < this.lines.size(); ++i) {
            line = (ObjectID3v2LyricLine)this.lines.get(i);
        }
        if (line != null) {
            System.arraycopy(line.writeByteArray(), 0, arr, offset, line.getSize());
            offset += line.getSize();
        }
        return arr;
    }
}

