/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectLyrics3Line;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;
import org.farng.mp3.object.ObjectStringSizeTerminated;

public class FrameBodyUSLT
extends AbstractID3v2FrameBody {
    public FrameBodyUSLT() {
    }

    public FrameBodyUSLT(FrameBodyUSLT body) {
        super(body);
    }

    public FrameBodyUSLT(byte textEncoding, String language, String description, String text) {
        this.setObject("Text Encoding", new Byte(textEncoding));
        this.setObject("Language", language);
        this.setObject("Description", description);
        this.setObject("Lyrics/Text", text);
    }

    public FrameBodyUSLT(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public void setDescription(String description) {
        this.setObject("Description", description);
    }

    public String getDescription() {
        return (String)this.getObject("Description");
    }

    public String getIdentifier() {
        return "USLT\u0000" + this.getLanguage() + '\u0000' + this.getDescription();
    }

    public void setLanguage(String language) {
        this.setObject("Language", language);
    }

    public String getLanguage() {
        return (String)this.getObject("Language");
    }

    public void setLyric(String lyric) {
        this.setObject("Lyrics/Text", lyric);
    }

    public String getLyric() {
        return (String)this.getObject("Lyrics/Text");
    }

    public void addLyric(String text) {
        this.setLyric(this.getLyric() + text);
    }

    public void addLyric(ObjectLyrics3Line line) {
        this.setLyric(this.getLyric() + line.writeString());
    }

    protected void setupObjectList() {
        this.appendToObjectList(new ObjectNumberHashMap("Text Encoding", 1));
        this.appendToObjectList(new ObjectStringHashMap("Language", 3));
        this.appendToObjectList(new ObjectStringNullTerminated("Description"));
        this.appendToObjectList(new ObjectStringSizeTerminated("Lyrics/Text"));
    }
}

