/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.filename.FilenameTag;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTDRC;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v1_1;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.id3.ID3v2_4Frame;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.Lyrics3v2;
import org.farng.mp3.lyrics3.Lyrics3v2Field;

public class ID3v2_4
extends ID3v2_3 {
    protected boolean footer = false;
    protected boolean tagRestriction = false;
    protected boolean updateTag = false;
    protected byte imageEncodingRestriction = 0;
    protected byte imageSizeRestriction = 0;
    protected byte tagSizeRestriction = 0;
    protected byte textEncodingRestriction = 0;
    protected byte textFieldSizeRestriction = 0;

    public ID3v2_4() {
        this.setMajorVersion((byte)2);
        this.setRevision((byte)4);
    }

    public ID3v2_4(ID3v2_4 copyObject) {
        super(copyObject);
        this.footer = copyObject.footer;
        this.tagRestriction = copyObject.tagRestriction;
        this.updateTag = copyObject.updateTag;
        this.imageEncodingRestriction = copyObject.imageEncodingRestriction;
        this.imageSizeRestriction = copyObject.imageSizeRestriction;
        this.tagSizeRestriction = copyObject.tagSizeRestriction;
        this.textEncodingRestriction = copyObject.textEncodingRestriction;
        this.textFieldSizeRestriction = copyObject.textFieldSizeRestriction;
    }

    public ID3v2_4(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof AbstractID3v2) {
                this.copyFromID3v2Tag((AbstractID3v2)mp3tag);
            } else if (mp3tag instanceof ID3v1) {
                ID3v2_4Frame newFrame;
                AbstractID3v2FrameBody newBody;
                ID3v1 id3tag = (ID3v1)mp3tag;
                if (id3tag.title.length() > 0) {
                    newBody = new FrameBodyTIT2(0, id3tag.title);
                    newFrame = new ID3v2_4Frame(false, false, false, false, false, false, newBody);
                    this.setFrame(newFrame);
                }
                if (id3tag.artist.length() > 0) {
                    newBody = new FrameBodyTPE1(0, id3tag.artist);
                    newFrame = new ID3v2_4Frame(false, false, false, false, false, false, newBody);
                    this.setFrame(newFrame);
                }
                if (id3tag.album.length() > 0) {
                    newBody = new FrameBodyTALB(0, id3tag.album);
                    newFrame = new ID3v2_4Frame(false, false, false, false, false, false, newBody);
                    this.setFrame(newFrame);
                }
                if (id3tag.year.length() > 0) {
                    newBody = new FrameBodyTDRC(0, id3tag.year);
                    newFrame = new ID3v2_4Frame(false, false, false, false, false, false, newBody);
                    this.setFrame(newFrame);
                }
                if (id3tag.comment.length() > 0) {
                    newBody = new FrameBodyCOMM(0, "ENG", "", id3tag.comment);
                    newFrame = new ID3v2_4Frame(false, false, false, false, false, false, newBody);
                    this.setFrame(newFrame);
                }
                if (id3tag.genre >= 0) {
                    String genre = "(" + Byte.toString(id3tag.genre) + ") " + TagConstant.genreIdToString.get(new Long(id3tag.genre));
                    newBody = new FrameBodyTCON(0, genre);
                    newFrame = new ID3v2_4Frame(false, false, false, false, false, false, newBody);
                    this.setFrame(newFrame);
                }
                if (mp3tag instanceof ID3v1_1) {
                    ID3v1_1 id3tag2 = (ID3v1_1)mp3tag;
                    if (id3tag2.track > 0) {
                        newBody = new FrameBodyTRCK(0, Byte.toString(id3tag2.track));
                        newFrame = new ID3v2_4Frame(false, false, false, false, false, false, newBody);
                        this.setFrame(newFrame);
                    }
                }
            } else if (mp3tag instanceof AbstractLyrics3) {
                Lyrics3v2 lyric = mp3tag instanceof Lyrics3v2 ? new Lyrics3v2((Lyrics3v2)mp3tag) : new Lyrics3v2(mp3tag);
                Iterator iterator = lyric.iterator();
                while (iterator.hasNext()) {
                    try {
                        Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
                        ID3v2_4Frame newFrame = new ID3v2_4Frame(field);
                        this.setFrame(newFrame);
                    }
                    catch (InvalidTagException ex) {}
                }
            } else if (mp3tag instanceof FilenameTag) {
                this.copyFromID3v2Tag(((FilenameTag)mp3tag).getId3tag());
            }
        }
    }

    public ID3v2_4(RandomAccessFile file) throws TagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "ID3v2.40";
    }

    public int getSize() {
        int size = 10;
        if (this.extended) {
            size += 6;
            if (this.updateTag) {
                ++size;
            }
            if (this.crcDataFlag) {
                size += 5;
            }
            if (this.tagRestriction) {
                size += 2;
            }
        }
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
            size += frame.getSize();
        }
        return size;
    }

    public void append(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_4) {
            this.updateTag = ((ID3v2_4)tag).updateTag;
            this.footer = ((ID3v2_4)tag).footer;
            this.tagRestriction = ((ID3v2_4)tag).tagRestriction;
            this.tagSizeRestriction = ((ID3v2_4)tag).tagSizeRestriction;
            this.textEncodingRestriction = ((ID3v2_4)tag).textEncodingRestriction;
            this.textFieldSizeRestriction = ((ID3v2_4)tag).textFieldSizeRestriction;
            this.imageEncodingRestriction = ((ID3v2_4)tag).imageEncodingRestriction;
            this.imageSizeRestriction = ((ID3v2_4)tag).imageSizeRestriction;
        }
        super.append(tag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2_4)) {
            return false;
        }
        ID3v2_4 id3v2_4 = (ID3v2_4)obj;
        if (this.footer != id3v2_4.footer) {
            return false;
        }
        if (this.imageEncodingRestriction != id3v2_4.imageEncodingRestriction) {
            return false;
        }
        if (this.imageSizeRestriction != id3v2_4.imageSizeRestriction) {
            return false;
        }
        if (this.tagRestriction != id3v2_4.tagRestriction) {
            return false;
        }
        if (this.tagSizeRestriction != id3v2_4.tagSizeRestriction) {
            return false;
        }
        if (this.textEncodingRestriction != id3v2_4.textEncodingRestriction) {
            return false;
        }
        if (this.textFieldSizeRestriction != id3v2_4.textFieldSizeRestriction) {
            return false;
        }
        if (this.updateTag != id3v2_4.updateTag) {
            return false;
        }
        return super.equals(obj);
    }

    public void overwrite(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_4) {
            this.updateTag = ((ID3v2_4)tag).updateTag;
            this.footer = ((ID3v2_4)tag).footer;
            this.tagRestriction = ((ID3v2_4)tag).tagRestriction;
            this.tagSizeRestriction = ((ID3v2_4)tag).tagSizeRestriction;
            this.textEncodingRestriction = ((ID3v2_4)tag).textEncodingRestriction;
            this.textFieldSizeRestriction = ((ID3v2_4)tag).textFieldSizeRestriction;
            this.imageEncodingRestriction = ((ID3v2_4)tag).imageEncodingRestriction;
            this.imageSizeRestriction = ((ID3v2_4)tag).imageSizeRestriction;
        }
        super.overwrite(tag);
    }

    public void read(RandomAccessFile file) throws TagException, IOException {
        byte[] buffer = new byte[4];
        file.seek(0L);
        if (!this.seek(file)) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        file.read(buffer, 0, 3);
        if (buffer[0] != 4 || buffer[1] != 0) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        this.setMajorVersion(buffer[0]);
        this.setRevision(buffer[1]);
        this.unsynchronization = (buffer[2] & 0x80) != 0;
        this.extended = (buffer[2] & 0x40) != 0;
        this.experimental = (buffer[2] & 0x20) != 0;
        this.footer = (buffer[2] & 0x10) != 0;
        file.read(buffer, 0, 4);
        int size = ID3v2_4.byteArrayToSize(buffer);
        long filePointer = file.getFilePointer();
        if (this.extended) {
            int len;
            int extendedHeaderSize = file.readInt();
            if (extendedHeaderSize <= 6) {
                throw new InvalidTagException("Invalid Extended Header Size.");
            }
            byte numberOfFlagBytes = file.readByte();
            file.read(buffer, 0, numberOfFlagBytes);
            this.updateTag = (buffer[0] & 0x40) != 0;
            this.crcDataFlag = (buffer[0] & 0x20) != 0;
            boolean bl = this.tagRestriction = (buffer[0] & 0x10) != 0;
            if (this.updateTag) {
                len = file.readByte();
                buffer = new byte[len];
                file.read(buffer, 0, len);
            }
            if (this.crcDataFlag) {
                len = file.readByte();
                buffer = new byte[len];
                file.read(buffer, 0, len);
                this.crcData = 0;
                for (int i = 0; i < len; ++i) {
                    this.crcData <<= 8;
                    this.crcData += buffer[i];
                }
            }
            if (this.tagRestriction) {
                len = file.readByte();
                buffer = new byte[len];
                file.read(buffer, 0, len);
                this.tagSizeRestriction = (byte)((buffer[0] & 0xFFFFFFC0) >> 6);
                this.textEncodingRestriction = (byte)((buffer[0] & 0x20) >> 5);
                this.textFieldSizeRestriction = (byte)((buffer[0] & 0x18) >> 3);
                this.imageEncodingRestriction = (byte)((buffer[0] & 4) >> 2);
                this.imageSizeRestriction = (byte)(buffer[0] & 6);
            }
        }
        this.clearFrameMap();
        this.setFileReadBytes(size);
        ID3v2_4.resetPaddingCounter();
        while (file.getFilePointer() - filePointer <= (long)size) {
            try {
                ID3v2_4Frame next = new ID3v2_4Frame(file);
                String id = next.getIdentifier();
                if (this.hasFrame(id)) {
                    this.appendDuplicateFrameId(id + "; ");
                    this.incrementDuplicateBytes(this.getFrame(id).getSize());
                }
                this.setFrame(next);
            }
            catch (InvalidTagException ex) {
                if (ex.getMessage().equals("Found empty frame")) {
                    this.incrementEmptyFrameBytes(10);
                    continue;
                }
                this.incrementInvalidFrameBytes();
            }
        }
        this.setPaddingSize(ID3v2_4.getPaddingCounter());
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        file.seek(0L);
        file.read(buffer, 0, 3);
        String tag = new String(buffer, 0, 3);
        if (!tag.equals("ID3")) {
            return false;
        }
        file.read(buffer, 0, 2);
        file.seek(file.getFilePointer() - 2L);
        return buffer[0] == 4 && buffer[1] == 0;
    }

    public String toString() {
        Iterator iterator = this.getFrameIterator();
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        str = str + "compression              = " + this.compression + "\n";
        str = str + "unsynchronization        = " + this.unsynchronization + "\n";
        str = str + "crcData                  = " + this.crcData + "\n";
        str = str + "crcDataFlag              = " + this.crcDataFlag + "\n";
        str = str + "experimental             = " + this.experimental + "\n";
        str = str + "extended                 = " + this.extended + "\n";
        str = str + "paddingSize              = " + this.paddingSize + "\n";
        str = str + "footer                   = " + this.footer + "\n";
        str = str + "imageEncodingRestriction = " + this.imageEncodingRestriction + "\n";
        str = str + "imageSizeRestriction     = " + this.imageSizeRestriction + "\n";
        str = str + "tagRestriction           = " + this.tagRestriction + "\n";
        str = str + "tagSizeRestriction       = " + this.tagSizeRestriction + "\n";
        str = str + "textEncodingRestriction  = " + this.textEncodingRestriction + "\n";
        str = str + "textFieldSizeRestriction = " + this.textFieldSizeRestriction + "\n";
        str = str + "updateTag                = " + this.updateTag + "\n";
        while (iterator.hasNext()) {
            ID3v2_4Frame frame = (ID3v2_4Frame)iterator.next();
            str = str + frame.toString() + "\n";
        }
        return str + "\n";
    }

    public void write(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_4) {
            this.updateTag = ((ID3v2_4)tag).updateTag;
            this.footer = ((ID3v2_4)tag).footer;
            this.tagRestriction = ((ID3v2_4)tag).tagRestriction;
            this.tagSizeRestriction = ((ID3v2_4)tag).tagSizeRestriction;
            this.textEncodingRestriction = ((ID3v2_4)tag).textEncodingRestriction;
            this.textFieldSizeRestriction = ((ID3v2_4)tag).textFieldSizeRestriction;
            this.imageEncodingRestriction = ((ID3v2_4)tag).imageEncodingRestriction;
            this.imageSizeRestriction = ((ID3v2_4)tag).imageSizeRestriction;
        }
        super.write(tag);
    }

    public void write(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[6];
        MP3File mp3 = new MP3File();
        mp3.seekMP3Frame(file);
        long mp3start = file.getFilePointer();
        file.seek(0L);
        String str = "ID3";
        for (int i = 0; i < str.length(); ++i) {
            buffer[i] = (byte)str.charAt(i);
        }
        buffer[3] = 4;
        buffer[4] = 0;
        if (this.unsynchronization) {
            buffer[5] = (byte)(buffer[5] | 0x80);
        }
        if (this.extended) {
            buffer[5] = (byte)(buffer[5] | 0x40);
        }
        if (this.experimental) {
            buffer[5] = (byte)(buffer[5] | 0x20);
        }
        if (this.footer) {
            buffer[5] = (byte)(buffer[5] | 0x10);
        }
        file.write(buffer);
        file.write(ID3v2_4.sizeToByteArray((int)mp3start - 10));
        if (this.extended) {
            int size = 6;
            if (this.updateTag) {
                ++size;
            }
            if (this.crcDataFlag) {
                size += 5;
            }
            if (this.tagRestriction) {
                size += 2;
            }
            file.writeInt(size);
            file.writeByte(1);
            buffer[0] = 0;
            if (this.updateTag) {
                buffer[0] = (byte)(buffer[0] | 0x40);
            }
            if (this.crcDataFlag) {
                buffer[0] = (byte)(buffer[0] | 0x20);
            }
            if (this.tagRestriction) {
                buffer[0] = (byte)(buffer[0] | 0x10);
            }
            file.writeByte(buffer[0]);
            if (this.updateTag) {
                file.writeByte(0);
            }
            if (this.crcDataFlag) {
                file.writeByte(4);
                file.writeInt(this.crcData);
            }
            if (this.tagRestriction) {
                file.writeByte(1);
                buffer[0] = 0;
                if (this.tagRestriction) {
                    buffer[0] = (byte)(buffer[0] | 0xFFFFFFC0);
                }
                file.writeByte(this.tagSizeRestriction);
                file.writeByte(this.textEncodingRestriction);
                file.writeByte(this.textFieldSizeRestriction);
                file.writeByte(this.imageEncodingRestriction);
                file.writeByte(this.imageSizeRestriction);
                file.writeByte(buffer[0]);
            }
        }
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            ID3v2_4Frame frame = (ID3v2_4Frame)iterator.next();
            frame.write(file);
        }
    }

    private void copyFromID3v2Tag(AbstractID3v2 mp3tag) {
        AbstractID3v2 id3tag;
        if (mp3tag instanceof ID3v2_4) {
            ID3v2_4 tag = (ID3v2_4)mp3tag;
            this.footer = tag.footer;
            this.tagRestriction = tag.tagRestriction;
            this.updateTag = tag.updateTag;
            this.imageEncodingRestriction = tag.imageEncodingRestriction;
            this.imageSizeRestriction = tag.imageSizeRestriction;
            this.tagSizeRestriction = tag.tagSizeRestriction;
            this.textEncodingRestriction = tag.textEncodingRestriction;
            this.textFieldSizeRestriction = tag.textFieldSizeRestriction;
        }
        if (mp3tag instanceof ID3v2_3) {
            id3tag = (ID3v2_3)mp3tag;
            this.extended = ((ID3v2_3)id3tag).extended;
            this.experimental = ((ID3v2_3)id3tag).experimental;
            this.crcDataFlag = ((ID3v2_3)id3tag).crcDataFlag;
            this.crcData = ((ID3v2_3)id3tag).crcData;
            this.paddingSize = ((ID3v2_3)id3tag).paddingSize;
        }
        if (mp3tag instanceof ID3v2_2) {
            id3tag = (ID3v2_2)mp3tag;
            this.compression = ((ID3v2_2)id3tag).compression;
            this.unsynchronization = ((ID3v2_2)id3tag).unsynchronization;
        }
        id3tag = mp3tag;
        Iterator iterator = id3tag.getFrameIterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
            ID3v2_4Frame newFrame = new ID3v2_4Frame(frame);
            this.setFrame(newFrame);
        }
    }

    public String getYearReleased() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TDRC");
        if (frame != null) {
            FrameBodyTDRC body = (FrameBodyTDRC)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public void setYearReleased(String yearReleased) {
        AbstractID3v2Frame field = this.getFrame("TDRC");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTDRC(0, yearReleased));
            this.setFrame(field);
        } else {
            ((FrameBodyTDRC)field.getBody()).setText(yearReleased);
        }
    }
}

