/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectBooleanString
extends AbstractMP3Object {
    public ObjectBooleanString(String identifier) {
        this.identifier = identifier;
    }

    public ObjectBooleanString(ObjectBooleanString object) {
        super(object);
    }

    public int getSize() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectBooleanString)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readString(String str, int offset) {
        if (str == null) {
            throw new NullPointerException("String is null");
        }
        if (offset < 0 || offset >= str.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + offset + ", string.length()" + str.length());
        }
        char ch = str.charAt(offset);
        this.value = new Boolean(ch != '0');
    }

    public String toString() {
        return "" + this.value;
    }

    public String writeString() {
        if (this.value == null) {
            return "0";
        }
        return (Boolean)this.value != false ? "1" : "0";
    }
}

