/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jndi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.alfresco.filter.CacheControlFilter;
import org.alfresco.jndi.NamingContextBindingsEnumeration;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.util.JNDIPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMFileDirContext
extends FileDirContext {
    protected static String AVMFileDirMountPoint_;
    String avmDocBase_;
    int avmRootVersion_;
    private static Log log;
    static AVMRemote Service_;
    static int Service_refcount_;
    protected boolean use_AVMRemote_ = false;
    protected boolean infer_webresources_from_docBase_ = false;

    public static final String getAVMFileDirMountPoint() {
        return AVMFileDirMountPoint_;
    }

    public static final void setAVMFileDirMountPoint(String mount_point) {
        if (AVMFileDirMountPoint_ == null) {
            AVMFileDirMountPoint_ = mount_point;
        }
    }

    public static synchronized void InitAVMRemote(AVMRemote service) {
        Service_ = service;
    }

    public static synchronized void ReleaseAVMRemote() {
        log.debug((Object)("AVMFileDirContext.ReleaseAVMRemote() refcount now: " + --Service_refcount_));
        if (Service_refcount_ == 0) {
            log.debug((Object)"AVMFileDirContext.ReleaseAVMRemote() closing FileSystemXmlApplicationContext (refcount dropped to 0)");
            Service_ = null;
        }
    }

    public static AVMRemote getAVMRemote() {
        return Service_;
    }

    protected void setUseAVMRemote(boolean tf) {
        this.use_AVMRemote_ = tf;
    }

    protected boolean getUseAVMRemote() {
        return this.use_AVMRemote_;
    }

    public AVMFileDirContext() {
        log.debug((Object)"AVMFileDirContext:  AVMFileDirContext()");
        this.infer_webresources_from_docBase_ = true;
    }

    public AVMFileDirContext(Hashtable env) {
        super(env);
        log.debug((Object)"AVMFileDirContext:  AVMFileDirContext(env)");
    }

    public void setDocBase(String docBase) {
        log.debug((Object)("AVMFileDirContext:  setDocBase(): " + docBase));
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        if (this.infer_webresources_from_docBase_ && docBase.startsWith(AVMFileDirMountPoint_)) {
            log.debug((Object)("AVMFileDirContext:  USING AVM for: " + docBase));
            this.use_AVMRemote_ = true;
        }
        if (!this.use_AVMRemote_) {
            super.setDocBase(docBase);
            return;
        }
        this.docBase = docBase;
        try {
            JNDIPath jndi_path = new JNDIPath(AVMFileDirMountPoint_, docBase);
            this.avmDocBase_ = jndi_path.getAvmPath();
            this.avmRootVersion_ = jndi_path.getAvmVersion();
            log.debug((Object)("AVMFileDirContext.setDocBase avmDocBase_    : " + this.avmDocBase_));
            log.debug((Object)("AVMFileDirContext.setDocBase avmRootVersion_: " + this.avmRootVersion_));
        }
        catch (Exception path_exception) {
            throw new IllegalArgumentException(this.sm.getString("fileResources.base", (Object)docBase), path_exception);
        }
    }

    void setDocBase(int rootVersion, String repoPath) {
        this.avmRootVersion_ = rootVersion;
        this.avmDocBase_ = repoPath;
    }

    public void allocate() {
        log.debug((Object)"AVMFileDirContext:  allocate()");
        if (this.use_AVMRemote_) {
            // empty if block
        }
        super.allocate();
    }

    public void release() {
        log.debug((Object)"AVMFileDirContext:  release()");
        if (this.use_AVMRemote_) {
            // empty if block
        }
        super.release();
    }

    public Object lookup(String name) throws NamingException {
        Object result;
        int name_index;
        if (!this.use_AVMRemote_) {
            log.debug((Object)("AVMFileDirContext:  lookup(): " + this.base + " + " + name));
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.lookup(name);
        }
        if (name.startsWith("/avm.alfresco.localhost/$") && (name_index = name.indexOf(47, "/avm.alfresco.localhost/$".length())) >= 0) {
            name = name.substring(name_index);
        }
        String repo_path = name.charAt(0) != '/' ? this.avmDocBase_ + "/" + name : this.avmDocBase_ + name;
        log.debug((Object)("AVMFileDirContext:  AVM lookup(): " + repo_path));
        AVMNodeDescriptor avm_node = null;
        try {
            CacheControlFilter.AddLookupDependency(repo_path);
            avm_node = Service_.lookup(this.avmRootVersion_, repo_path);
            if (avm_node == null) {
                log.debug((Object)("AVMFileDirContext:  lookup() not found: " + repo_path));
                throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
            }
        }
        catch (Exception e) {
            log.debug((Object)("AVMFileDirContext:  lookup() not found: " + repo_path));
            throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
        }
        if (avm_node.isDirectory()) {
            log.debug((Object)("AVMFileDirContext:  lookup creating AVMFileDirContext(env) for dir: " + avm_node.getPath()));
            AVMFileDirContext tempContext = new AVMFileDirContext(this.env);
            tempContext.setUseAVMRemote(this.use_AVMRemote_);
            tempContext.setDocBase(this.avmRootVersion_, avm_node.getPath());
            tempContext.setAllowLinking(this.getAllowLinking());
            tempContext.setCaseSensitive(this.isCaseSensitive());
            result = tempContext;
        } else {
            log.debug((Object)("AVMFileDirContext:  lookup creating AVMFileResource for file: " + avm_node.getPath()));
            result = new AVMFileResource(this.avmRootVersion_, avm_node.getPath());
        }
        return result;
    }

    public void unbind(String name) throws NamingException {
        String repo_path;
        log.debug((Object)("AVMFileDirContext:  unbind(): " + name));
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            super.unbind(name);
            return;
        }
        if (name.charAt(0) != '/') {
            repo_path = this.avmDocBase_ + "/" + name;
        } else {
            repo_path = this.avmDocBase_ + name;
            name = name.substring(1);
        }
        AVMNodeDescriptor avm_node = null;
        try {
            avm_node = Service_.lookup(this.avmRootVersion_, repo_path);
            if (avm_node == null) {
                throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
            }
        }
        catch (Exception e) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
        }
        if (this.avmRootVersion_ != -1) {
            throw new NamingException(this.sm.getString("resources.unbindFailed", (Object)repo_path));
        }
        try {
            Service_.removeNode(this.avmDocBase_, name);
        }
        catch (Exception e) {
            throw new NamingException(this.sm.getString("resources.unbindFailed", (Object)repo_path));
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        log.debug((Object)("AVMFileDirContext:  rename(): " + oldName + " " + newName));
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            super.rename(oldName, newName);
            return;
        }
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)("    AVMFileDirContext: using file system for list(): " + name));
            return super.list(name);
        }
        String repo_path = name.charAt(0) != '/' ? this.avmDocBase_ + "/" + name : this.avmDocBase_ + name;
        log.debug((Object)("    AVMFileDirContext list() using AVMRemote for: " + repo_path));
        AVMNodeDescriptor avm_node = null;
        try {
            avm_node = Service_.lookup(this.avmRootVersion_, repo_path);
            if (avm_node == null) {
                throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
            }
        }
        catch (Exception e) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
        }
        return new NamingContextEnumeration(this.avm_list(avm_node, true).iterator());
    }

    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(name, true);
    }

    public NamingEnumeration<Binding> listBindings(String name, boolean include_background) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)("AVMFileDirContext:  listBindings() file system: " + this.base + " + " + name));
            return super.listBindings(name);
        }
        String repo_path = name.charAt(0) != '/' ? this.avmDocBase_ + "/" + name : this.avmDocBase_ + name;
        AVMNodeDescriptor avm_node = null;
        log.debug((Object)("AVMFileDirContext:  listBindings() AVM: " + repo_path));
        try {
            avm_node = Service_.lookup(this.avmRootVersion_, repo_path);
            if (avm_node == null) {
                throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
            }
        }
        catch (Exception e) {
            throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
        }
        return new NamingContextBindingsEnumeration(this.avm_list(avm_node, include_background).iterator(), (Context)((Object)this));
    }

    public void destroySubcontext(String name) throws NamingException {
        log.debug((Object)("AVMFileDirContext:  destroySubcontext(): " + name));
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            super.destroySubcontext(name);
            return;
        }
        this.unbind(name);
    }

    public Object lookupLink(String name) throws NamingException {
        log.debug((Object)("AVMFileDirContext:  lokupLink(): " + name));
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.lookupLink(name);
        }
        return this.lookup(name);
    }

    public String getNameInNamespace() throws NamingException {
        log.debug((Object)"AVMFileDirContext:  getNameInNamespace()");
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.getNameInNamespace();
        }
        return this.docBase;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        String repo_path;
        if (!this.use_AVMRemote_) {
            log.debug((Object)("    AVMFileDirContext.getAttributes(): using file system for: " + name));
            return super.getAttributes(name, attrIds);
        }
        if (name.charAt(0) != '/') {
            repo_path = this.avmDocBase_ + "/" + name;
        } else {
            repo_path = this.avmDocBase_ + name;
            name = name.substring(1);
        }
        log.debug((Object)("AVMFileDirContext: getAttributes(): " + repo_path));
        AVMNodeDescriptor avm_node = null;
        try {
            avm_node = Service_.lookup(this.avmRootVersion_, repo_path);
            if (avm_node == null) {
                log.debug((Object)("AVMFileDirContext:  lookup() not found: " + repo_path));
                throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
            }
        }
        catch (Exception e) {
            log.debug((Object)("AVMFileDirContext:  lookup() not found: " + repo_path));
            throw new NamingException(this.sm.getString("resources.notFound", (Object)repo_path));
        }
        return new AVMFileResourceAttributes(avm_node, name);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            super.modifyAttributes(name, mod_op, attrs);
            return;
        }
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            super.modifyAttributes(name, mods);
            return;
        }
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        log.debug((Object)("AVMFileDirContext:  bind(): " + name));
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            super.bind(name, obj, attrs);
            return;
        }
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", (Object)name));
        }
        this.rebind(name, obj, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        log.debug((Object)("AVMFileDirContext:  rebind(): " + name));
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            super.rebind(name, obj, attrs);
            return;
        }
        File file = new File(this.base, name);
        InputStream is = null;
        if (obj instanceof Resource) {
            try {
                is = ((Resource)obj).streamContent();
            }
            catch (IOException e) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        } else if (obj instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", (Object)name));
            }
            if (!file.mkdir()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", (Object)name));
            }
        }
        if (is == null) {
            throw new NamingException(this.sm.getString("resources.bindFailed", (Object)name));
        }
        try {
            FileOutputStream os = null;
            byte[] buffer = new byte[2048];
            int len = -1;
            try {
                os = new FileOutputStream(file);
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
        }
        catch (IOException e) {
            throw new NamingException(this.sm.getString("resources.bindFailed", (Object)e));
        }
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        log.debug((Object)("AVMFileDirContext:  createSubcontext(): " + name));
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.createSubcontext(name, attrs);
        }
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", (Object)name));
        }
        if (!file.mkdir()) {
            throw new NamingException(this.sm.getString("resources.bindFailed", (Object)name));
        }
        return (DirContext)this.lookup(name);
    }

    public DirContext getSchema(String name) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.getSchema(name);
        }
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.getSchemaClassDefinition(name);
        }
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.search(name, matchingAttributes, attributesToReturn);
        }
        return null;
    }

    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.search(name, matchingAttributes);
        }
        return null;
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.search(name, filter, cons);
        }
        return null;
    }

    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        if (!this.use_AVMRemote_) {
            log.debug((Object)"    AVMFileDirContext: using file system");
            return super.search(name, filterExpr, filterArgs, cons);
        }
        return null;
    }

    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filterExpr, filterArgs, cons);
    }

    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filter, cons);
    }

    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name.toString(), matchingAttributes);
    }

    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(name.toString(), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    protected ArrayList<NamingEntry> avm_list(AVMNodeDescriptor avm_node, boolean include_background) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        if (!avm_node.isDirectory()) {
            return entries;
        }
        SortedMap avm_entries = null;
        try {
            if (include_background) {
                avm_entries = Service_.getDirectoryListing(avm_node);
            } else {
                String fg_path = avm_node.getPath();
                log.debug((Object)("AVMFileDirContext getDirectoryListingDirect: " + fg_path));
                avm_entries = Service_.getDirectoryListingDirect(this.avmRootVersion_, fg_path);
            }
        }
        catch (Exception e) {
            return entries;
        }
        NamingEntry entry = null;
        for (Map.Entry avm_entry : avm_entries.entrySet()) {
            String child_name = (String)avm_entry.getKey();
            AVMNodeDescriptor child_node = (AVMNodeDescriptor)avm_entry.getValue();
            Object object = null;
            if (child_node.isDirectory()) {
                AVMFileDirContext tempContext = new AVMFileDirContext(this.env);
                tempContext.setDocBase(this.avmRootVersion_, child_node.getPath());
                tempContext.setAllowLinking(this.getAllowLinking());
                tempContext.setCaseSensitive(this.isCaseSensitive());
                object = tempContext;
            } else {
                object = new AVMFileResource(this.avmRootVersion_, child_node.getPath());
            }
            entry = new NamingEntry(child_name, object, 0);
            entries.add(entry);
        }
        return entries;
    }

    protected File file(String name) {
        File file = new File(this.base, name);
        if (file.exists() && file.canRead()) {
            if (this.allowLinking) {
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (canPath == null) {
                return null;
            }
            if (this.absoluteBase == null) {
                return null;
            }
            if (!canPath.startsWith(this.absoluteBase)) {
                return null;
            }
            if (this.caseSensitive) {
                String fileAbsPath = file.getAbsolutePath();
                if (fileAbsPath.endsWith(".")) {
                    fileAbsPath = fileAbsPath + "/";
                }
                String absPath = this.normalize(fileAbsPath);
                if (canPath != null) {
                    canPath = this.normalize(canPath);
                }
                if (this.absoluteBase.length() < absPath.length() && this.absoluteBase.length() < canPath.length()) {
                    absPath = absPath.substring(this.absoluteBase.length() + 1);
                    if (canPath == null || absPath == null) {
                        return null;
                    }
                    if (absPath.equals("")) {
                        absPath = "/";
                    }
                    if ((canPath = canPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                        canPath = "/";
                    }
                    if (!canPath.equals(absPath)) {
                        return null;
                    }
                }
            }
        } else {
            return null;
        }
        return file;
    }

    static {
        log = LogFactory.getLog(AVMFileDirContext.class);
        Service_refcount_ = 0;
    }

    protected class AVMFileResource
    extends Resource {
        protected long length = -1L;
        protected int root_version_;
        protected String resource_path_;

        public AVMFileResource(int root_version, String resource_path) {
            this.root_version_ = root_version;
            this.resource_path_ = resource_path;
        }

        public InputStream streamContent() throws IOException {
            return Service_.getFileInputStream(this.root_version_, this.resource_path_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AVMFileResourceAttributes
    extends ResourceAttributes {
        AVMNodeDescriptor avm_node_;
        String name_;
        String type_;
        protected boolean accessed = false;
        protected String canonicalPath = null;

        public AVMFileResourceAttributes(AVMNodeDescriptor avm_node, String name) {
            this.avm_node_ = avm_node;
            this.name_ = name;
        }

        public NamingEnumeration<String> getIDs() {
            log.debug((Object)"AVMFileResourceAttributes.getIDs()");
            return super.getIDs();
        }

        public NamingEnumeration<? extends Attribute> getAll() {
            log.debug((Object)"AVMFileResourceAttributes.getAll()");
            return super.getAll();
        }

        public boolean isCollection() {
            log.debug((Object)"AVMFileResourceAttributes.isCollection()");
            return this.avm_node_.isDirectory();
        }

        public long getContentLength() {
            log.debug((Object)"AVMFileResourceAttributes.getContentLength()");
            return this.avm_node_.getLength();
        }

        public long getCreation() {
            log.debug((Object)"AVMFileResourceAttributes.getCreation()");
            this.creation = this.avm_node_.getCreateDate();
            return this.creation;
        }

        public Date getCreationDate() {
            log.debug((Object)"AVMFileResourceAttributes.getCreationDate()");
            if (this.creationDate == null) {
                this.creationDate = new Date(this.avm_node_.getCreateDate());
            }
            return this.creationDate;
        }

        public long getLastModified() {
            log.debug((Object)"AVMFileResourceAttributes.getLastModified()");
            CacheControlFilter.AddLookupDependency(this.getCanonicalPath());
            return this.avm_node_.getModDate();
        }

        public Date getLastModifiedDate() {
            log.debug((Object)"AVMFileResourceAttributes.getLastModifiedDate()");
            if (this.lastModifiedDate == null) {
                this.lastModifiedDate = new Date(this.avm_node_.getModDate());
            }
            return this.lastModifiedDate;
        }

        public String getName() {
            return this.name_;
        }

        public String getResourceType() {
            if (this.type_ == null) {
                switch (this.avm_node_.getType()) {
                    case 0: {
                        this.type_ = "PLAIN_FILE";
                        break;
                    }
                    case 2: {
                        this.type_ = "PLAIN_DIRECTORY";
                        break;
                    }
                    case 1: {
                        this.type_ = "LAYERED_FILE";
                        break;
                    }
                    case 3: {
                        this.type_ = "LAYERED_DIRECTORY";
                        break;
                    }
                    default: {
                        this.type_ = "";
                    }
                }
            }
            return this.type_;
        }

        public String getCanonicalPath() {
            log.debug((Object)("AVMFileResourceAttributes.getCannonicalPath(): " + this.avm_node_.getPath()));
            return this.avm_node_.getPath();
        }
    }
}

