/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.hibernate;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jbpm.db.JbpmSession;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.identity.assignment.ExpressionSession;
import org.jbpm.identity.security.IdentityService;

public class IdentitySession
implements IdentityService,
ExpressionSession {
    private static final Log log = LogFactory.getLog(IdentitySession.class);
    Session session;
    private Transaction transaction;

    public IdentitySession(Session session) {
        this.session = session;
    }

    public IdentitySession() {
        JbpmSession currentJbpmSession = JbpmSession.getCurrentJbpmSession();
        if (currentJbpmSession == null || currentJbpmSession.getSession() == null || !currentJbpmSession.getSession().isOpen()) {
            throw new RuntimeException("no active JbpmSession to create an identity session");
        }
        this.session = currentJbpmSession.getSession();
    }

    public Object verify(String userName, String pwd) {
        Long userId = null;
        Query query = this.session.createQuery("select user.id from org.jbpm.identity.User as user where user.name = :userName and user.password = :password");
        query.setString("userName", userName);
        query.setString("password", pwd);
        userId = (Long)query.uniqueResult();
        return userId;
    }

    public User getUserById(Object userId) {
        return (User)this.session.load(User.class, (Serializable)((Long)userId));
    }

    public Session getSession() {
        return this.session;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void beginTransaction() {
        try {
            this.transaction = this.session.beginTransaction();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new RuntimeException("couldn't begin a transaction", e);
        }
    }

    public void commitTransaction() {
        if (this.transaction == null) {
            throw new RuntimeException("can't commit : no transaction started");
        }
        try {
            this.session.flush();
            this.transaction.commit();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new RuntimeException("couldn't commit transaction", e);
        }
        this.transaction = null;
    }

    public void rollbackTransaction() {
        if (this.transaction == null) {
            throw new RuntimeException("can't rollback : no transaction started");
        }
        try {
            this.transaction.rollback();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new RuntimeException("couldn't rollback transaction", e);
        }
        this.transaction = null;
    }

    public void commitTransactionAndClose() {
        this.commitTransaction();
        this.close();
    }

    public void rollbackTransactionAndClose() {
        this.rollbackTransaction();
        this.close();
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new RuntimeException("couldn't close the hibernate connection", e);
        }
    }

    public void saveUser(User user) {
        this.session.save((Object)user);
    }

    public void saveGroup(Group group) {
        this.session.save((Object)group);
    }

    public void saveEntity(Entity entity) {
        this.session.save((Object)entity);
    }

    public void saveMembership(Membership membership) {
        this.session.save((Object)membership);
    }

    public User loadUser(long userId) {
        return (User)this.session.load(User.class, (Serializable)new Long(userId));
    }

    public Group loadGroup(long groupId) {
        return (Group)this.session.load(Group.class, (Serializable)new Long(groupId));
    }

    public void deleteGroup(Group group) {
        this.session.delete((Object)group);
    }

    public void deleteUser(User user) {
        this.session.delete((Object)user);
    }

    public User getUserByName(String userName) {
        User user = null;
        Query query = this.session.createQuery("select u from org.jbpm.identity.User as u where u.name = :userName");
        query.setString("userName", userName);
        List users = query.list();
        if (users != null && users.size() > 0) {
            user = (User)users.get(0);
        }
        return user;
    }

    public Group getGroupByName(String groupName) {
        Group group = null;
        Query query = this.session.createQuery("select g from org.jbpm.identity.Group as g where g.name = :groupName");
        query.setString("groupName", groupName);
        List groups = query.list();
        if (groups != null && groups.size() > 0) {
            group = (Group)groups.get(0);
        }
        return group;
    }

    public List getUsers() {
        Query query = this.session.createQuery("select u from org.jbpm.identity.User as u");
        return query.list();
    }

    public List getGroupNamesByUserAndGroupType(String userName, String groupType) {
        Query query = this.session.createQuery("select membership.group.name from org.jbpm.identity.Membership as membership where membership.user.name = :userName   and membership.group.type = :groupType");
        query.setString("userName", userName);
        query.setString("groupType", groupType);
        return query.list();
    }

    public User getUserByGroupAndRole(String groupName, String role) {
        User user = null;
        Query query = this.session.createQuery("select m.user from org.jbpm.identity.Membership as m where m.group.name = :groupName and m.role = :role");
        query.setString("groupName", groupName);
        query.setString("role", role);
        user = (User)query.uniqueResult();
        return user;
    }
}

