/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.CredentialVaultProviderException;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.CredentialVault;

public final class FrameworkBean {
    private static Log logger = LogFactory.getLog(FrameworkBean.class);
    private Container webFrameworkContainer;
    private RemoteConfigElement remoteConfig;
    private ConnectorService connectorService;

    public void setWebFrameworkContainer(Container container) {
        this.webFrameworkContainer = container;
    }

    public void setRemoteConfig(RemoteConfigElement remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public static WebFrameworkServiceRegistry getServiceRegistry() {
        return ThreadLocalRequestContext.getRequestContext().getServiceRegistry();
    }

    public static WebFrameworkConfigElement getConfig() {
        return FrameworkBean.getServiceRegistry().getWebFrameworkConfiguration();
    }

    public static RenderService getRenderService() {
        return FrameworkBean.getServiceRegistry().getRenderService();
    }

    public static ResourceService getResourceService() {
        return FrameworkBean.getServiceRegistry().getResourceService();
    }

    public RemoteConfigElement.EndpointDescriptor getEndpoint(String endpointId) {
        return this.remoteConfig.getEndpointDescriptor(endpointId);
    }

    public Connector getConnector(String endpointId) throws ConnectorServiceException {
        return this.connectorService.getConnector(endpointId);
    }

    public Connector getConnector(RequestContext context, String endpointId) throws ConnectorServiceException {
        HttpSession httpSession = ServletUtil.getSession();
        return this.getConnector(httpSession, context.getUserId(), endpointId);
    }

    public Connector getConnector(HttpSession httpSession, String userId, String endpointId) throws ConnectorServiceException {
        return this.connectorService.getConnector(endpointId, userId, httpSession);
    }

    public CredentialVault getCredentialVault(HttpSession httpSession, String userId) {
        CredentialVault vault = null;
        try {
            vault = this.connectorService.getCredentialVault(httpSession, userId);
        }
        catch (CredentialVaultProviderException cvpe) {
            logger.error((Object)("Unable to retrieve credential vault for user: " + userId), (Throwable)cvpe);
        }
        return vault;
    }

    public CredentialVault getCredentialVault(RequestContext context, String userId) {
        HttpSession httpSession = ServletUtil.getSession(false);
        CredentialVault credentialVault = httpSession != null ? this.getCredentialVault(httpSession, userId) : null;
        return credentialVault;
    }

    public ConnectorSession getConnectorSession(RequestContext context, String endpointId) {
        HttpSession httpSession = ServletUtil.getSession();
        return this.connectorService.getConnectorSession(httpSession, endpointId);
    }

    public ConnectorSession getConnectorSession(HttpSession httpSession, String endpointId) {
        return this.connectorService.getConnectorSession(httpSession, endpointId);
    }

    public void removeConnectorSessions(RequestContext context) {
        try {
            HttpSession httpSession = ServletUtil.getSession();
            String[] endpointIds = this.remoteConfig.getEndpointIds();
            for (int i = 0; i < endpointIds.length; ++i) {
                this.connectorService.removeConnectorSession(httpSession, endpointIds[i]);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to remove connector sessions", (Throwable)ex);
        }
    }

    public void resetWebScripts() {
        if (this.webFrameworkContainer != null) {
            int previousCount = this.webFrameworkContainer.getRegistry().getWebScripts().size();
            int previousFailures = this.webFrameworkContainer.getRegistry().getFailures().size();
            this.webFrameworkContainer.reset();
            logger.info((Object)("Reset Web Scripts Registry; registered " + this.webFrameworkContainer.getRegistry().getWebScripts().size() + " Web Scripts.  Previously, there were " + previousCount + "."));
            int newFailures = this.webFrameworkContainer.getRegistry().getFailures().size();
            if (newFailures != 0 || previousFailures != 0) {
                logger.info((Object)("Warning: found " + newFailures + " broken Web Scripts.  Previously, there were " + previousFailures + "."));
            }
        }
    }

    public void logFullStacktrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        logger.error((Object)sw.toString());
    }
}

