/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.TemplateProcessorFactory;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.processor.AbstractScriptProcessor;

public class TemplateProcessorRegistrar
implements ApplicationContextAware {
    private static final String WEBSCRIPTS_TEMPLATE_REGISTRY_ID = "webframework.webscripts.registry.templateprocessor";
    private static final String TEMPLATES_TEMPLATE_REGISTRY_ID = "webframework.templates.registry.templateprocessor";
    private static final String WEBSCRIPTS_SEARCHPATH_ID = "webframework.webscripts.searchpath";
    private static final String TEMPLATES_SEARCHPATH_ID = "webframework.templates.searchpath";
    private ApplicationContext applicationContext;
    private TemplateProcessorRegistry webscriptsRegistry;
    private TemplateProcessorRegistry templatesRegistry;
    private TemplateProcessorFactory factory;
    private SearchPath webscriptsSearchPath;
    private SearchPath templatesSearchPath;
    private String name;
    private String extension;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setWebScriptsRegistry(TemplateProcessorRegistry webscriptsRegistry) {
        this.webscriptsRegistry = webscriptsRegistry;
    }

    public void setTemplatesRegistry(TemplateProcessorRegistry templatesRegistry) {
        this.templatesRegistry = templatesRegistry;
    }

    public void setFactory(TemplateProcessorFactory factory) {
        this.factory = factory;
    }

    public void setWebscriptsSearchPath(SearchPath webscriptsSearchPath) {
        this.webscriptsSearchPath = webscriptsSearchPath;
    }

    public void setTemplatesSearchPath(SearchPath templatesSearchPath) {
        this.templatesSearchPath = templatesSearchPath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void init() {
        if (this.webscriptsRegistry == null) {
            this.webscriptsRegistry = (TemplateProcessorRegistry)this.applicationContext.getBean(WEBSCRIPTS_TEMPLATE_REGISTRY_ID);
        }
        if (this.templatesRegistry == null) {
            this.templatesRegistry = (TemplateProcessorRegistry)this.applicationContext.getBean(TEMPLATES_TEMPLATE_REGISTRY_ID);
        }
        if (this.factory != null) {
            TemplateProcessor templateProcessor1 = this.factory.newInstance();
            if (this.webscriptsSearchPath == null) {
                this.webscriptsSearchPath = (SearchPath)this.applicationContext.getBean(WEBSCRIPTS_SEARCHPATH_ID);
            }
            if (templateProcessor1 instanceof AbstractScriptProcessor) {
                ((AbstractScriptProcessor)templateProcessor1).setSearchPath(this.webscriptsSearchPath);
            }
            this.webscriptsRegistry.registerTemplateProcessor(templateProcessor1, this.extension, this.name);
            TemplateProcessor templateProcessor2 = this.factory.newInstance();
            if (this.templatesSearchPath == null) {
                this.templatesSearchPath = (SearchPath)this.applicationContext.getBean(TEMPLATES_SEARCHPATH_ID);
            }
            if (templateProcessor2 instanceof AbstractScriptProcessor) {
                ((AbstractScriptProcessor)templateProcessor2).setSearchPath(this.templatesSearchPath);
            }
            this.templatesRegistry.registerTemplateProcessor(templateProcessor2, this.extension, this.name);
        }
    }
}

