/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.Map;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkView;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.types.Component;

public class ComponentView
extends AbstractWebFrameworkView {
    public ComponentView(WebFrameworkConfigElement webFrameworkConfiguration, ModelObjectService modelObjectService, ResourceService resourceService, RenderService renderService, TemplatesContainer templatesContainer) {
        super(webFrameworkConfiguration, modelObjectService, resourceService, renderService, templatesContainer);
    }

    public ComponentView(WebFrameworkServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    protected void renderView(RequestContext context) throws Exception {
        Map<String, String> uriTokens = this.getUriTokens();
        String mode = uriTokens.get("mode");
        String focus = uriTokens.get("focus");
        String scopeId = uriTokens.get("scopeId");
        String regionId = uriTokens.get("regionId");
        String sourceId = uriTokens.get("sourceId");
        if (scopeId == null) {
            scopeId = "global";
        }
        if (sourceId == null) {
            sourceId = "global";
        }
        if (regionId == null) {
            throw new RequestDispatchException("Region ID is missing");
        }
        RenderMode renderMode = RenderMode.VIEW;
        if (mode != null) {
            renderMode = RenderMode.valueOf(mode.toUpperCase());
        }
        RenderFocus renderFocus = RenderFocus.BODY;
        if (focus != null) {
            renderFocus = RenderFocus.valueOf(focus.toUpperCase());
        }
        String componentId = RenderUtil.generateComponentId(scopeId, regionId, sourceId);
        Component component = this.getObjectService().getComponent(componentId);
        if (component == null) {
            component = componentId.startsWith("/") ? this.getObjectService().getComponent(componentId.substring(1)) : this.getObjectService().getComponent("/" + componentId);
        }
        context.setRenderMode(renderMode);
        this.getRenderService().renderComponent(context, renderFocus, component, null, false);
    }
}

