/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.Locale;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkViewResolver;
import org.springframework.extensions.surf.mvc.PageView;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.PageType;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class PageTypeViewResolver
extends AbstractWebFrameworkViewResolver {
    private static final String PAGE_TYPE_PREFIX_OLD = "type/";
    private static final String PAGE_TYPE_PREFIX_DOCUMENTED = "pt/";
    private static final String _PAGE_TYPE_REQUEST_PARAMETERS = "pt";

    public PageTypeViewResolver() {
        this.addPrefix(PAGE_TYPE_PREFIX_OLD);
        this.addPrefix(PAGE_TYPE_PREFIX_DOCUMENTED);
        this.addReqParm(_PAGE_TYPE_REQUEST_PARAMETERS);
    }

    protected boolean canHandle(String viewName, Locale locale) {
        boolean canHandle = false;
        String pageTypeId = this.processView(viewName);
        if (pageTypeId != null) {
            PageType pageType = this.getModelObjectService().getPageType(pageTypeId);
            canHandle = pageType != null;
        }
        return canHandle;
    }

    protected Object getCacheKey(String viewName, Locale locale) {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        String requestedTheme = context.getParameter("theme");
        StringBuilder cacheKey = new StringBuilder(viewName);
        cacheKey.append("_");
        if (requestedTheme != null) {
            cacheKey.append(requestedTheme);
            cacheKey.append("_");
        }
        cacheKey.append(locale);
        return cacheKey.toString();
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        PageView view = null;
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        String pageTypeId = this.processView(viewName);
        if (pageTypeId != null) {
            Page page;
            String pageId = null;
            String themeId = context.getThemeId();
            Theme theme = this.getModelObjectService().getTheme(themeId);
            if (theme != null) {
                pageId = theme.getPageId(pageTypeId);
            }
            if (pageId == null) {
                pageId = this.getWebframeworkConfigElement().getDefaultPageTypeInstanceId(pageTypeId);
            }
            if (pageId == null) {
                pageId = this.getWebframeworkConfigElement().getDefaultPageTypeInstanceId("generic");
            }
            if ((page = this.lookupPage(pageId)) != null) {
                ThreadLocalRequestContext.getRequestContext().setPage(page);
                view = new PageView(this.getWebframeworkConfigElement(), this.getModelObjectService(), this.getWebFrameworkResourceService(), this.getWebFrameworkRenderService(), this.getTemplatesContainer());
                view.setUrl(pageId);
                view.setPage(page);
            }
        }
        return view;
    }
}

