/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.cache.ContentCache;
import org.springframework.extensions.surf.cache.ModelObjectCache;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.AbstractStoreObjectPersister;
import org.springframework.extensions.surf.util.ReflectionHelper;
import org.springframework.extensions.surf.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathStoreObjectPersister
extends AbstractStoreObjectPersister {
    private static Log logger = LogFactory.getLog(PathStoreObjectPersister.class);
    private final ModelObjectCache objectCache;
    private Set<String> noncachableObjectTypes = null;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public PathStoreObjectPersister() {
        this.objectCache = new ModelObjectCache(this.store, this.cacheDelay);
    }

    @Override
    public void init(ModelPersistenceContext context) {
        if (!this.store.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Store missing for persister: " + this.getId()));
            }
            this.disable();
        }
    }

    public void setNoncachableObjectTypes(Set<String> types) {
        this.noncachableObjectTypes = types;
    }

    @Override
    public boolean saveObject(ModelPersistenceContext context, ModelObject modelObject) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return false;
        }
        String content = modelObject.toXML();
        String oldPath = modelObject.getStoragePath();
        String path = this.generatePath(modelObject.getTypeId(), modelObject.getId());
        try {
            if (!modelObject.isSaved()) {
                this.store.createDocument(path, content);
                ModelPersisterInfo info = modelObject.getKey();
                info.setStoragePath(path);
                info.setSaved(true);
                this.cachePut(context, path, modelObject);
            } else if (!oldPath.equals(path)) {
                this.store.createDocument(path, content);
                modelObject.getKey().setStoragePath(path);
                modelObject.getKey().setSaved(true);
                this.cachePut(context, path, modelObject);
                this.cacheRemove(context, modelObject.getTypeId(), oldPath);
                this.store.removeDocument(oldPath);
            } else {
                this.store.updateDocument(oldPath, content);
                modelObject.getKey().setSaved(true);
                this.cachePut(context, modelObject);
            }
        }
        catch (IOException ex) {
            throw new ModelObjectPersisterException("Unable to save object: " + oldPath + " due to error: " + ex.getMessage(), ex);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ModelObject getObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        ModelObject obj;
        block13: {
            if (!this.isEnabled()) {
                return null;
            }
            String path = this.generatePath(objectTypeId, objectId);
            obj = this.cacheGet(context, path);
            if (obj == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loading object for path: " + path));
                }
                try {
                    if (this.store.hasDocument(path)) {
                        Document document;
                        block12: {
                            document = null;
                            try {
                                document = XMLUtil.parse(this.store.getDocument(path));
                            }
                            catch (Exception err) {
                                logger.warn((Object)("Failure to load model object for path: " + path), (Throwable)err);
                                if (!this.useCacheForType(objectTypeId)) break block12;
                                this.getCache(context, null).put(path, ModelObjectCache.ModelObjectSentinel.getInstance());
                            }
                        }
                        if (document != null) {
                            ModelPersisterInfo info = new ModelPersisterInfo(this.getId(), path, true);
                            String implClassName = this.getWebFrameworkConfiguration().getTypeDescriptor(objectTypeId).getImplementationClass();
                            obj = (ModelObject)ReflectionHelper.newObject((String)implClassName, (Class[])MODELOBJECT_CLASSES, (Object[])new Object[]{objectId, info, document});
                            if (obj == null) throw new ModelObjectPersisterException("Unable to construct object of class: " + implClassName);
                            obj.touch();
                            this.cachePut(context, path, obj);
                        }
                        break block13;
                    }
                    if (this.useCacheForType(objectTypeId)) {
                        this.getCache(context, null).put(path, ModelObjectCache.ModelObjectSentinel.getInstance());
                    }
                }
                catch (IOException err) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("IO Error: during getObject() " + err.getMessage()), (Throwable)err);
                    }
                }
                catch (Exception ex) {
                    throw new ModelObjectPersisterException("Failure to load model object for path: " + path, ex);
                }
            }
        }
        if (obj != ModelObjectCache.ModelObjectSentinel.getInstance()) return obj;
        return null;
    }

    private boolean useCacheForType(String objectTypeId) {
        boolean useCache = this.useCache;
        if (useCache && this.noncachableObjectTypes != null) {
            useCache = !this.noncachableObjectTypes.contains(objectTypeId);
        }
        return useCache;
    }

    protected void cachePut(ModelPersistenceContext context, String path, ModelObject obj) {
        if (this.useCacheForType(obj.getTypeId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Put into cache: " + path));
            }
            this.getCache(context, null).put(path, obj);
        }
    }

    @Override
    protected void cachePut(ModelPersistenceContext context, ModelObject obj) {
        if (this.useCacheForType(obj.getTypeId())) {
            String path = this.generatePath(obj.getTypeId(), obj.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Put into cache: " + path));
            }
            this.getCache(context, null).put(path, obj);
        }
    }

    @Override
    protected void cacheRemove(ModelPersistenceContext context, ModelObject obj) {
        if (this.useCacheForType(obj.getTypeId())) {
            String path = this.generatePath(obj.getTypeId(), obj.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Remove from cache: " + path));
            }
            this.getCache(context, null).remove(path);
        }
    }

    @Override
    protected void cacheRemove(ModelPersistenceContext context, String objectTypeId, String objectId) {
        if (this.useCacheForType(objectTypeId)) {
            String path = this.generatePath(objectTypeId, objectId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Remove from cache: " + path));
            }
            this.getCache(context, null).remove(path);
        }
    }

    protected ModelObject cacheGet(ModelPersistenceContext context, String path) {
        return this.getCache(context, null).get(path);
    }

    @Override
    protected ModelObject cacheGet(ModelPersistenceContext context, String objectTypeId, String objectId) {
        String path = this.generatePath(objectTypeId, objectId);
        return this.getCache(context, null).get(path);
    }

    @Override
    public Map<String, ModelObject> getAllObjects(ModelPersistenceContext context, String objectTypeId) throws ModelObjectPersisterException {
        return new HashMap<String, ModelObject>(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ModelObject getObjectByPath(ModelPersistenceContext context, String path) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting object for path: " + path));
        }
        ModelObject obj = null;
        try {
            if (!this.store.hasDocument(path)) return obj;
            Document document = XMLUtil.parse(this.store.getDocument(path));
            String objectTypeId = this.getObjectTypeId(document, path);
            if (objectTypeId != null) {
                String objectId = this.getObjectId(document, path);
                obj = this.createObject(document, objectTypeId, objectId, path);
                if (obj == null) throw new ModelObjectPersisterException("Unable to construct object for path: " + path);
                obj.touch();
                this.cachePut(context, path, obj);
                return obj;
            } else {
                logger.warn((Object)("Failed to calculate objectTypeId for path: " + path));
            }
            return obj;
        }
        catch (Exception ex) {
            throw new ModelObjectPersisterException("Failure to load model object for path: " + path, ex);
        }
    }

    @Override
    protected String getObjectId(Document doc, String path) {
        String id = doc.getRootElement().elementText("id");
        if (id == null && path != null) {
            if ((path = path.replace('\\', '/')).endsWith(".xml")) {
                path = path.substring(0, path.length() - 4);
            }
            id = path;
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash != -1) {
                id = path.substring(lastSlash + 1);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ContentCache<ModelObject> getCache(ModelPersistenceContext context, String bucket) {
        ContentCache<ModelObject> cache;
        block8: {
            int idx;
            String userId;
            cache = this.objectCache;
            String storeId = (String)context.getValue(ModelPersistenceContext.REPO_STOREID);
            if (storeId == null && (userId = context.getUserId()) != null && (idx = userId.indexOf(64)) != -1) {
                storeId = userId.substring(idx);
            }
            if (storeId != null) {
                this.cacheLock.readLock().lock();
                try {
                    cache = (ContentCache)this.caches.get(storeId);
                    if (cache != null) break block8;
                    this.cacheLock.readLock().unlock();
                    this.cacheLock.writeLock().lock();
                    try {
                        cache = this.createCache();
                        this.caches.put(storeId, cache);
                    }
                    finally {
                        this.cacheLock.readLock().lock();
                        this.cacheLock.writeLock().unlock();
                    }
                }
                finally {
                    this.cacheLock.readLock().unlock();
                }
            }
        }
        return cache;
    }

    @Override
    public synchronized void invalidateCache() {
        super.invalidateCache();
        this.objectCache.invalidate();
    }
}

