/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.AutowireService;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.CachedPersister;
import org.springframework.extensions.surf.persister.MultiObjectPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersisterService {
    private static final Log logger = LogFactory.getLog(PersisterService.class);
    private List<ModelObjectPersister> persisters;
    private AutowireService autowireService;
    private WebFrameworkConfigElement webFrameworkConfig;
    private HashMap<String, ModelObjectPersister> typeToPersisterMap = new HashMap();
    private HashMap<String, ModelObjectPersister> persisterIdToPersisterMap = new HashMap();

    public HashMap<String, ModelObjectPersister> getTypeToPersisterMap() {
        return this.typeToPersisterMap;
    }

    public HashMap<String, ModelObjectPersister> getPersisterIdToPersisterMap() {
        return this.persisterIdToPersisterMap;
    }

    public void init() throws Exception {
        for (WebFrameworkConfigElement.TypeDescriptor type : this.webFrameworkConfig.getTypes()) {
            boolean found = false;
            Iterator<ModelObjectPersister> _persisters = this.persisters.iterator();
            while (!found && _persisters.hasNext()) {
                String targetPersisterId = type.getPersisterId();
                ModelObjectPersister persister = _persisters.next();
                found = persister.getId().equals(targetPersisterId);
                this.typeToPersisterMap.put(type.getId(), persister);
            }
            if (found) continue;
            throw new ModelObjectPersisterException("Object type: \"" + type.getId() + "\" is configured to use a persister \"" + type.getPersisterId() + "\" that is not configured in the application context.");
        }
        this.autowireService.configureMode(this.webFrameworkConfig);
        WebFrameworkConfigElement.PersisterConfigDescriptor config = this.webFrameworkConfig.getPersisterConfigDescriptor();
        for (ModelObjectPersister persister : this.persisters) {
            this.persisterIdToPersisterMap.put(persister.getId(), persister);
            if (persister instanceof MultiObjectPersister) {
                MultiObjectPersister moPersister = (MultiObjectPersister)persister;
                this.autowireService.configureRuntime(this.webFrameworkConfig, moPersister);
                for (ModelObjectPersister p : moPersister.getPersisters()) {
                    this.persisterIdToPersisterMap.put(p.getId(), p);
                }
            }
            if (persister instanceof CachedPersister && config != null) {
                boolean cache = config.getCacheEnabled();
                int cacheCheckDelay = config.getCacheCheckDelay();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting global cache setting: " + cache + " delay: " + cacheCheckDelay + " onto persister: " + persister.getId()));
                }
                ((CachedPersister)((Object)persister)).setCache(cache);
                ((CachedPersister)((Object)persister)).setCacheCheckDelay(cacheCheckDelay);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initalising persister: " + persister.getId()));
            }
            persister.init(null);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Finished initalising persister: " + persister.getId()));
        }
    }

    public void setAutowireService(AutowireService autowireService) {
        this.autowireService = autowireService;
    }

    public List<ModelObjectPersister> getPersisters() {
        return this.persisters;
    }

    public void setPersisters(List<ModelObjectPersister> persisters) {
        this.persisters = persisters;
    }

    public void setWebFrameworkConfig(WebFrameworkConfigElement webFrameworkConfig) {
        this.webFrameworkConfig = webFrameworkConfig;
    }

    public WebFrameworkConfigElement getWebFrameworkConfig() {
        return this.webFrameworkConfig;
    }
}

