/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.cache.ModelObjectCache;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.AbstractStoreObjectPersister;
import org.springframework.extensions.surf.util.XMLUtil;

public class StoreObjectPersister
extends AbstractStoreObjectPersister {
    private static Log logger = LogFactory.getLog(StoreObjectPersister.class);

    public boolean saveObject(ModelPersistenceContext context, ModelObject modelObject) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return false;
        }
        boolean saved = false;
        String content = modelObject.toXML();
        String oldPath = modelObject.getStoragePath();
        String path = this.generatePath(modelObject.getTypeId(), modelObject.getId());
        try {
            if (!modelObject.isSaved()) {
                this.store.createDocument(path, content);
                ModelPersisterInfo info = modelObject.getKey();
                info.setStoragePath(path);
                info.setSaved(true);
                this.cachePut(context, modelObject);
                saved = true;
            } else if (!oldPath.equals(path)) {
                this.store.createDocument(path, content);
                this.store.removeDocument(oldPath);
                modelObject.getKey().setStoragePath(path);
                modelObject.getKey().setSaved(true);
                this.cachePut(context, modelObject);
                saved = true;
            } else {
                this.store.updateDocument(oldPath, content);
                modelObject.getKey().setSaved(true);
                this.cachePut(context, modelObject);
                saved = true;
            }
        }
        catch (IOException ex) {
            throw new ModelObjectPersisterException("Unable to save object: " + oldPath + " due to error: " + ex.getMessage(), ex);
        }
        return saved;
    }

    public ModelObject getObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        ModelObject obj;
        block13: {
            if (!this.isEnabled()) {
                return null;
            }
            obj = this.cacheGet(context, objectTypeId, objectId);
            if (obj == null) {
                String path = this.generatePath(objectTypeId, objectId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loading object for path: " + path));
                }
                try {
                    if (this.store.hasDocument(path)) {
                        Document document = null;
                        try {
                            document = XMLUtil.parse(this.store.getDocument(path));
                        }
                        catch (Exception err) {
                            logger.warn((Object)("Failure to load model object for path: " + path), (Throwable)err);
                        }
                        if (document != null) {
                            Map<String, ModelObject> map = this.loadObjectAndDependants(context, document, objectTypeId, objectId, path);
                            boolean cacheItem = this.useCache;
                            for (ModelObject o : map.values()) {
                                o.touch();
                                if (cacheItem) {
                                    this.getCache(context, o.getTypeId()).put(o.getId(), o);
                                }
                                cacheItem = true;
                            }
                            obj = map.get(objectId);
                        }
                        break block13;
                    }
                    if (this.useCache) {
                        this.getCache(context, objectTypeId).put(objectId, ModelObjectCache.ModelObjectSentinel.getInstance());
                    }
                }
                catch (Exception ex) {
                    throw new ModelObjectPersisterException("Failure to load model object for path: " + path, ex);
                }
            }
        }
        if (obj == ModelObjectCache.ModelObjectSentinel.getInstance()) {
            obj = null;
        }
        return obj;
    }
}

