/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render.bean;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RegionRendererExecutionException;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.AbstractRenderer;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.bean.ChromeRenderer;
import org.springframework.extensions.surf.types.Chrome;

public class RegionRenderer
extends AbstractRenderer {
    private static final Log logger = LogFactory.getLog(RegionRenderer.class);
    private ChromeRenderer chromeRenderer;

    public void setChromeRenderer(ChromeRenderer chromeRenderer) {
        this.chromeRenderer = chromeRenderer;
    }

    public void header(RequestContext context, ModelObject object) throws RendererExecutionException {
        if (logger.isDebugEnabled()) {
            super.header(context, object);
        }
        String regionId = (String)((Object)context.getValue("region-id"));
        try {
            this.getRenderService().renderRegionComponents(context, object);
        }
        catch (Exception ex) {
            throw new RegionRendererExecutionException("Unable to render region: " + regionId, ex);
        }
    }

    public void body(RequestContext context, ModelObject object) throws RendererExecutionException {
        String regionId = (String)((Object)context.getValue("region-id"));
        String regionChromeId = (String)((Object)context.getValue("region-chrome-id"));
        try {
            Chrome chrome = this.getRenderService().getRegionChrome(regionId, regionChromeId);
            if (chrome != null) {
                this.chromeRenderer.render(context, chrome, RenderFocus.BODY);
            } else {
                this.getRenderService().renderRegionComponents(context, object);
            }
            this.postProcess(context);
        }
        catch (Exception ex) {
            throw new RegionRendererExecutionException("Unable to render region: " + regionId, ex);
        }
    }

    public void postProcess(RequestContext context) throws IOException {
    }
}

