/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptableMap;
import org.springframework.extensions.webscripts.ScriptableWrappedMap;
import org.springframework.extensions.webscripts.connector.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptUser
extends ScriptBase {
    private final User user;
    private ScriptableMap<String, Boolean> capabilities;

    public ScriptUser(RequestContext context, User user) {
        super(context);
        this.user = user;
    }

    protected ScriptableMap buildProperties() {
        if (this.properties == null) {
            this.properties = new ScriptableWrappedMap(this.user.getProperties());
        }
        return this.properties;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getName() {
        return this.user.getName();
    }

    public String getFullName() {
        return this.user.getFullName();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String value) {
        this.user.setFirstName(value);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String value) {
        this.user.setLastName(value);
    }

    public String getMiddleName() {
        return this.user.getMiddleName();
    }

    public void setMiddleName(String value) {
        this.user.setMiddleName(value);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String value) {
        this.user.setEmail(value);
    }

    public String getOrganization() {
        return this.user.getOrganization();
    }

    public void setOrganization(String value) {
        this.user.setEmail(value);
    }

    public String getJobTitle() {
        return this.user.getJobTitle();
    }

    public void setJobTitle(String value) {
        this.user.setJobTitle(value);
    }

    public String getLocation() {
        return this.user.getLocation();
    }

    public void setLocation(String value) {
        this.user.setLocation(value);
    }

    public String getBiography() {
        return this.user.getBiography();
    }

    public void setBiography(String value) {
        this.user.setBiography(value);
    }

    public String getTelephone() {
        return this.user.getTelephone();
    }

    public void setTelephone(String value) {
        this.user.setTelephone(value);
    }

    public String getMobilePhone() {
        return this.user.getMobilePhone();
    }

    public void setMobilePhone(String value) {
        this.user.setMobilePhone(value);
    }

    public String getSkype() {
        return this.user.getSkype();
    }

    public void setSkype(String value) {
        this.user.setSkype(value);
    }

    public String getInstantMsg() {
        return this.user.getInstantMsg();
    }

    public void setInstantMsg(String value) {
        this.user.setInstantMsg(value);
    }

    public String getGoogleUsername() {
        return this.user.getGoogleUsername();
    }

    public void setGoogleUsername(String value) {
        this.user.setGoogleUsername(value);
    }

    public String getCompanyPostcode() {
        return this.user.getCompanyPostcode();
    }

    public void setCompanyPostcode(String value) {
        this.user.setCompanyPostcode(value);
    }

    public String getCompanyTelephone() {
        return this.user.getCompanyTelephone();
    }

    public void setCompanyTelephone(String value) {
        this.user.setCompanyTelephone(value);
    }

    public String getCompanyFax() {
        return this.user.getCompanyFax();
    }

    public void setCompanyFax(String value) {
        this.user.setCompanyFax(value);
    }

    public String getCompanyEmail() {
        return this.user.getCompanyEmail();
    }

    public void setCompanyEmail(String value) {
        this.user.setCompanyEmail(value);
    }

    public String getCompanyAddress1() {
        return this.user.getCompanyAddress1();
    }

    public void setCompanyAddress1(String value) {
        this.user.setCompanyAddress1(value);
    }

    public String getCompanyAddress2() {
        return this.user.getCompanyAddress2();
    }

    public void setCompanyAddress2(String value) {
        this.user.setCompanyAddress2(value);
    }

    public String getCompanyAddress3() {
        return this.user.getCompanyAddress3();
    }

    public void setCompanyAddress3(String value) {
        this.user.setCompanyAddress3(value);
    }

    public boolean getIsAdmin() {
        return this.user.isAdmin();
    }

    public boolean getIsGuest() {
        return this.user.isGuest();
    }

    public void save() {
        this.user.save();
    }

    public User getNativeUser() {
        return this.user;
    }

    public ScriptableMap<String, Boolean> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ScriptableWrappedMap(this.user.getCapabilities());
        }
        return this.capabilities;
    }

    public ScriptUser getUser(String userId) {
        try {
            User user = FrameworkUtil.getServiceRegistry().getUserFactory().loadUser(this.context, userId);
            return new ScriptUser(this.context, user);
        }
        catch (UserFactoryException err) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.user.getProperties().toString();
    }
}

