/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.StoreResource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SurfWebApplicationContext
extends XmlWebApplicationContext
implements ConfigurableWebApplicationContext,
ServletContextListener {
    private static Log logger = LogFactory.getLog(SurfWebApplicationContext.class);
    private String searchPathBeanId = "webframework.webflow.searchpath";
    private SearchPath searchPath;

    public SurfWebApplicationContext() {
        this.setDisplayName("Surf WebApplicationContext");
    }

    public void contextInitialized(ServletContextEvent event) {
        this.searchPathBeanId = event.getServletContext().getInitParameter("searchpath");
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    protected SearchPath getSearchPath() {
        if (this.searchPath != null) {
            // empty if block
        }
        return this.searchPath;
    }

    protected void onRefresh() {
        super.onRefresh();
    }

    public Resource getResource(String location) {
        Resource resource = null;
        resource = this.getSearchPath() != null ? this.getResourceFromSearchPath(location) : super.getResource(location);
        return resource;
    }

    protected Resource getResourceByPath(String path) {
        Resource resource = null;
        resource = this.getSearchPath() != null ? this.getResourceFromSearchPath(path) : super.getResourceByPath(path);
        return resource;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Resource[] resources = null;
        if (this.getSearchPath() != null) {
            ArrayList<StoreResource> list = new ArrayList<StoreResource>();
            for (Store apiStore : this.getSearchPath().getStores()) {
                String[] paths = apiStore.getDocumentPaths("", locationPattern);
                if (paths == null || paths.length <= 0) continue;
                for (int i = 0; i < paths.length; ++i) {
                    StoreResource resource = new StoreResource(apiStore, paths[i]);
                    list.add(resource);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Found Spring Resource '" + paths[i] + " in store: " + apiStore.getClass().getSimpleName() + "(" + apiStore.getBasePath() + ")"));
                }
            }
            resources = list.toArray(new Resource[list.size()]);
        } else if (locationPattern.indexOf(":") > -1) {
            resources = super.getResources(locationPattern);
        }
        return resources;
    }

    protected Resource getResourceFromSearchPath(String location) {
        StoreResource resource = null;
        if (this.getSearchPath() != null) {
            for (Store apiStore : this.getSearchPath().getStores()) {
                String path = location;
                try {
                    if (!apiStore.hasDocument(path)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found Spring Resource '" + location + " in store: " + apiStore.getClass().getSimpleName() + "(" + apiStore.getBasePath() + ")"));
                    }
                    resource = new StoreResource(apiStore, path);
                }
                catch (IOException ioe) {
                    throw new PlatformRuntimeException("Unable to get resource: " + location, (Throwable)ioe);
                }
            }
        }
        return resource;
    }
}

