/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFOldDocument;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.extractor.Word6Extractor;
import org.apache.poi.hwpf.model.PicturesTable;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordExtractor
extends AbstractPOIFSExtractor {
    public WordExtractor(ParseContext context) {
        super(context);
    }

    protected void parse(POIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HWPFDocument document;
        try {
            document = new HWPFDocument(filesystem);
        }
        catch (OldWordFileFormatException e) {
            this.parseWord6(filesystem, xhtml);
            return;
        }
        org.apache.poi.hwpf.extractor.WordExtractor wordExtractor = new org.apache.poi.hwpf.extractor.WordExtractor(document);
        this.addTextIfAny(xhtml, "header", wordExtractor.getHeaderText());
        PicturesTable pictureTable = document.getPicturesTable();
        CountingIterator<Picture> pictures = new CountingIterator<Picture>(pictureTable.getAllPictures().iterator());
        Range r = document.getRange();
        for (int i = 0; i < r.numParagraphs(); ++i) {
            Paragraph p = r.getParagraph(i);
            i += this.handleParagraph(p, 0, r, document, pictures, pictureTable, xhtml);
        }
        for (String paragraph : wordExtractor.getFootnoteText()) {
            xhtml.element("p", paragraph);
        }
        for (String paragraph : wordExtractor.getCommentsText()) {
            xhtml.element("p", paragraph);
        }
        for (String paragraph : wordExtractor.getEndnoteText()) {
            xhtml.element("p", paragraph);
        }
        this.addTextIfAny(xhtml, "footer", wordExtractor.getFooterText());
        while (pictures.hasNext()) {
            Picture p = pictures.next();
            this.handlePictureCharacterRun(null, p, pictures.getCount(), xhtml);
        }
        try {
            DirectoryEntry op = (DirectoryEntry)filesystem.getRoot().getEntry("ObjectPool");
            for (Entry entry : op) {
                if (!entry.getName().startsWith("_") || !(entry instanceof DirectoryEntry)) continue;
                this.handleEmbededOfficeDoc((DirectoryEntry)entry, xhtml);
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    private int handleParagraph(Paragraph p, int parentTableLevel, Range r, HWPFDocument document, CountingIterator<Picture> pictures, PicturesTable pictureTable, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        if (p.isInTable() && p.getTableLevel() > parentTableLevel && parentTableLevel == 0) {
            Table t = r.getTable(p);
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            for (int rn = 0; rn < t.numRows(); ++rn) {
                TableRow row = t.getRow(rn);
                xhtml.startElement("tr");
                for (int cn = 0; cn < row.numCells(); ++cn) {
                    TableCell cell = row.getCell(cn);
                    xhtml.startElement("td");
                    for (int pn = 0; pn < cell.numParagraphs(); ++pn) {
                        Paragraph cellP = cell.getParagraph(pn);
                        this.handleParagraph(cellP, p.getTableLevel(), (Range)cell, document, pictures, pictureTable, xhtml);
                    }
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            return t.numParagraphs() - 1;
        }
        StyleDescription style = document.getStyleSheet().getStyleDescription((int)p.getStyleIndex());
        TagAndStyle tas = WordExtractor.buildParagraphTagAndStyle(style.getName(), parentTableLevel > 0);
        if (tas.getStyleClass() != null) {
            xhtml.startElement(tas.getTag(), "class", tas.getStyleClass());
        } else {
            xhtml.startElement(tas.getTag());
        }
        for (int j = 0; j < p.numCharacterRuns(); ++j) {
            Picture picture;
            CharacterRun cr = p.getCharacterRun(j);
            if (cr.text().equals("\u0013")) {
                j += this.handleSpecialCharacterRuns(p, j, tas.isHeading(), xhtml);
                continue;
            }
            if (cr.text().equals("\b")) {
                picture = pictures.next();
                this.handlePictureCharacterRun(cr, picture, pictures.getCount(), xhtml);
                continue;
            }
            if (pictureTable.hasPicture(cr)) {
                picture = pictures.next();
                this.handlePictureCharacterRun(cr, picture, pictures.getCount(), xhtml);
                continue;
            }
            this.handleCharacterRun(cr, tas.isHeading(), xhtml);
        }
        xhtml.endElement(tas.getTag());
        return 0;
    }

    private void handleCharacterRun(CharacterRun cr, boolean skipStyling, XHTMLContentHandler xhtml) throws SAXException {
        if (cr.text().equals("\r")) {
            return;
        }
        ArrayList<String> tags = new ArrayList<String>();
        if (!skipStyling) {
            if (cr.isBold()) {
                tags.add("b");
            }
            if (cr.isItalic()) {
                tags.add("i");
            }
            if (cr.isStrikeThrough()) {
                tags.add("s");
            }
            for (String tag : tags) {
                xhtml.startElement(tag);
            }
        }
        String text = cr.text();
        if ((text = text.replace('\r', '\n')).endsWith("\u0007")) {
            text = text.substring(0, text.length() - 1);
        }
        xhtml.characters(text);
        for (int tn = tags.size() - 1; tn >= 0; --tn) {
            xhtml.endElement((String)tags.get(tn));
        }
    }

    private int handleSpecialCharacterRuns(Paragraph p, int index, boolean skipStyling, XHTMLContentHandler xhtml) throws SAXException {
        int i;
        ArrayList<CharacterRun> controls = new ArrayList<CharacterRun>();
        ArrayList<CharacterRun> texts = new ArrayList<CharacterRun>();
        boolean has14 = false;
        for (i = index; i < p.numCharacterRuns(); ++i) {
            CharacterRun cr = p.getCharacterRun(i);
            if (cr.text().equals("\u0013")) {
                int increment = this.handleSpecialCharacterRuns(p, i + 1, skipStyling, xhtml);
                i += increment;
                continue;
            }
            if (cr.text().equals("\u0014")) {
                has14 = true;
                continue;
            }
            if (cr.text().equals("\u0015")) {
                if (has14) break;
                texts = controls;
                controls = new ArrayList();
                break;
            }
            if (has14) {
                texts.add(cr);
                continue;
            }
            controls.add(cr);
        }
        if (controls.size() > 0) {
            String text = ((CharacterRun)controls.get(0)).text();
            for (int j = 1; j < controls.size(); ++j) {
                text = text + ((CharacterRun)controls.get(j)).text();
            }
            if (text.startsWith("HYPERLINK") && text.indexOf(34) > -1) {
                String url = text.substring(text.indexOf(34) + 1, text.lastIndexOf(34));
                xhtml.startElement("a", "href", url);
                for (CharacterRun cr : texts) {
                    this.handleCharacterRun(cr, skipStyling, xhtml);
                }
                xhtml.endElement("a");
            } else {
                for (CharacterRun cr : texts) {
                    this.handleCharacterRun(cr, skipStyling, xhtml);
                }
            }
        } else {
            for (CharacterRun cr : texts) {
                this.handleCharacterRun(cr, skipStyling, xhtml);
            }
        }
        return i - index;
    }

    private void handlePictureCharacterRun(CharacterRun cr, Picture picture, int pictureNumber, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        String extension = picture.suggestFileExtension();
        String filename = "image" + pictureNumber + (extension.length() > 0 ? "." + extension : "");
        xhtml.startElement("img", "src", "embedded:" + filename);
        xhtml.endElement("img");
        String mimeType = "image/unknown";
        if ("jpg".equals(extension)) {
            mimeType = "image/jpeg";
        }
        if ("png".equals(extension)) {
            mimeType = "image/png";
        }
        if ("gif".equals(extension)) {
            mimeType = "image/gif";
        }
        if ("bmp".equals(extension)) {
            mimeType = "image/bmp";
        }
        if ("tiff".equals(extension)) {
            mimeType = "image/tiff";
        }
        if ("wmf".equals(extension)) {
            mimeType = "image/x-wmf";
        }
        if ("emf".equals(extension)) {
            mimeType = "image/x-emf";
        }
        TikaInputStream stream = TikaInputStream.get((byte[])picture.getContent());
        this.handleEmbeddedResource(stream, filename, mimeType, xhtml, false);
    }

    private void addTextIfAny(XHTMLContentHandler xhtml, String section, String text) throws SAXException {
        if (text != null && text.length() > 0) {
            xhtml.startElement("div", "class", section);
            xhtml.element("p", text);
            xhtml.endElement("div");
        }
    }

    protected void parseWord6(POIFSFileSystem filesystem, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        HWPFOldDocument doc = new HWPFOldDocument(filesystem);
        Word6Extractor extractor = new Word6Extractor(doc);
        for (String p : extractor.getParagraphText()) {
            xhtml.element("p", p);
        }
    }

    public static TagAndStyle buildParagraphTagAndStyle(String styleName, boolean isTable) {
        String tag = "p";
        String styleClass = null;
        if (!(styleName.equals("Default") || styleName.equals("Normal") || styleName.equals("Table Contents") && isTable)) {
            if (styleName.equals("Heading")) {
                tag = "h1";
            } else if (styleName.startsWith("Heading ")) {
                int num = 1;
                try {
                    num = Integer.parseInt(styleName.substring(styleName.length() - 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                tag = "h" + num;
            } else if (styleName.equals("Title")) {
                tag = "h1";
                styleClass = "title";
            } else if (styleName.equals("Subtitle")) {
                tag = "h2";
                styleClass = "subtitle";
            } else {
                styleClass = styleName.replace(' ', '_');
                styleClass = styleClass.substring(0, 1).toLowerCase() + styleClass.substring(1);
            }
        }
        return new TagAndStyle(tag, styleClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountingIterator<T>
    implements Iterator<T> {
        private Iterator<T> parent;
        private int count = 0;

        private CountingIterator(Iterator<T> parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        public T next() {
            ++this.count;
            return this.parent.next();
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class TagAndStyle {
        private String tag;
        private String styleClass;

        public TagAndStyle(String tag, String styleClass) {
            this.tag = tag;
            this.styleClass = styleClass;
        }

        public String getTag() {
            return this.tag;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public boolean isHeading() {
            return this.tag.length() == 2 && this.tag.startsWith("h");
        }
    }
}

