/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.generators;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.Digest;

public class DigestRandom
extends Random {
    private final byte[] in;
    private long counter;
    private final Digest digest;
    private final byte[] out;
    private int outOff;

    public DigestRandom(Digest digest) {
        this.digest = digest;
        int n = digest.getDigestSize();
        this.in = new SecureRandom().generateSeed(n);
        this.out = new byte[n];
        this.outOff = n;
    }

    public synchronized void nextBytes(byte[] byArray) {
        int n = byArray.length;
        while (--n >= 0) {
            this.update();
            byArray[n] = this.out[this.outOff++];
        }
    }

    protected final int next(int n) {
        int n2 = n + 7 >>> 3;
        int n3 = 0;
        int n4 = n2;
        while (--n4 >= 0) {
            this.update();
            n3 = n3 << 8 | this.out[this.outOff++] & 0xFF;
        }
        return n3 >>> (n2 << 3) - n;
    }

    private void update() {
        if (this.outOff >= this.out.length) {
            long l = ++this.counter;
            int n = this.in.length;
            while (--n >= 0) {
                this.in[n] = (byte)(l += (long)(this.in[n] & 0xFF));
                l >>>= 8;
            }
            this.digest.update(this.in, 0, this.in.length);
            this.digest.doFinal(this.out, 0);
            this.outOff = 0;
        }
    }
}

