/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io;

import de.schlichtherle.crypto.SeekableBlockCipher;
import de.schlichtherle.crypto.io.RaesAuthenticationException;
import de.schlichtherle.crypto.io.RaesException;
import de.schlichtherle.crypto.io.RaesKeyException;
import de.schlichtherle.crypto.io.RaesOutputStream;
import de.schlichtherle.crypto.io.RaesParameters;
import de.schlichtherle.crypto.io.RandomAccessEncryptionSpecification;
import de.schlichtherle.crypto.modes.SICSeekableBlockCipher;
import de.schlichtherle.io.rof.FilterReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.Arrays;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class RaesReadOnlyFile
extends FilterReadOnlyFile
implements RandomAccessEncryptionSpecification {
    private static final int MAX_WINDOW_LEN = 1024;
    private final int keyStrength;
    private final byte[] trailer;
    private final CipherParameters macParam;
    private final long start;
    private final long length;
    private long fp;
    private long windowOff;
    private final byte[] window;
    private final SeekableBlockCipher cipher;
    private long blockOff;
    private byte[] block;
    static final /* synthetic */ boolean $assertionsDisabled;

    static final int readUByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    static final int readUShort(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    static final long readUInt(byte[] byArray, int n) {
        n += 3;
        long l = (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    protected static final long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    protected static final long max(long l, long l2) {
        return l < l2 ? l2 : l;
    }

    public RaesReadOnlyFile(File file, RaesParameters raesParameters) throws NullPointerException, FileNotFoundException, RaesException, RaesKeyException, IOException {
        this(null, file, raesParameters);
    }

    public RaesReadOnlyFile(ReadOnlyFile readOnlyFile, RaesParameters raesParameters) throws NullPointerException, FileNotFoundException, RaesException, RaesKeyException, IOException {
        this(readOnlyFile, null, raesParameters);
    }

    private RaesReadOnlyFile(ReadOnlyFile readOnlyFile, File file, RaesParameters raesParameters) throws NullPointerException, FileNotFoundException, RaesException, RaesKeyException, IOException {
        super(readOnlyFile);
        if (raesParameters == null) {
            throw new NullPointerException("raesParameters");
        }
        if (readOnlyFile == null) {
            if (file == null) {
                throw new NullPointerException();
            }
            readOnlyFile = this.createReadOnlyFile(file);
        } else if (!$assertionsDisabled && file != null) {
            throw new AssertionError();
        }
        this.rof = readOnlyFile;
        try {
            CipherParameters cipherParameters;
            ParametersWithIV parametersWithIV;
            byte[] byArray = new byte[8];
            long l = readOnlyFile.length();
            readOnlyFile.seek(0L);
            readOnlyFile.readFully(byArray);
            if (RaesReadOnlyFile.readUInt(byArray, 0) != 1397047634L) {
                throw new RaesException("No RAES signature!");
            }
            int n = RaesReadOnlyFile.readUByte(byArray, 4);
            if (n != 0) {
                throw new RaesException("Unsupported RAES data envelope version " + n + "!");
            }
            this.keyStrength = RaesReadOnlyFile.readUByte(byArray, 5);
            if (this.keyStrength != 0 && this.keyStrength != 1 && this.keyStrength != 2) {
                throw new RaesException("Unknown cipher key strength: " + this.keyStrength + "!");
            }
            int n2 = 16 + this.keyStrength * 8;
            int n3 = n2 * 8;
            int n4 = RaesReadOnlyFile.readUShort(byArray, 6);
            if (n4 < 1024) {
                throw new RaesException("Iteration count must be 1024 or greater, but is " + n4 + "!");
            }
            this.start = byArray.length + n2;
            byte[] byArray2 = new byte[n2];
            readOnlyFile.readFully(byArray2);
            SHA256Digest sHA256Digest = new SHA256Digest();
            this.trailer = new byte[sHA256Digest.getDigestSize()];
            long l2 = l - (long)this.trailer.length;
            readOnlyFile.seek(l2);
            readOnlyFile.readFully(this.trailer);
            if (this.rof.read() != -1) {
                throw new RaesException("Expected end of file after data envelope trailer!");
            }
            this.length = l - (long)this.trailer.length - this.start;
            PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator((Digest)sHA256Digest);
            while (true) {
                char[] cArray;
                if ((cArray = raesParameters.getPasswd()) == null) {
                    throw new RaesKeyException();
                }
                byte[] byArray3 = PBEParametersGenerator.PKCS12PasswordToBytes((char[])cArray);
                int n5 = cArray.length;
                while (--n5 >= 0) {
                    cArray[n5] = '\u0000';
                }
                pKCS12ParametersGenerator.init(byArray3, byArray2, n4);
                parametersWithIV = (ParametersWithIV)pKCS12ParametersGenerator.generateDerivedParameters(n3, 128);
                cipherParameters = pKCS12ParametersGenerator.generateDerivedMacParameters(n3);
                n5 = byArray3.length;
                while (--n5 >= 0) {
                    byArray3[n5] = 0;
                }
                HMac hMac = new HMac((Digest)sHA256Digest);
                hMac.init(cipherParameters);
                byte[] byArray4 = ((KeyParameter)parametersWithIV.getParameters()).getKey();
                hMac.update(byArray4, 0, byArray4.length);
                byte[] byArray5 = new byte[hMac.getMacSize()];
                RaesOutputStream.klac((Mac)hMac, this.length, byArray5);
                sHA256Digest.reset();
                if (Arrays.equals(this.trailer, 0, byArray5, 0, byArray5.length / 2)) break;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            raesParameters.passwdCorrect(this.keyStrength);
            this.macParam = cipherParameters;
            this.cipher = new SICSeekableBlockCipher((BlockCipher)new AESFastEngine());
            this.cipher.init(false, (CipherParameters)parametersWithIV);
        }
        catch (RaesKeyException raesKeyException) {
            if (file != null) {
                readOnlyFile.close();
            }
            throw raesKeyException;
        }
        catch (IOException iOException) {
            RaesException raesException;
            if (file != null) {
                readOnlyFile.close();
            }
            if (!(iOException instanceof RaesException)) {
                raesException = new RaesException("Not an RAES encrypted file or corrupted data!", iOException);
            }
            throw raesException;
        }
        this.blockOff = this.length;
        int n = this.cipher.getBlockSize();
        this.block = new byte[n];
        this.invalidateWindow();
        this.window = new byte[1024 / n * n];
        if (!$assertionsDisabled && this.fp != 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.block.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.window.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.window.length % this.block.length != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.cipher == null) {
            throw new AssertionError();
        }
    }

    protected ReadOnlyFile createReadOnlyFile(File file) throws IOException {
        return new SimpleReadOnlyFile(file);
    }

    public int getKeyStrength() throws IOException {
        this.ensureOpen();
        return this.keyStrength;
    }

    public int getKeySize() throws IOException {
        this.ensureOpen();
        return 128 + this.keyStrength * 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() throws RaesAuthenticationException, IOException {
        HMac hMac = new HMac((Digest)new SHA256Digest());
        long l = this.getFilePointer();
        int n = this.window.length;
        byte[] byArray = new byte[hMac.getMacSize()];
        if (!$assertionsDisabled && this.trailer.length != byArray.length) {
            throw new AssertionError();
        }
        hMac.init(this.macParam);
        try {
            this.fp = 0L;
            while (this.fp < this.length) {
                this.positionWindow();
                long l2 = this.length - this.windowOff;
                hMac.update(this.window, 0, (int)RaesReadOnlyFile.min(n, l2));
                this.fp += (long)n;
            }
            int n2 = hMac.doFinal(byArray, 0);
            if (!$assertionsDisabled && n2 != byArray.length) {
                throw new AssertionError();
            }
        }
        finally {
            this.fp = l;
        }
        if (!Arrays.equals(this.trailer, this.trailer.length / 2, byArray, 0, byArray.length / 2)) {
            throw new RaesAuthenticationException();
        }
    }

    public long length() throws IOException {
        this.ensureOpen();
        return this.length;
    }

    public long getFilePointer() throws IOException {
        this.ensureOpen();
        return this.fp;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        this.ensureOpen();
        if (l > this.length) {
            throw new IOException("File pointer (" + l + ") is larger than file length (" + this.length + ")!");
        }
        this.fp = l;
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.fp >= this.length) {
            return -1;
        }
        this.positionBlock();
        return this.block[(int)(this.fp++ % (long)this.block.length)];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        int n3 = n + n2;
        if ((n | n2 | n3 | byArray.length - n3) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.ensureOpen();
        if (this.fp >= this.length) {
            return -1;
        }
        int n4 = this.block.length;
        int n5 = 0;
        int n6 = (int)(this.fp % (long)n4);
        if (n6 != 0) {
            this.positionBlock();
            n5 = (int)RaesReadOnlyFile.min(n2, n4 - n6);
            n5 = (int)RaesReadOnlyFile.min(n5, this.length - this.fp);
            System.arraycopy(this.block, n6, byArray, n, n5);
            this.fp += (long)n5;
        }
        long l = this.fp / (long)n4;
        while (n5 + n4 < n2 && this.fp + (long)n4 <= this.length) {
            this.positionWindow();
            this.cipher.setBlockCounter(l++);
            this.cipher.processBlock(this.window, (int)(this.fp - this.windowOff), byArray, n + n5);
            n5 += n4;
            this.fp += (long)n4;
        }
        if (n5 < n2 && this.fp < this.length) {
            this.positionBlock();
            int n7 = (int)RaesReadOnlyFile.min(n2 - n5, this.length - this.fp);
            System.arraycopy(this.block, 0, byArray, n + n5, n7);
            n5 += n7;
            this.fp += (long)n7;
        }
        if (!$assertionsDisabled && n5 <= 0) {
            throw new AssertionError();
        }
        return n5;
    }

    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        this.ensureOpen();
        if (this.fp >= this.length) {
            return 0;
        }
        long l = this.length - this.fp;
        if ((long)n > l) {
            n = (int)l;
        }
        this.fp += (long)n;
        return n;
    }

    private final void ensureOpen() throws IOException {
        if (this.rof == null) {
            throw new IOException("RaesReadOnlyFile has been closed!");
        }
    }

    public void close() throws IOException {
        if (this.rof != null) {
            ReadOnlyFile readOnlyFile = this.rof;
            this.rof = null;
            readOnlyFile.close();
        }
    }

    private void positionBlock() throws IOException {
        long l;
        long l2 = this.fp;
        int n = this.block.length;
        if (this.blockOff <= l2 && l2 < (l = this.blockOff + (long)n)) {
            return;
        }
        this.positionWindow();
        l = l2 / (long)n;
        this.blockOff = l * (long)n;
        this.cipher.setBlockCounter(l);
        this.cipher.processBlock(this.window, (int)(this.blockOff - this.windowOff), this.block, 0);
    }

    private void positionWindow() throws IOException {
        long l = this.fp;
        int n = this.window.length;
        long l2 = this.windowOff + (long)n;
        if (this.windowOff <= l && l < l2) {
            return;
        }
        try {
            int n2;
            int n3 = this.block.length;
            this.windowOff = l / (long)n3 * (long)n3;
            if (this.windowOff != l2) {
                this.rof.seek(this.windowOff + this.start);
            }
            int n4 = 0;
            while ((n2 = this.rof.read(this.window, n4, n - n4)) >= 0 && (n4 += n2) < n) {
            }
        }
        catch (IOException iOException) {
            this.windowOff = -n - 1;
            throw iOException;
        }
    }

    private final void invalidateWindow() {
        this.windowOff = Long.MIN_VALUE;
    }

    static {
        $assertionsDisabled = !RaesReadOnlyFile.class.desiredAssertionStatus();
    }
}

