/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.crypto.io.PasswdManager;
import de.schlichtherle.crypto.io.RaesOutputStream;
import de.schlichtherle.crypto.io.RaesParameters;
import de.schlichtherle.crypto.io.RaesReadOnlyFile;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.ZipDetector;
import de.schlichtherle.io.rof.ReadOnlyFileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RaesFileUtils {
    public static void encrypt(String string, String string2) throws IOException {
        RaesFileUtils.encrypt(string, string2, File.getDefaultZipDetector());
    }

    public static void encrypt(String string, String string2, ZipDetector zipDetector) throws IOException {
        RaesOutputStream raesOutputStream;
        File file = RaesFileUtils.createNonZipFile(string, zipDetector);
        FileInputStream fileInputStream = zipDetector.createFileInputStream(file);
        try {
            File file2 = RaesFileUtils.createNonZipFile(string2, zipDetector);
            RaesParameters raesParameters = PasswdManager.getInstance().getRaesParameters(file2.getPath());
            raesParameters.getNewPasswd();
            raesOutputStream = new RaesOutputStream(zipDetector.createFileOutputStream(file2, false));
            raesOutputStream.init(true, raesParameters);
        }
        catch (IOException iOException) {
            ((InputStream)fileInputStream).close();
            throw iOException;
        }
        File.cp(fileInputStream, raesOutputStream);
    }

    public static void decrypt(String string, String string2, boolean bl) throws IOException {
        RaesFileUtils.decrypt(string, string2, bl, File.getDefaultZipDetector());
    }

    public static void decrypt(String string, String string2, boolean bl, ZipDetector zipDetector) throws IOException {
        FileOutputStream fileOutputStream;
        ReadOnlyFileInputStream readOnlyFileInputStream;
        File file = RaesFileUtils.createNonZipFile(string, zipDetector);
        RaesReadOnlyFile raesReadOnlyFile = new RaesReadOnlyFile(file, PasswdManager.getInstance().getRaesParameters(file.getPath()));
        try {
            if (bl) {
                raesReadOnlyFile.authenticate();
            }
            readOnlyFileInputStream = new ReadOnlyFileInputStream(raesReadOnlyFile);
            File file2 = RaesFileUtils.createNonZipFile(string2, zipDetector);
            fileOutputStream = zipDetector.createFileOutputStream(file2, false);
        }
        catch (IOException iOException) {
            raesReadOnlyFile.close();
            throw iOException;
        }
        File.cp(readOnlyFileInputStream, fileOutputStream);
    }

    private static final File createNonZipFile(String string, ZipDetector zipDetector) {
        File file = zipDetector.createFile(string);
        return ZipDetector.NONE.createFile(file.getParentFile(), file.getName());
    }

    protected RaesFileUtils() {
    }
}

