/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.crypto.io.PasswdManager;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.ZipBusyException;
import de.schlichtherle.io.ZipBusyWarningException;
import de.schlichtherle.io.ZipControllerException;
import de.schlichtherle.io.ZipDetector;
import de.schlichtherle.io.ZipEntry;
import de.schlichtherle.io.ZipFileSystem;
import de.schlichtherle.io.ZipFileSystemException;
import de.schlichtherle.io.ZipReadOnlyException;
import de.schlichtherle.io.ZipWarningException;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;

final class ZipController {
    private static final Logger logger;
    static final String TEMP_FILE_PREFIX = "tzp";
    static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final Map controllers;
    final File target;
    final ZipController enclController;
    final String enclEntryName;
    private ZipDetector zipDetector;
    private java.io.File inFile;
    private ZipFile inZip;
    private ZipFileSystem fileSystem;
    private java.io.File outFile;
    private ZipOutputStream outZip;
    private boolean needsReassembly;
    private final WeakReference weakThis = new WeakReference<ZipController>(this);
    private boolean busyMounting;
    static /* synthetic */ Class class$de$schlichtherle$crypto$io$PasswdManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ZipController getInstance(File file) {
        boolean bl;
        ZipController zipController;
        block22: {
            ZipController zipController2;
            block21: {
                ZipController zipController3;
                ZipController zipController4;
                block20: {
                    if (!$assertionsDisabled && file == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !file.isZipFile()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && file.zipController != null) {
                        throw new AssertionError();
                    }
                    file = file.getCanOrAbsFile();
                    if (!$assertionsDisabled && file.zipController != null) {
                        throw new AssertionError();
                    }
                    zipController = null;
                    bl = false;
                    try {
                        Map map = controllers;
                        synchronized (map) {
                            Object v = controllers.get(file);
                            if (v instanceof Reference) {
                                zipController = (ZipController)((Reference)v).get();
                                if (!$assertionsDisabled && zipController == null) {
                                    throw new AssertionError();
                                }
                                if (zipController != null) {
                                    bl = zipController.getZipDetector() != file.getZipDetector();
                                    zipController4 = zipController;
                                    // MONITOREXIT @DISABLED, blocks:[0, 17, 19, 5] lbl23 : MonitorExitStatement: MONITOREXIT : var4_3
                                    Object var8_7 = null;
                                    if (!bl) return zipController4;
                                    zipController3 = zipController;
                                    break block20;
                                }
                            } else if (v != null) {
                                zipController2 = (ZipController)v;
                                // MONITOREXIT @DISABLED, blocks:[0, 16, 18, 5] lbl31 : MonitorExitStatement: MONITOREXIT : var4_3
                                break block21;
                            }
                            file.zipController = zipController = new ZipController(file);
                        }
                        break block22;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (!bl) throw throwable;
                        ZipController zipController5 = zipController;
                        synchronized (zipController5) {
                            super.setZipDetector(file.getZipDetector());
                            throw throwable;
                        }
                    }
                }
                synchronized (zipController3) {
                    zipController.setZipDetector(file.getZipDetector());
                    return zipController4;
                }
            }
            Object var8_8 = null;
            if (!bl) return zipController2;
            ZipController zipController6 = zipController;
            synchronized (zipController6) {
                zipController.setZipDetector(file.getZipDetector());
                return zipController2;
            }
        }
        Object var8_9 = null;
        if (!bl) return zipController;
        ZipController zipController7 = zipController;
        synchronized (zipController7) {
            zipController.setZipDetector(file.getZipDetector());
            return zipController;
        }
    }

    private ZipController(File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !file.isAbsolute()) {
            throw new AssertionError();
        }
        this.target = file;
        File file2 = file.getEnclZipFile();
        if (file2 == null) {
            this.enclController = null;
            this.enclEntryName = null;
        } else {
            this.enclController = file2.zipController;
            this.enclEntryName = file.getEnclZipEntryName();
        }
        this.setZipDetector(file.getZipDetector());
        this.schedule(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void schedule(boolean bl) {
        Map map = controllers;
        synchronized (map) {
            if (bl) {
                controllers.put(this.target, this);
            } else {
                controllers.put(this.target, this.weakThis);
            }
        }
    }

    private void setZipDetector(ZipDetector zipDetector) {
        this.zipDetector = zipDetector;
    }

    ZipDetector getZipDetector() {
        return this.zipDetector;
    }

    final ZipFileSystem getFileSystem() throws FileNotFoundException, ZipException, IOException {
        if (this.fileSystem == null) {
            this.mountOrCreateFileSystem(false);
        }
        return this.fileSystem;
    }

    final ZipFileSystem getFileSystem(boolean bl) throws IOException {
        if (this.fileSystem == null) {
            this.mountOrCreateFileSystem(bl);
        }
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mountOrCreateFileSystem(boolean bl) throws IOException {
        logger.log(Level.FINER, "mountFileSystem.entering", new Object[]{this.target.getPath(), bl});
        try {
            try {
                if (this.busyMounting) {
                    throw new IllegalRecursiveMountOrCreateFileSystem();
                }
                this.busyMounting = true;
                try {
                    this._mountOrCreateFileSystem(bl);
                }
                finally {
                    this.busyMounting = false;
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                logger.log(Level.FINER, "mountFileSystem.throwing", throwable);
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logger.log(Level.FINER, "mountFileSystem.finally", new Object[]{this.target.getPath(), bl});
            throw throwable;
        }
        logger.log(Level.FINER, "mountFileSystem.finally", new Object[]{this.target.getPath(), bl});
    }

    private void _mountOrCreateFileSystem(boolean bl) throws FileNotFoundException, IOException {
        if (!$assertionsDisabled && this.fileSystem != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inZip != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outZip != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outFile != null) {
            throw new AssertionError();
        }
        if (this.usesNativeTargetFile()) {
            long l;
            if (this.inFile == null) {
                this.inFile = this.target.delegate;
            }
            if ((l = this.inFile.lastModified()) != 0L) {
                boolean bl2 = !ZipController.isWritableOrCreatable(this.inFile);
                try {
                    this.initInZip(this.inFile);
                }
                catch (IOException iOException) {
                    throw new FalsePositiveNativeException(iOException);
                }
                this.fileSystem = new ZipFileSystem(this, this.inZip, l, bl2);
            } else {
                if (!bl) {
                    throw new ZipFileNotFoundException();
                }
                this.getOutputStream(null);
                this.fileSystem = new ZipFileSystem(this);
            }
        } else if (this.inFile == null) {
            this.unwrap(this.enclController, this.enclEntryName, bl);
        } else {
            try {
                this.initInZip(this.inFile);
            }
            catch (IOException iOException) {
                throw new FalsePositiveFileEntryException(iOException);
            }
            this.fileSystem = new ZipFileSystem(this, this.inZip, this.inFile.lastModified(), false);
        }
        if (!$assertionsDisabled && this.fileSystem == null) {
            throw new AssertionError();
        }
    }

    final boolean usesNativeTargetFile() {
        return this.enclController == null || this.enclController.target.delegate.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean isWritableOrCreatable(java.io.File file) {
        if (file.canWrite()) {
            boolean bl;
            long l;
            RandomAccessFile randomAccessFile;
            block23: {
                block21: {
                    boolean bl2;
                    block22: {
                        randomAccessFile = null;
                        l = file.lastModified();
                        if (!file.setLastModified(l + 1L)) {
                            return false;
                        }
                        randomAccessFile = new RandomAccessFile(file, "rwd");
                        int n = randomAccessFile.read();
                        if (n == -1) break block21;
                        randomAccessFile.seek(0L);
                        randomAccessFile.write(n);
                        bl2 = true;
                        Object var7_9 = null;
                        if (randomAccessFile == null) break block22;
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (l != 0L && !file.setLastModified(l)) {
                        return false;
                    }
                    return bl2;
                }
                randomAccessFile.write(0);
                randomAccessFile.close();
                randomAccessFile = null;
                new FileOutputStream(file).close();
                bl = true;
                Object var7_10 = null;
                if (randomAccessFile == null) break block23;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (l != 0L && !file.setLastModified(l)) {
                return false;
            }
            return bl;
            catch (IOException iOException) {
                boolean bl3;
                block24: {
                    try {
                        bl3 = false;
                        Object var7_11 = null;
                        if (randomAccessFile == null) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        if (randomAccessFile != null) {
                            try {
                                randomAccessFile.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        if (l != 0L && !file.setLastModified(l)) {
                            return false;
                        }
                        throw throwable;
                    }
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                if (l != 0L && !file.setLastModified(l)) {
                    return false;
                }
                return bl3;
            }
        }
        if (!file.exists()) {
            try {
                if (file.createNewFile()) {
                    return file.delete();
                }
                return ZipController.isWritableOrCreatable(file);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unwrap(ZipController zipController, String string, boolean bl) throws IOException {
        if (!$assertionsDisabled && zipController == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "" == string) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.fileSystem != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inZip != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inFile != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outZip != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outFile != null) {
            throw new AssertionError();
        }
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipFileSystem zipFileSystem;
                try {
                    zipFileSystem = zipController.getFileSystem(bl && File.isLenient());
                }
                catch (FalsePositiveNativeException falsePositiveNativeException) {
                    throw (IOException)falsePositiveNativeException.getCause();
                }
                ZipEntry zipEntry = zipFileSystem.get(string);
                if (zipEntry != null) {
                    java.io.File file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
                    try {
                        File.cp(zipController.getInputStream(string), new FileOutputStream(file));
                        try {
                            this.initInZip(file);
                        }
                        catch (IOException iOException) {
                            throw new FalsePositiveFileEntryException(iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!file.delete()) {
                            throw new IOException(file.getPath() + ": Couldn't delete corrupted input file!");
                        }
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                        throw (RuntimeException)throwable;
                    }
                    this.inFile = file;
                    this.fileSystem = new ZipFileSystem(this, this.inZip, zipEntry.getTime(), zipFileSystem.isReadOnly());
                } else {
                    if (zipFileSystem.get(string + '/') != null) {
                        throw zipController.new FalsePositiveDirectoryEntryException();
                    }
                    if (!bl) {
                        throw new ZipFileNotFoundException();
                    }
                    if (zipFileSystem.isReadOnly()) {
                        throw new ZipReadOnlyException();
                    }
                    this.getOutputStream(null);
                    try {
                        zipFileSystem.create(string, bl && File.isLenient());
                    }
                    catch (ZipFileSystemException zipFileSystemException) {
                        block36: {
                            try {
                                try {
                                    this.outZip.close();
                                }
                                finally {
                                    this.outZip = null;
                                }
                                Object var11_14 = null;
                                boolean bl2 = this.outFile.delete();
                                if ($assertionsDisabled || bl2) break block36;
                                throw new AssertionError();
                            }
                            catch (Throwable throwable) {
                                Object var11_15 = null;
                                boolean bl3 = this.outFile.delete();
                                if (!$assertionsDisabled && !bl3) {
                                    throw new AssertionError();
                                }
                                this.outFile = null;
                                throw throwable;
                            }
                        }
                        this.outFile = null;
                        throw zipFileSystemException;
                    }
                    this.fileSystem = new ZipFileSystem(this);
                }
            }
        }
        catch (FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            if (falsePositiveDirectoryEntryException.getController() == zipController) {
                throw falsePositiveDirectoryEntryException;
            }
            this.unwrap(zipController.enclController, zipController.enclEntryName + '/' + string, bl);
        }
        if ($assertionsDisabled) return;
        if (this.fileSystem != null) return;
        throw new AssertionError();
    }

    private void initInZip(java.io.File file) throws IOException {
        if (!$assertionsDisabled && this.inZip != null) {
            throw new AssertionError();
        }
        logger.log(Level.FINEST, "initInZip.entering", file);
        try {
            try {
                SimpleReadOnlyFile simpleReadOnlyFile = new SimpleReadOnlyFile(file);
                try {
                    this.inZip = this.getZipDetector().createZipFile(this.target.getPath(), simpleReadOnlyFile);
                }
                catch (Throwable throwable) {
                    simpleReadOnlyFile.close();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw (Error)throwable;
                }
                Object var5_5 = null;
            }
            catch (IOException iOException) {
                if (!$assertionsDisabled && this.inZip != null) {
                    throw new AssertionError();
                }
                logger.log(Level.FINEST, "initInZip.throwing", iOException);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            logger.log(Level.FINEST, "initInZip.finally", new Object[]{file, new Integer(this.inZip != null ? this.inZip.size() : 0)});
            throw throwable;
        }
        logger.log(Level.FINEST, "initInZip.finally", new Object[]{file, new Integer(this.inZip != null ? this.inZip.size() : 0)});
        if (!$assertionsDisabled && this.inZip == null) {
            throw new AssertionError();
        }
    }

    final InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, true);
    }

    InputStream getInputStream(String string, boolean bl) throws IOException {
        ZipEntry zipEntry;
        if (this.isWritten(string)) {
            this.update();
        }
        if ((zipEntry = this.getFileSystem().get(string)) == null) {
            throw new ZipEntryNotFoundException(string, "No such entry!");
        }
        if (zipEntry.isDirectory()) {
            throw new ZipEntryNotFoundException(string, "Cannot read directory entry!");
        }
        InputStream inputStream = this.inZip.getInputStream(zipEntry.getName(), bl);
        if (inputStream == null) {
            throw new ZipEntryNotFoundException(string, "Illegal access to ZIP compatible file!");
        }
        return inputStream;
    }

    final OutputStream getOutputStream(String string) throws IOException {
        return this.getOutputStream(string, -1L, 9, null);
    }

    OutputStream getOutputStream(String string, long l, int n, ZipEntry zipEntry) throws IOException {
        ZipEntry zipEntry2;
        Object object;
        if (this.outZip != null && this.outZip.busy()) {
            throw new FileBusyException(this.target);
        }
        if (string != null) {
            if (this.isWritten(string)) {
                this.update();
            }
            object = this.getFileSystem(File.isLenient());
            zipEntry2 = ((ZipFileSystem)object).create(string, File.isLenient());
            if (zipEntry != null) {
                zipEntry2.copyFrom(zipEntry);
            } else if (l != -1L) {
                zipEntry2.touch(l);
            }
        } else {
            zipEntry2 = null;
        }
        if (this.outZip == null) {
            object = this.outFile;
            if (object == null) {
                java.io.File file = this.target.delegate;
                object = this.usesNativeTargetFile() && !file.isFile() ? file : File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            }
            this.initOutZip((java.io.File)object);
            this.outFile = object;
        }
        if (zipEntry2 == null) {
            return null;
        }
        this.outZip.setLevel(n);
        this.outZip.putNextEntry(zipEntry2, zipEntry == null);
        return new FilterOutputStream(this.outZip){
            private boolean closed;

            public void write(byte[] byArray) throws IOException {
                this.out.write(byArray, 0, byArray.length);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.out.write(byArray, n, n2);
            }

            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    ((ZipOutputStream)this.out).closeEntry();
                }
            }

            protected void finalize() throws IOException {
                this.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOutZip(java.io.File file) throws IOException {
        block17: {
            if (!$assertionsDisabled && this.outZip != null) {
                throw new AssertionError();
            }
            logger.log(Level.FINEST, "initOutZip.entering", file);
            try {
                OutputStream outputStream = new FileOutputStream(file);
                if (file == this.target.delegate) {
                    outputStream = new CountingOutputStream(outputStream);
                }
                try {
                    this.outZip = this.getZipDetector().createZipOutputStream(this.target.getPath(), outputStream);
                    if (this.inZip == null) break block17;
                    this.outZip.setComment(this.inZip.getComment());
                    if (this.inZip.getPreambleLength() <= 0L) break block17;
                    InputStream inputStream = this.inZip.getPreambleInputStream();
                    try {
                        File.cat(inputStream, this.inZip.offsetsConsiderPreamble() ? this.outZip : outputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    ((OutputStream)outputStream).close();
                    if (!file.delete()) {
                        throw new IOException(file.getPath() + ": Couldn't delete corrupted output file!");
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw (Error)throwable;
                }
            }
            catch (IOException iOException) {
                if (!$assertionsDisabled && this.outZip != null) {
                    throw new AssertionError();
                }
                logger.log(Level.FINEST, "initOutZip.throwing", iOException);
                throw iOException;
            }
            finally {
                logger.log(Level.FINEST, "initOutZip.finally", file);
            }
        }
        if (!$assertionsDisabled && this.outZip == null) {
            throw new AssertionError();
        }
    }

    final boolean isWritten(String string) {
        return this.outZip != null && this.outZip.getEntry(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateAll(boolean bl, boolean bl2, boolean bl3) throws ZipControllerException {
        int n = 0;
        int n2 = 0;
        logger.log(Level.FINE, "updateAll.entering", new Object[]{bl, bl2});
        if (bl3) {
            CountingInputStream.resetOnReuse();
            CountingOutputStream.resetOnReuse();
        }
        try {
            try {
                Object[] objectArray;
                if (bl2) {
                    System.runFinalization();
                }
                Object object = controllers;
                synchronized (object) {
                    objectArray = controllers.keySet().toArray();
                }
                Arrays.sort(objectArray);
                ZipControllerException.counter = 0;
                object = null;
                int n3 = objectArray.length;
                while (--n3 >= 0) {
                    ZipController zipController;
                    File file = (File)objectArray[n3];
                    Object v = controllers.get(file);
                    if (v instanceof Reference) {
                        zipController = (ZipController)((Reference)v).get();
                        if (!$assertionsDisabled && zipController == null) {
                            throw new AssertionError();
                        }
                        if (zipController == null) continue;
                        if (!$assertionsDisabled && (zipController.hasUpdatedEntries() || zipController.needsReassembly)) {
                            throw new AssertionError();
                        }
                    } else {
                        zipController = (ZipController)v;
                        if (zipController.hasUpdatedEntries()) {
                            ++n2;
                        } else if (!$assertionsDisabled && !zipController.needsReassembly) {
                            throw new AssertionError();
                        }
                    }
                    ZipController zipController2 = zipController;
                    synchronized (zipController2) {
                        try {
                            object = zipController.update((ZipControllerException)object, bl, bl2, true);
                        }
                        catch (ZipControllerException zipControllerException) {
                            object = zipControllerException;
                        }
                    }
                    ++n;
                }
                if (object != null) {
                    throw ((ZipControllerException)object).sortPriority();
                }
                Object var16_17 = null;
            }
            catch (ZipWarningException zipWarningException) {
                logger.log(Level.FINE, "updateAll.throwing", zipWarningException);
                throw zipWarningException;
            }
            catch (ZipControllerException zipControllerException) {
                logger.log(Level.FINE, "updateAll.throwing", zipControllerException);
                throw zipControllerException;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            CountingInputStream.setResetOnReuse();
            CountingOutputStream.setResetOnReuse();
            logger.log(Level.FINE, "updateAll.finally", new Object[]{new Integer(n), new Integer(n2)});
            throw throwable;
        }
        CountingInputStream.setResetOnReuse();
        CountingOutputStream.setResetOnReuse();
        logger.log(Level.FINE, "updateAll.finally", new Object[]{new Integer(n), new Integer(n2)});
    }

    final void update() throws ZipControllerException {
        ZipControllerException zipControllerException = this.update(null, false, false, false);
        if (zipControllerException != null) {
            if (!$assertionsDisabled && !(zipControllerException instanceof ZipWarningException)) {
                throw new AssertionError();
            }
            throw zipControllerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ZipControllerException update(ZipControllerException zipControllerException, boolean bl, boolean bl2, boolean bl3) throws ZipControllerException {
        if (!$assertionsDisabled && this.inZip != null && this.inFile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outZip != null && this.outFile == null) {
            throw new AssertionError();
        }
        logger.log(Level.FINER, "update.entering", new Object[]{this.target.getPath(), zipControllerException, bl, bl2, bl3});
        try {
            ZipControllerException zipControllerException2;
            block32: {
                zipControllerException2 = zipControllerException;
                if (this.hasOpenStreams()) {
                    System.gc();
                    System.runFinalization();
                    Thread.interrupted();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.hasOpenStreams()) {
                        if (!bl) {
                            throw new ZipBusyException(zipControllerException, this.target);
                        }
                        zipControllerException = new ZipBusyWarningException(zipControllerException, this.target);
                    }
                }
                try {
                    if (this.hasUpdatedEntries()) {
                        block31: {
                            this.needsReassembly = true;
                            try {
                                zipControllerException = this.updateOutFile(zipControllerException);
                                if (!$assertionsDisabled && this.fileSystem != null) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && this.inZip != null) {
                                    throw new AssertionError();
                                }
                                Object var8_8 = null;
                                if ($assertionsDisabled || this.outZip == null) break block31;
                                throw new AssertionError();
                            }
                            catch (Throwable throwable) {
                                Object var8_9 = null;
                                if ($assertionsDisabled) throw throwable;
                                if (this.outZip == null) throw throwable;
                                throw new AssertionError();
                            }
                        }
                        try {
                            if (bl3) {
                                zipControllerException = this.reassembleTargetFile(zipControllerException);
                                this.needsReassembly = false;
                            }
                            this.shutdownStep2(bl2 && !this.needsReassembly);
                            break block32;
                        }
                        catch (Throwable throwable) {
                            this.shutdownStep2(bl2 && !this.needsReassembly);
                            throw throwable;
                        }
                    }
                    if (bl3 && this.needsReassembly) {
                        if (!$assertionsDisabled && this.outFile != null) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.inFile == null) {
                            throw new AssertionError();
                        }
                        this.shutdownStep1();
                        this.outFile = this.inFile;
                        this.inFile = null;
                        try {
                            zipControllerException = this.reassembleTargetFile(zipControllerException);
                            this.needsReassembly = false;
                            this.shutdownStep2(bl2 && !this.needsReassembly);
                            break block32;
                        }
                        catch (Throwable throwable) {
                            this.shutdownStep2(bl2 && !this.needsReassembly);
                            throw throwable;
                        }
                    }
                    if (bl2) {
                        if (!$assertionsDisabled && !bl3) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.needsReassembly) {
                            throw new AssertionError();
                        }
                        this.shutdownStep1();
                        this.shutdownStep2(true);
                    } else if (!$assertionsDisabled && this.outZip != null) {
                        throw new AssertionError();
                    }
                }
                finally {
                    this.schedule(this.needsReassembly);
                }
            }
            if (zipControllerException != zipControllerException2) {
                logger.log(Level.FINER, "update.warning", zipControllerException);
                return zipControllerException;
            }
            logger.log(Level.FINEST, "update.exiting");
            return zipControllerException;
        }
        catch (ZipControllerException zipControllerException3) {
            logger.log(Level.FINE, "update.throwing", zipControllerException3);
            throw zipControllerException3;
        }
    }

    private final boolean hasOpenStreams() {
        return this.inZip != null && this.inZip.busy() || this.outZip != null && this.outZip.busy();
    }

    private final boolean hasUpdatedEntries() {
        return this.fileSystem != null && this.fileSystem.isTouched();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipControllerException updateOutFile(ZipControllerException zipControllerException) throws ZipControllerException {
        long l;
        Object object;
        if (!$assertionsDisabled && !this.hasUpdatedEntries()) {
            throw new AssertionError();
        }
        if (this.outZip != null) {
            ZipOutputStream zipOutputStream = this.outZip;
            synchronized (zipOutputStream) {
                Enumeration enumeration = this.outZip.entries();
                while (enumeration.hasMoreElements()) {
                    object = ((ZipEntry)enumeration.nextElement()).getName();
                    if (this.fileSystem.get((String)object) != null) continue;
                    zipControllerException = new ZipWarningException(zipControllerException, this.target.getPath() + ": Couldn't remove entry: " + (String)object);
                }
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        try {
            this.getOutputStream(null);
        }
        catch (IOException iOException) {
            throw new ZipControllerException(zipControllerException, this.target.getPath() + ": Could not update ZIP compatible file. Update deferred - all changes may get lost!", iOException);
        }
        if (!$assertionsDisabled && this.fileSystem == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outZip == null) {
            throw new AssertionError();
        }
        try {
            object = this.outZip;
            synchronized (object) {
                try {
                    this.outZip.closeEntry();
                    ZipWarningException zipWarningException = null;
                    ZipWarningException zipWarningException2 = null;
                    Enumeration enumeration = this.fileSystem.getReversedEntries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                        String string = zipEntry.getName();
                        if (this.isWritten(string)) continue;
                        if (zipEntry.isDirectory()) {
                            if (string.equals("/") || zipEntry.getTime() == -1L) continue;
                            zipEntry.setMethod((short)0);
                            zipEntry.setCrc(0L);
                            zipEntry.setSize(0L);
                            this.outZip.putNextEntry(zipEntry);
                            this.outZip.closeEntry();
                            continue;
                        }
                        if (this.inZip != null && this.inZip.getEntry(string) != null) {
                            InputStream inputStream;
                            try {
                                inputStream = this.inZip.getInputStream(zipEntry, false);
                            }
                            catch (IOException iOException) {
                                if (zipWarningException != null) continue;
                                zipWarningException = new ZipWarningException(zipControllerException, this.target.getPath() + ": Skipped one or more corrupted ZIP file entries from the input!", iOException);
                                zipControllerException = zipWarningException;
                                continue;
                            }
                            try {
                                block50: {
                                    if (this.usesNativeTargetFile()) {
                                        inputStream = new CountingInputStream(inputStream);
                                    }
                                    this.outZip.putNextEntry(zipEntry, false);
                                    try {
                                        File.cat(inputStream, this.outZip);
                                    }
                                    catch (InputIOException inputIOException) {
                                        if (zipWarningException2 != null) break block50;
                                        zipWarningException2 = new ZipWarningException(zipControllerException, this.target.getPath() + ": One or more ZIP file entries in the output may be corrupted!", inputIOException);
                                        zipControllerException = zipWarningException2;
                                    }
                                }
                                this.outZip.closeEntry();
                                continue;
                            }
                            finally {
                                inputStream.close();
                                continue;
                            }
                        }
                        this.outZip.putNextEntry(zipEntry);
                        this.outZip.closeEntry();
                    }
                    this.retainPostamble();
                    Object var14_21 = null;
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    long l2 = this.fileSystem.getRoot().getTime();
                    this.fileSystem = null;
                    try {
                        if (this.inZip != null) {
                            try {
                                this.inZip.close();
                            }
                            finally {
                                this.inZip = null;
                            }
                        }
                        Object var17_27 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var17_28 = null;
                        try {
                            this.outZip.close();
                        }
                        finally {
                            this.outZip = null;
                        }
                        throw throwable2;
                    }
                    try {
                        this.outZip.close();
                    }
                    finally {
                        this.outZip = null;
                    }
                    throw throwable;
                }
                l = this.fileSystem.getRoot().getTime();
                this.fileSystem = null;
                try {
                    if (this.inZip != null) {
                        try {
                            this.inZip.close();
                        }
                        finally {
                            this.inZip = null;
                        }
                    }
                    Object var17_25 = null;
                }
                catch (Throwable throwable) {
                    Object var17_26 = null;
                    try {
                        this.outZip.close();
                    }
                    finally {
                        this.outZip = null;
                    }
                    throw throwable;
                }
                try {
                    this.outZip.close();
                }
                finally {
                    this.outZip = null;
                }
            }
        }
        catch (IOException iOException) {
            boolean bl = this.outFile.delete();
            this.outFile = null;
            if (!$assertionsDisabled && !bl) {
                throw new AssertionError();
            }
            throw new ZipControllerException(zipControllerException, this.target.getPath() + ": Could not update ZIP compatible file - all changes are lost!", iOException);
        }
        if (!this.outFile.setLastModified(l)) {
            zipControllerException = new ZipWarningException(zipControllerException, this.target.getPath() + ": Couldn't preserve last modification time!");
        }
        return zipControllerException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retainPostamble() throws IOException {
        if (!$assertionsDisabled && this.outZip == null) {
            throw new AssertionError();
        }
        if (this.inZip == null) {
            return;
        }
        long l = this.inZip.length();
        long l2 = this.outZip.length();
        long l3 = this.inZip.getPostambleLength();
        if (l3 <= 0L) {
            return;
        }
        this.outZip.finish();
        InputStream inputStream = this.inZip.getPostambleInputStream();
        try {
            if (l2 + l3 != l) {
                this.outZip.write(new byte[(int)(l2 % 4L)]);
            }
            File.cat(inputStream, this.outZip);
        }
        finally {
            inputStream.close();
        }
    }

    private ZipControllerException reassembleTargetFile(ZipControllerException zipControllerException) throws ZipControllerException {
        if (this.usesNativeTargetFile()) {
            java.io.File file = this.target.delegate;
            if (this.outFile != file) {
                try {
                    FileInputStream fileInputStream;
                    CountingOutputStream countingOutputStream = new CountingOutputStream(new FileOutputStream(file));
                    try {
                        fileInputStream = new FileInputStream(this.outFile);
                    }
                    catch (IOException iOException) {
                        ((OutputStream)countingOutputStream).close();
                        throw iOException;
                    }
                    File.cp(fileInputStream, countingOutputStream);
                }
                catch (IOException iOException) {
                    throw new ZipControllerException(zipControllerException, this.target.getPath() + ": Could not update ZIP compatible file - all changes are lost!", iOException);
                }
                long l = this.outFile.lastModified();
                if (l != 0L && !file.setLastModified(l)) {
                    zipControllerException = new ZipWarningException(zipControllerException, this.target.getPath() + ": Couldn't preserve last modification time!");
                }
            }
        } else {
            try {
                this.wrap(this.enclController, this.enclEntryName);
            }
            catch (IOException iOException) {
                throw new ZipControllerException(zipControllerException, this.enclController.target.getPath() + "\nCould not update ZIP entry: " + this.enclEntryName + "\nAll changes are lost!", iOException);
            }
        }
        return zipControllerException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrap(ZipController zipController, String string) throws IOException {
        if (!$assertionsDisabled && zipController == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "" == string) {
            throw new AssertionError();
        }
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                FileInputStream fileInputStream;
                OutputStream outputStream = zipController.getOutputStream(string, this.outFile.lastModified(), -1, null);
                try {
                    fileInputStream = new FileInputStream(this.outFile);
                }
                catch (IOException iOException) {
                    outputStream.close();
                    throw iOException;
                }
                File.cp(fileInputStream, outputStream);
            }
        }
        catch (FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            if (!$assertionsDisabled && falsePositiveDirectoryEntryException.getController() == zipController) {
                throw new AssertionError();
            }
            this.wrap(zipController.enclController, zipController.enclEntryName + '/' + string);
        }
        catch (FalsePositiveException falsePositiveException) {
            throw new AssertionError((Object)falsePositiveException);
        }
    }

    protected void finalize() throws Throwable {
        logger.log(Level.FINEST, "finalize", this.target.getPath());
        this.shutdownStep1();
        this.shutdownStep2(true);
        super.finalize();
    }

    final void reset() {
        this.shutdownStep1();
        this.shutdownStep2(true);
        this.schedule(false);
    }

    private void shutdownStep1() {
        this.fileSystem = null;
        if (this.inZip != null) {
            try {
                this.inZip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inZip = null;
        }
        if (this.outZip != null) {
            try {
                this.outZip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outZip = null;
        }
    }

    private void shutdownStep2(boolean bl) {
        boolean bl2;
        java.io.File file = this.target.delegate;
        if (this.inFile != null) {
            if (this.inFile != file) {
                bl2 = this.inFile.delete();
                if (!$assertionsDisabled && !bl2) {
                    throw new AssertionError();
                }
            }
            this.inFile = null;
        }
        if (this.outFile != null) {
            if (bl) {
                if (this.outFile != file) {
                    bl2 = this.outFile.delete();
                    if (!$assertionsDisabled && !bl2) {
                        throw new AssertionError();
                    }
                }
            } else {
                if (!$assertionsDisabled && !this.outFile.isFile()) {
                    throw new AssertionError();
                }
                this.inFile = this.outFile;
            }
            this.outFile = null;
        }
        if (bl) {
            this.needsReassembly = false;
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "(" + this.target.getPath() + ")";
    }

    static {
        $assertionsDisabled = !ZipController.class.desiredAssertionStatus();
        logger = Logger.getLogger("de.schlichtherle.io.ZipController", "de.schlichtherle.io.ZipController");
        Runtime.getRuntime().addShutdownHook(ShutdownHook.singleton);
        controllers = new WeakHashMap();
    }

    static class CountingOutputStream
    extends FilterOutputStream {
        private static volatile long _total;
        private static volatile boolean _resetOnReuse;

        public static long getTotal() {
            return _total;
        }

        private static void setResetOnReuse() {
            _resetOnReuse = true;
        }

        private static void resetOnReuse() {
            if (_resetOnReuse) {
                _resetOnReuse = false;
                _total = 0L;
            }
        }

        public CountingOutputStream(OutputStream outputStream) {
            super(outputStream);
            CountingOutputStream.resetOnReuse();
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++_total;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            _total += (long)n2;
        }
    }

    static class CountingInputStream
    extends FilterInputStream {
        private static volatile long _total;
        private static volatile boolean _resetOnReuse;

        public static long getTotal() {
            return _total;
        }

        private static void setResetOnReuse() {
            _resetOnReuse = true;
        }

        private static void resetOnReuse() {
            if (_resetOnReuse) {
                _resetOnReuse = false;
                _total = 0L;
            }
        }

        public CountingInputStream(InputStream inputStream) {
            super(inputStream);
            CountingInputStream.resetOnReuse();
        }

        public int read() throws IOException {
            int n = this.in.read();
            ++_total;
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 != -1) {
                _total += (long)n3;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            l = this.in.skip(l);
            _total += l;
            return l;
        }

        public boolean markSupported() {
            return false;
        }
    }

    private class ZipEntryNotFoundException
    extends FileNotFoundException {
        private final String entry;
        private final String msg;

        private ZipEntryNotFoundException(String string, String string2) {
            this.entry = string;
            this.msg = string2;
        }

        public String getMessage() {
            return ZipController.this.target.getPath() + this.entry + ": " + this.msg;
        }
    }

    class FalsePositiveDirectoryEntryException
    extends FalsePositiveEntryException {
        FalsePositiveDirectoryEntryException() {
        }

        private ZipController getController() {
            return ZipController.this;
        }
    }

    static class FalsePositiveFileEntryException
    extends FalsePositiveEntryException {
        private FalsePositiveFileEntryException(IOException iOException) {
            super(iOException);
        }
    }

    static abstract class FalsePositiveEntryException
    extends FalsePositiveException {
        private FalsePositiveEntryException() {
        }

        private FalsePositiveEntryException(IOException iOException) {
            this.initCause(iOException);
        }
    }

    static class FalsePositiveNativeException
    extends FalsePositiveException {
        private FalsePositiveNativeException(IOException iOException) {
            this.initCause(iOException);
        }
    }

    static abstract class FalsePositiveException
    extends FileNotFoundException {
        FalsePositiveException() {
        }
    }

    private class ZipFileNotFoundException
    extends FileNotFoundException {
        private ZipFileNotFoundException() {
        }

        public String getMessage() {
            return ZipController.this.target.getPath();
        }
    }

    private class IllegalRecursiveMountOrCreateFileSystem
    extends FileNotFoundException {
        private IllegalRecursiveMountOrCreateFileSystem() {
        }

        public String getMessage() {
            return ZipController.this.target.getPath();
        }
    }

    static class ShutdownHook
    extends Thread {
        private static final ShutdownHook singleton = new ShutdownHook();
        static final Set deleteOnExit = Collections.synchronizedSet(new LinkedHashSet());

        private ShutdownHook() {
            super("TrueZIP ZIP update shutdown hook");
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz = class$de$schlichtherle$crypto$io$PasswdManager == null ? (class$de$schlichtherle$crypto$io$PasswdManager = ZipController.class$("de.schlichtherle.crypto.io.PasswdManager")) : class$de$schlichtherle$crypto$io$PasswdManager;
            synchronized (clazz) {
                try {
                    PasswdManager.setPrompting(false);
                    logger.setLevel(Level.OFF);
                    Iterator iterator = deleteOnExit.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        if (!file.exists() || file.delete()) continue;
                        System.err.println(file.getPath() + ": failed to deleteOnExit()!");
                    }
                }
                finally {
                    try {
                        ZipController.updateAll(true, true, false);
                    }
                    catch (ZipControllerException zipControllerException) {
                        zipControllerException.printStackTrace();
                    }
                }
            }
        }
    }
}

