/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Comparator;

public class ZipControllerException
extends IOException
implements Cloneable {
    static final Comparator PRIORITY_COMP = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = ((ZipControllerException)object).getPriority() - ((ZipControllerException)object2).getPriority();
            return n != 0 ? n : APPEARANCE_COMP.compare(object, object2);
        }
    };
    static final Comparator APPEARANCE_COMP = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ZipControllerException)object).getAppearance() - ((ZipControllerException)object2).getAppearance();
        }
    };
    static int counter;
    private static int maxPrintExceptions;
    private final int appearance = counter++;
    private ZipControllerException prior;

    public static void setMaxPrintExceptions(int n) {
        maxPrintExceptions = n;
    }

    public static int getMaxPrintExceptions() {
        return maxPrintExceptions;
    }

    public ZipControllerException(ZipControllerException zipControllerException) {
        this.prior = zipControllerException;
    }

    public ZipControllerException(ZipControllerException zipControllerException, String string) {
        super(string);
        this.prior = zipControllerException;
    }

    public ZipControllerException(ZipControllerException zipControllerException, Throwable throwable) {
        this.prior = zipControllerException;
        this.initCause(throwable);
    }

    public ZipControllerException(ZipControllerException zipControllerException, String string, Throwable throwable) {
        super(string);
        this.prior = zipControllerException;
        this.initCause(throwable);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public int getPriority() {
        return 0;
    }

    public final int getAppearance() {
        return this.appearance;
    }

    public ZipControllerException getPrior() {
        return this.prior;
    }

    public ZipControllerException getTail() {
        return this.prior;
    }

    public ZipControllerException sortPriority() {
        return this.sort(PRIORITY_COMP);
    }

    public ZipControllerException sortAppearance() {
        return this.sort(APPEARANCE_COMP);
    }

    private ZipControllerException sort(Comparator comparator) {
        if (this.prior != null) {
            ZipControllerException zipControllerException = this.prior.sort(comparator);
            if (zipControllerException == this.prior && comparator.compare(this, this.prior) >= 0) {
                return this;
            }
            return zipControllerException.insert((ZipControllerException)this.clone(), comparator);
        }
        return this;
    }

    private ZipControllerException insert(ZipControllerException zipControllerException, Comparator comparator) {
        if (comparator.compare(zipControllerException, this) >= 0) {
            zipControllerException.prior = this;
            return zipControllerException;
        }
        ZipControllerException zipControllerException2 = (ZipControllerException)this.clone();
        if (this.prior != null) {
            zipControllerException2.prior = this.prior.insert(zipControllerException, comparator);
        } else {
            zipControllerException.prior = null;
            zipControllerException2.prior = zipControllerException;
        }
        return zipControllerException2;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(printStream, ZipControllerException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintStream printStream, int n) {
        --n;
        if (this.prior != null) {
            if (n > 0) {
                this.prior.printStackTrace(printStream, n);
                printStream.println("Followed, but not caused by:");
            } else {
                printStream.println("(Omitting " + this.prior.numExceptions() + " exception(s) at the start of this list)");
            }
        }
        super.printStackTrace(printStream);
    }

    private int numExceptions() {
        return this.prior != null ? this.prior.numExceptions() + 1 : 1;
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.printStackTrace(printWriter, ZipControllerException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintWriter printWriter, int n) {
        --n;
        if (this.prior != null) {
            if (n > 0) {
                this.prior.printStackTrace(printWriter, n);
                printWriter.println("Followed, but not caused by:");
            } else {
                printWriter.println("(Omitting " + this.prior.numExceptions() + " exception(s) at the start of this list)");
            }
        }
        super.printStackTrace(printWriter);
    }

    static {
        maxPrintExceptions = 5;
    }
}

