/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.util.zip.ZipConstants;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.zip.ZipException;

public class ZipEntry
implements ZipConstants,
Cloneable {
    private final String name;
    private short platform = 0;
    private short method = (short)-1;
    private long time = -1L;
    private long crc = -1L;
    private long csize = -1L;
    private long size = -1L;
    private byte[] extra;
    private String comment;
    long offset = -1L;
    static ThreadLocal calendar = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new GregorianCalendar();
        }
    };

    public ZipEntry(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() > 65535) {
            throw new IllegalArgumentException("Entry name too long!");
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this.name = zipEntry.name;
        this.method = zipEntry.method;
        this.time = zipEntry.time;
        this.crc = zipEntry.crc;
        this.size = zipEntry.size;
        this.csize = zipEntry.csize;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
        this.offset = zipEntry.offset;
    }

    public Object clone() {
        try {
            ZipEntry zipEntry = (ZipEntry)super.clone();
            zipEntry.extra = this.extra != null ? (byte[])this.extra.clone() : null;
            return zipEntry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public void copyFrom(ZipEntry zipEntry) {
        this.setPlatform(zipEntry.getPlatform());
        this.setMethod(zipEntry.getMethod());
        this.setCrc(zipEntry.getCrc());
        this.setCompressedSize(zipEntry.getCompressedSize());
        this.setSize(zipEntry.getSize());
        this.setDosTime(zipEntry.getDosTime());
        byte[] byArray = zipEntry.getExtra();
        this.setExtra(byArray != null ? (byte[])byArray.clone() : null);
        this.setComment(zipEntry.getComment());
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public short getPlatform() {
        return this.platform;
    }

    public void setPlatform(short s) {
        this.platform = s;
    }

    public short getMethod() {
        return this.method;
    }

    public void setMethod(short s) {
        if (s != 0 && s != 8) {
            throw new IllegalArgumentException(this.name + ": Invalid entry compression method!");
        }
        this.method = s;
    }

    protected long getDosTime() {
        return this.time;
    }

    protected void setDosTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(this.name + ": Invalid entry modification time!");
        }
        this.time = l;
    }

    public long getTime() {
        return this.time != -1L ? ZipEntry.dos2javaTime(this.time) : -1L;
    }

    public void setTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(this.name + ": Invalid entry modification time!");
        }
        this.time = l != -1L ? ZipEntry.java2dosTime(l) : -1L;
    }

    public long compareToTime(long l) {
        return this.getDosTime() - ZipEntry.java2dosTime(l);
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long l) {
        if (l < 0L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException(this.name + ": Invalid entry crc!");
        }
        this.crc = l;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long l) {
        if (l < 0L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException(this.name + ": Invalid entry compressed size!");
        }
        this.csize = l;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        if (l < 0L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException(this.name + ": Invalid entry size!");
        }
        this.size = l;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setExtra(byte[] byArray) {
        if (byArray != null && 65535 < byArray.length) {
            throw new IllegalArgumentException(this.name + ": Invalid entry extra field length!");
        }
        this.extra = byArray;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        if (string != null && 65535 < string.length()) {
            throw new IllegalArgumentException(this.name + ": Invalid entry comment length!");
        }
        this.comment = string;
    }

    public String toString() {
        return this.getName();
    }

    protected static long dos2javaTime(long l) {
        Calendar calendar = (Calendar)ZipEntry.calendar.get();
        calendar.set(1, (int)(l >> 25 & 0xFFL) + 1980);
        calendar.set(2, (int)(l >> 21 & 0xFL) - 1);
        calendar.set(5, (int)(l >> 16) & 0x1F);
        calendar.set(11, (int)(l >> 11) & 0x1F);
        calendar.set(12, (int)(l >> 5) & 0x3F);
        calendar.set(13, (int)(l << 1) & 0x3E);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    protected static long java2dosTime(long l) {
        Calendar calendar = (Calendar)ZipEntry.calendar.get();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        if (n < 1980) {
            return 0x210000L;
        }
        return (n - 1980 & 0xFF) << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
    }
}

