/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.Map;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLModel {
    private static final Map<String, String> emptyArgs = Collections.emptyMap();
    private final WebScriptRequest req;

    URLModel(WebScriptRequest req) {
        this.req = req;
    }

    public String getServer() {
        return this.req.getServerPath();
    }

    public String getContext() {
        return this.req.getContextPath();
    }

    public String getServiceContext() {
        return this.req.getServiceContextPath();
    }

    public String getService() {
        return this.req.getServicePath();
    }

    public String getFull() {
        return this.req.getURL();
    }

    public String getArgs() {
        String args = this.req.getQueryString();
        return args == null ? "" : args;
    }

    public String getMatch() {
        return this.req.getServiceMatch().getPath();
    }

    public String getExtension() {
        return this.req.getExtensionPath();
    }

    public String getTemplate() {
        return this.req.getServiceMatch().getTemplate();
    }

    public Map<String, String> getTemplateArgs() {
        Map<String, String> args = this.req.getServiceMatch().getTemplateVars();
        return args == null ? emptyArgs : args;
    }
}

