/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class EndpointManager {
    private static final int RECONNECT_TIMEOUT = 20000;
    private static ConcurrentMap<String, Long> endpointTimeouts = new ConcurrentHashMap<String, Long>();

    private EndpointManager() {
    }

    public static void registerEndpoint(String endpoint) {
        endpointTimeouts.putIfAbsent(endpoint, 0L);
    }

    public static boolean allowConnect(String endpoint) {
        return (Long)endpointTimeouts.get(endpoint) + 20000L < System.currentTimeMillis();
    }

    public static boolean processResponseCode(String endpoint, int code) {
        boolean allowContinue = true;
        if (498 == code || 499 == code) {
            endpointTimeouts.put(endpoint, System.currentTimeMillis());
            allowContinue = false;
        }
        return allowContinue;
    }
}

