/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.json;

import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.json.JSONWriter;

@ScriptClass(help="Collection of JSON Utility methods.", code="//JavaScript Sample Code\nvar myObj = {'name':'Test Object','size':100};\nvar myObjAsString = jsonUtils.toJSONString(myObj);\n\n//Freemarker Template Sample Code\n[\n    <#list tags as tag>\n        ${jsonUtils.encodeJSONString(tag)}<#if tag_has_next>,</#if>\n    </#list>\n]", types={ScriptClassType.JavaScriptRootObject, ScriptClassType.TemplateRootObject})
public class JSONUtils {
    @ScriptMethod(help="Converts a given JavaScript native object and converts it to the relevant JSON string.", code="//JavaScript Sample Code\nvar myObj = {'name':'Test Object','size':100};\nvar myObjAsString = jsonUtils.toJSONString(myObj);", output="JSON string")
    public String toJSONString(@ScriptParameter(help="JavaScript object") Object object) throws JSONException {
        JSONStringer json = new JSONStringer();
        if (object instanceof NativeArray) {
            this.nativeArrayToJSONString((NativeArray)object, json);
        } else if (object instanceof NativeObject) {
            this.nativeObjectToJSONString((NativeObject)object, json);
        } else {
            throw new WebScriptsPlatformException("Only native objects and arrays are currently supported by the toJSONString method.");
        }
        return json.toString();
    }

    @ScriptMethod(help="Takes a JSON string and converts it to a native java script object", code="//JavaScript Sample Code\nmodel.postCode = jsonUtils.toObject(json).postCode;", output="the created native JS object that represents the JSON object")
    public NativeObject toObject(@ScriptParameter(help="A valid json string") String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        return this.toObject(jsonObject);
    }

    @ScriptMethod(help="Takes a JSON object and converts it to a native java script object", code="//JavaScript Sample Code\nmodel.postCode = jsonUtils.toObject(json).postCode;", output="the created native object")
    public NativeObject toObject(@ScriptParameter(help="The json object") JSONObject jsonObject) throws JSONException {
        NativeObject object = new NativeObject();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                object.put(key, (Scriptable)object, (Object)this.toObject((JSONObject)value));
                continue;
            }
            object.put(key, (Scriptable)object, value);
        }
        return object;
    }

    private void nativeObjectToJSONString(NativeObject nativeObject, JSONStringer json) throws JSONException {
        Object[] ids;
        json.object();
        for (Object id : ids = nativeObject.getIds()) {
            String key = id.toString();
            json.key(key);
            Object value = nativeObject.get(key, (Scriptable)nativeObject);
            this.valueToJSONString(value, json);
        }
        json.endObject();
    }

    private void nativeArrayToJSONString(NativeArray nativeArray, JSONStringer json) throws JSONException {
        Object[] propIds = nativeArray.getIds();
        if (this.isArray(propIds)) {
            json.array();
            for (int i = 0; i < propIds.length; ++i) {
                Object propId = propIds[i];
                if (!(propId instanceof Integer)) continue;
                Object value = nativeArray.get(((Integer)propId).intValue(), (Scriptable)nativeArray);
                this.valueToJSONString(value, json);
            }
            json.endArray();
        } else {
            json.object();
            for (Object propId : propIds) {
                Object value = nativeArray.get(propId.toString(), (Scriptable)nativeArray);
                json.key(propId.toString());
                this.valueToJSONString(value, json);
            }
            json.endObject();
        }
    }

    private boolean isArray(Object[] ids) {
        boolean result = true;
        for (Object id : ids) {
            if (id instanceof Integer) continue;
            result = false;
            break;
        }
        return result;
    }

    private void valueToJSONString(Object value, JSONStringer json) throws JSONException {
        if (value instanceof IdScriptableObject && ((IdScriptableObject)value).getClassName().equals("Date")) {
            Object year = NativeObject.callMethod((Scriptable)((IdScriptableObject)value), (String)"getUTCFullYear", null);
            Object month = NativeObject.callMethod((Scriptable)((IdScriptableObject)value), (String)"getUTCMonth", null);
            Object date = NativeObject.callMethod((Scriptable)((IdScriptableObject)value), (String)"getUTCDate", null);
            Object hours = NativeObject.callMethod((Scriptable)((IdScriptableObject)value), (String)"getUTCHours", null);
            Object minutes = NativeObject.callMethod((Scriptable)((IdScriptableObject)value), (String)"getUTCMinutes", null);
            Object seconds = NativeObject.callMethod((Scriptable)((IdScriptableObject)value), (String)"getUTCSeconds", null);
            Object milliSeconds = NativeObject.callMethod((Scriptable)((IdScriptableObject)value), (String)"getUTCMilliseconds", null);
            json.object().key("zone").value((Object)"UTC").key("year").value(year).key("month").value(month).key("date").value(date).key("hours").value(hours).key("minutes").value(minutes).key("seconds").value(seconds).key("milliseconds").value(milliSeconds).endObject();
        } else if (value instanceof NativeJavaObject) {
            Object javaValue = Context.jsToJava((Object)value, Object.class);
            json.value(javaValue);
        } else if (value instanceof NativeArray) {
            this.nativeArrayToJSONString((NativeArray)value, json);
        } else if (value instanceof NativeObject) {
            this.nativeObjectToJSONString((NativeObject)value, json);
        } else {
            json.value(value);
        }
    }

    @ScriptMethod(help="Encodes a JSON string value", output="Encoded value")
    public Object encodeJSONString(@ScriptParameter(help="Value to encode") Object value) {
        if (value instanceof String) {
            return JSONWriter.encodeJSONString((String)value);
        }
        return value;
    }
}

