/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.AbstractRuntime;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptRequestURLImpl;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptSession;
import org.springframework.extensions.webscripts.portlet.PortletAuthenticatorFactory;
import org.springframework.extensions.webscripts.portlet.WebScriptPortletRequest;
import org.springframework.extensions.webscripts.portlet.WebScriptPortletResponse;
import org.springframework.extensions.webscripts.portlet.WebScriptPortletSession;
import org.springframework.web.context.WebApplicationContext;

public class WebScriptPortlet
implements Portlet {
    private static Log logger = LogFactory.getLog(WebScriptPortlet.class);
    protected String initScriptUrl = null;
    protected RuntimeContainer container;
    protected PortletAuthenticatorFactory authenticatorFactory;

    public void init(PortletConfig config) throws PortletException {
        this.initScriptUrl = config.getInitParameter("scriptUrl");
        PortletContext portletCtx = config.getPortletContext();
        WebApplicationContext context = (WebApplicationContext)portletCtx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        this.container = (RuntimeContainer)context.getBean("webscripts.container");
        String authenticatorId = config.getInitParameter("authenticator");
        if (authenticatorId != null && authenticatorId.length() > 0) {
            Object bean = context.getBean(authenticatorId);
            if (bean == null || !(bean instanceof PortletAuthenticatorFactory)) {
                throw new PortletException("Initialisation parameter 'authenticator' does not refer to a portlet authenticator factory (" + authenticatorId + ")");
            }
            this.authenticatorFactory = (PortletAuthenticatorFactory)bean;
        }
    }

    public void processAction(ActionRequest req, ActionResponse res) throws PortletException, PortletSecurityException, IOException {
        Map params = req.getParameterMap();
        for (Map.Entry param : params.entrySet()) {
            String name = (String)param.getKey();
            if (!name.equals("scriptUrl") && !name.startsWith("arg.")) continue;
            res.setRenderParameter(name, (String[])param.getValue());
        }
    }

    public void render(RenderRequest req, RenderResponse res) throws PortletException, PortletSecurityException, IOException {
        PortletMode portletMode = req.getPortletMode();
        if (PortletMode.VIEW.equals((Object)portletMode)) {
            this.doView(req, res);
        }
    }

    public void destroy() {
    }

    protected void doView(RenderRequest req, RenderResponse res) throws PortletException, PortletSecurityException, IOException {
        String scriptUrl = req.getParameter("scriptUrl");
        if (scriptUrl != null) {
            StringBuilder scriptUrlArgs = new StringBuilder(128);
            Map params = req.getParameterMap();
            for (Map.Entry param : params.entrySet()) {
                String name = (String)param.getKey();
                if (!name.startsWith("arg.")) continue;
                String argName = name.substring("arg.".length());
                for (String argValue : (String[])param.getValue()) {
                    scriptUrlArgs.append(scriptUrlArgs.length() == 0 ? "" : "&");
                    scriptUrlArgs.append(argName).append("=").append(URLDecoder.decode((String)argValue));
                }
            }
            scriptUrl = scriptUrl + (scriptUrlArgs.length() != 0 ? "?" + scriptUrlArgs.toString() : "");
        } else {
            scriptUrl = this.initScriptUrl;
            if (scriptUrl == null) {
                throw new PortletException("Initial Web script URL has not been specified.");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing portal render request " + req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + "/" + req.getContextPath() + " (scriptUrl=" + scriptUrl + ")"));
        }
        PortletRuntime runtime = new PortletRuntime(this.container, req, res, scriptUrl);
        runtime.executeScript();
    }

    private class PortletRuntime
    extends AbstractRuntime {
        private RenderRequest req;
        private RenderResponse res;
        private String[] requestUrlParts;

        public PortletRuntime(RuntimeContainer container, RenderRequest req, RenderResponse res, String requestUrl) {
            super(container);
            this.req = req;
            this.res = res;
            this.requestUrlParts = WebScriptRequestURLImpl.splitURL(requestUrl);
        }

        public String getName() {
            return "JSR-168 Portal";
        }

        protected String getScriptMethod() {
            return "get";
        }

        protected String getScriptUrl() {
            return this.requestUrlParts[2];
        }

        protected Authenticator createAuthenticator() {
            if (WebScriptPortlet.this.authenticatorFactory == null) {
                return null;
            }
            return WebScriptPortlet.this.authenticatorFactory.create(this.req, this.res);
        }

        protected WebScriptRequest createRequest(Match match) {
            return new WebScriptPortletRequest((Runtime)this, (PortletRequest)this.req, this.requestUrlParts, match);
        }

        protected WebScriptResponse createResponse() {
            return new WebScriptPortletResponse(this, this.res);
        }

        protected WebScriptSession createSession() {
            return new WebScriptPortletSession(this.req.getPortletSession());
        }

        protected void executeScript(WebScriptRequest scriptReq, WebScriptResponse scriptRes, Authenticator auth) throws IOException {
            WebScript script = scriptReq.getServiceMatch().getWebScript();
            Description desc = script.getDescription();
            this.res.setTitle(desc.getShortName());
            if (!WindowState.MINIMIZED.equals((Object)this.req.getWindowState())) {
                super.executeScript(scriptReq, scriptRes, auth);
            }
        }
    }
}

