/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao.event;

import net.sf.acegisecurity.providers.dao.event.AuthenticationEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureAccountExpiredEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureAccountLockedEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureCredentialsExpiredEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureDisabledEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailurePasswordEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureUsernameNotFoundEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureUsernameOrPasswordEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationSuccessEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class LoggerListener
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$dao$event$LoggerListener == null ? (class$net$sf$acegisecurity$providers$dao$event$LoggerListener = LoggerListener.class$("net.sf.acegisecurity.providers.dao.event.LoggerListener")) : class$net$sf$acegisecurity$providers$dao$event$LoggerListener));
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$dao$event$LoggerListener;

    public void onApplicationEvent(ApplicationEvent event) {
        AuthenticationEvent authEvent;
        if (event instanceof AuthenticationFailurePasswordEvent) {
            authEvent = (AuthenticationFailurePasswordEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Authentication failed due to incorrect password for user: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
        if (event instanceof AuthenticationFailureDisabledEvent) {
            authEvent = (AuthenticationFailureDisabledEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Authentication failed due to account being disabled for user: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
        if (event instanceof AuthenticationFailureAccountLockedEvent) {
            authEvent = (AuthenticationFailureAccountLockedEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Authentication failed due to account being locked for user: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
        if (event instanceof AuthenticationFailureCredentialsExpiredEvent) {
            authEvent = (AuthenticationFailureCredentialsExpiredEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Authentication failed due to account credentials have been expired for user: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
        if (event instanceof AuthenticationFailureAccountExpiredEvent) {
            authEvent = (AuthenticationFailureAccountExpiredEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Authentication failed due to account having expired for user: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
        if (event instanceof AuthenticationFailureUsernameNotFoundEvent) {
            authEvent = (AuthenticationFailureUsernameNotFoundEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Authentication failed due to nonexistent username: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
        if (event instanceof AuthenticationFailureUsernameOrPasswordEvent) {
            authEvent = (AuthenticationFailureUsernameOrPasswordEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Authentication failed due to invalid username or password: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
        if (event instanceof AuthenticationSuccessEvent) {
            authEvent = (AuthenticationSuccessEvent)event;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Authentication success for user: " + authEvent.getUser().getUsername() + "; details: " + authEvent.getAuthentication().getDetails()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

