/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvDatasetImpl
extends InvDataset {
    private String urlPath;
    private String alias;
    private double size = 0.0;
    private List<InvAccess> accessLocal = new ArrayList<InvAccess>();
    private List<InvService> servicesLocal = new ArrayList<InvService>();
    protected ThreddsMetadata tm = new ThreddsMetadata(false);
    protected ThreddsMetadata tmi = new ThreddsMetadata(true);
    protected ThreddsMetadata tmi6 = new ThreddsMetadata(true);
    protected Element ncmlElement;
    protected StringBuilder log = new StringBuilder();
    protected boolean mark = false;
    private boolean debugInherit = false;
    private boolean debugInherit2 = false;
    private HashMap<Object, Object> userMap = null;
    private volatile int hashCode = 0;

    public InvDatasetImpl(InvDatasetImpl parent, String name, FeatureType dataType, String serviceName, String urlPath) {
        super(parent, name);
        this.tm.setDataType(dataType);
        this.tm.setServiceName(serviceName);
        this.urlPath = urlPath;
    }

    public boolean finish() {
        boolean ok = true;
        if (this.debugInherit) {
            System.out.println("Now finish " + this.getName() + " id= " + this.getID());
        }
        this.authorityName = null;
        this.dataType = null;
        this.dataFormatType = null;
        this.defaultService = null;
        this.gc = null;
        this.tc = null;
        this.docs = new ArrayList();
        this.metadata = new ArrayList();
        this.properties = new ArrayList();
        this.creators = new ArrayList();
        this.contributors = new ArrayList();
        this.dates = new ArrayList();
        this.keywords = new ArrayList();
        this.projects = new ArrayList();
        this.publishers = new ArrayList();
        this.variables = new ArrayList();
        this.canonicalize();
        this.transfer2PublicMetadata(this.tm, true);
        this.transfer2PublicMetadata(this.tmi, true);
        this.transfer2PublicMetadata(this.tmi6, true);
        this.transferInheritable2PublicMetadata((InvDatasetImpl)this.getParent());
        this.access = new ArrayList();
        if (this.urlPath != null && this.getServiceDefault() != null) {
            InvAccessImpl invAccessImpl = new InvAccessImpl(this, this.urlPath, this.getServiceDefault());
            invAccessImpl.setSize(this.size);
            invAccessImpl.finish();
            this.addExpandedAccess(invAccessImpl);
        }
        for (InvAccessImpl invAccessImpl : this.accessLocal) {
            invAccessImpl.finish();
            this.addExpandedAccess(invAccessImpl);
        }
        if (!(this instanceof InvCatalogRef)) {
            for (InvDataset invDataset : this.getDatasets()) {
                InvDatasetImpl curDs = (InvDatasetImpl)invDataset;
                ok &= curDs.finish();
            }
        }
        return ok;
    }

    private void transferInheritable2PublicMetadata(InvDatasetImpl parent) {
        if (parent == null) {
            return;
        }
        if (this.debugInherit) {
            System.out.println(" inheritFromParent= " + parent.getID());
        }
        this.transfer2PublicMetadata(parent.getLocalMetadataInheritable(), true);
        this.transferInheritable2PublicMetadata((InvDatasetImpl)parent.getParent());
    }

    private void transfer2PublicMetadata(ThreddsMetadata tmd, boolean inheritAll) {
        DateRange ttc;
        ThreddsMetadata.GeospatialCoverage tgc;
        if (tmd == null) {
            return;
        }
        if (this.debugInherit) {
            System.out.println("  transferMetadata " + tmd);
        }
        if (this.authorityName == null) {
            this.authorityName = tmd.getAuthority();
        }
        if (this.dataType == null || this.dataType == FeatureType.NONE) {
            this.dataType = tmd.getDataType();
        }
        if (this.dataFormatType == null || this.dataFormatType == DataFormatType.NONE) {
            this.dataFormatType = tmd.getDataFormatType();
        }
        if (this.defaultService == null) {
            this.defaultService = this.findService(tmd.getServiceName());
        }
        if (this.gc == null && (tgc = tmd.getGeospatialCoverage()) != null && !tgc.isEmpty()) {
            this.gc = tgc;
        }
        if (this.tc == null && (ttc = tmd.getTimeCoverage()) != null) {
            this.tc = ttc;
        }
        if (this.tc == null) {
            this.tc = tmd.getTimeCoverage();
        }
        for (InvProperty item : tmd.getProperties()) {
            if (this.properties.contains(item)) continue;
            if (this.debugInherit) {
                System.out.println("  add Property " + item + " to " + this.getID());
            }
            this.properties.add(item);
        }
        this.creators.addAll(tmd.getCreators());
        this.contributors.addAll(tmd.getContributors());
        this.dates.addAll(tmd.getDates());
        this.docs.addAll(tmd.getDocumentation());
        this.keywords.addAll(tmd.getKeywords());
        this.projects.addAll(tmd.getProjects());
        this.publishers.addAll(tmd.getPublishers());
        this.variables.addAll(tmd.getVariables());
        for (InvMetadata meta : tmd.getMetadata()) {
            if (!meta.isInherited() && !inheritAll) continue;
            if (!meta.isThreddsMetadata()) {
                this.metadata.add(meta);
                continue;
            }
            if (this.debugInherit) {
                System.out.println("  add metadata Element " + tmd.isInherited() + " " + meta);
            }
            meta.finish();
            this.transfer2PublicMetadata(meta.getThreddsMetadata(), inheritAll);
            this.metadata.add(meta);
        }
    }

    public void transferMetadata(InvDatasetImpl fromDs) {
        if (this.debugInherit2) {
            System.out.println(" transferMetadata= " + fromDs.getName());
        }
        if (this != fromDs) {
            this.getLocalMetadata().add(fromDs.getLocalMetadata(), false);
        }
        this.transferInheritableMetadata(fromDs, this.getLocalMetadataInheritable());
        this.setResourceControl(fromDs.getRestrictAccess());
    }

    private void transferInheritableMetadata(InvDatasetImpl fromDs, ThreddsMetadata target) {
        if (fromDs == null) {
            return;
        }
        if (this.debugInherit2) {
            System.out.println(" transferInheritedMetadata= " + fromDs.getName());
        }
        target.add(fromDs.getLocalMetadataInheritable(), true);
        this.transferInheritableMetadata((InvDatasetImpl)fromDs.getParent(), target);
    }

    private void addExpandedAccess(InvAccessImpl a) {
        InvService service = a.getService();
        if (null == service) {
            a.check(this.log, false);
            return;
        }
        if (service.getServiceType() == ServiceType.COMPOUND) {
            for (InvService nestedService : service.getServices()) {
                InvAccessImpl nestedAccess = new InvAccessImpl(this, a.getUrlPath(), nestedService);
                this.addExpandedAccess(nestedAccess);
            }
        } else {
            this.access.add(a);
        }
    }

    protected void canonicalize() {
        ThreddsMetadata nested;
        InvMetadata m;
        Iterator<InvMetadata> iter = this.tm.metadata.iterator();
        while (iter.hasNext()) {
            m = iter.next();
            if (!m.isThreddsMetadata() || m.isInherited() || m.hasXlink()) continue;
            nested = m.getThreddsMetadata();
            this.tm.add(nested, false);
            iter.remove();
        }
        iter = this.tm.metadata.iterator();
        while (iter.hasNext()) {
            m = iter.next();
            if (!m.isThreddsMetadata() || !m.isInherited() || m.hasXlink()) continue;
            nested = m.getThreddsMetadata();
            this.tmi.add(nested, true);
            iter.remove();
        }
    }

    public InvDatasetImpl(String urlPath, FeatureType dataType, ServiceType stype) {
        super(null, "local file");
        this.tm.setDataType(dataType);
        this.tm.setServiceName("anon");
        this.urlPath = urlPath;
        this.addService(new InvService(this.tm.getServiceName(), stype.toString(), "", "", null));
        this.finish();
    }

    public InvDatasetImpl(InvDataset parent, String name) {
        super(parent, name);
    }

    public InvDatasetImpl(InvDatasetImpl from) {
        super(from.getParent(), from.getName());
        this.tm = new ThreddsMetadata(from.getLocalMetadata());
        this.tmi = new ThreddsMetadata(from.getLocalMetadataInheritable());
        this.accessLocal = new ArrayList<InvAccess>(from.getAccessLocal());
        this.servicesLocal = new ArrayList<InvService>(from.getServicesLocal());
        this.harvest = from.harvest;
        this.collectionType = from.collectionType;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.hashCode = 0;
    }

    public void setCatalog(InvCatalog catalog) {
        this.catalog = catalog;
        this.hashCode = 0;
    }

    public InvDataset getParentReal() {
        return this.parent;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
        this.hashCode = 0;
    }

    public void setAuthority(String authorityName) {
        this.tm.setAuthority(authorityName);
        this.hashCode = 0;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        this.hashCode = 0;
    }

    public void setHarvest(boolean harvest) {
        this.harvest = harvest;
        this.hashCode = 0;
    }

    public void setID(String id) {
        this.id = id;
        this.hashCode = 0;
    }

    public void setName(String name) {
        this.name = name;
        this.hashCode = 0;
    }

    public void setParent(InvDatasetImpl parent) {
        this.parent = parent;
        this.hashCode = 0;
    }

    public void setGeospatialCoverage(ThreddsMetadata.GeospatialCoverage gc) {
        this.tm.setGeospatialCoverage(gc);
        this.hashCode = 0;
    }

    public void setTimeCoverage(DateRange tc) {
        this.tm.setTimeCoverage(tc);
        this.hashCode = 0;
    }

    public void setDataFormatType(DataFormatType dataFormatType) {
        this.tm.setDataFormatType(dataFormatType);
        this.hashCode = 0;
    }

    public void setDataType(FeatureType dataType) {
        this.tm.setDataType(dataType);
        this.hashCode = 0;
    }

    public double getDataSize() {
        return this.tm.getDataSize();
    }

    public void setDataSize(double dataSize) {
        this.tm.setDataSize(dataSize);
        this.hashCode = 0;
    }

    public DateType getLastModifiedDate() {
        for (DateType dateType : this.tm.getDates()) {
            if (dateType.getType() == null || !dateType.getType().equals("modified")) continue;
            return dateType;
        }
        return null;
    }

    public void setLastModifiedDate(DateType lastModDate) {
        if (lastModDate == null) {
            throw new IllegalArgumentException("Last modified date can't be null.");
        }
        if (lastModDate.getType() == null || !lastModDate.getType().equals("modified")) {
            throw new IllegalArgumentException("Date type must be \"modified\" (was \"" + lastModDate.getType() + "\").");
        }
        DateType curLastModDateType = this.getLastModifiedDate();
        if (curLastModDateType != null) {
            this.tm.getDates().remove(curLastModDateType);
        }
        this.tm.addDate(lastModDate);
        this.hashCode = 0;
    }

    public void setLastModifiedDate(Date lastModDate) {
        if (lastModDate == null) {
            throw new IllegalArgumentException("Last modified date can't be null.");
        }
        DateType lastModDateType = new DateType(false, lastModDate);
        lastModDateType.setType("modified");
        this.setLastModifiedDate(lastModDateType);
    }

    public void setServiceName(String serviceName) {
        this.tm.setServiceName(serviceName);
        this.hashCode = 0;
    }

    public void setContributors(List<ThreddsMetadata.Contributor> a) {
        List<ThreddsMetadata.Contributor> dest = this.tm.getContributors();
        for (ThreddsMetadata.Contributor item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setKeywords(List<ThreddsMetadata.Vocab> a) {
        List<ThreddsMetadata.Vocab> dest = this.tm.getKeywords();
        for (ThreddsMetadata.Vocab item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setProjects(List<ThreddsMetadata.Vocab> a) {
        List<ThreddsMetadata.Vocab> dest = this.tm.getProjects();
        for (ThreddsMetadata.Vocab item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setPublishers(List<ThreddsMetadata.Source> a) {
        List<ThreddsMetadata.Source> dest = this.tm.getPublishers();
        for (ThreddsMetadata.Source item : a) {
            if (dest.contains(item)) continue;
            dest.add(item);
        }
        this.hashCode = 0;
    }

    public void setResourceControl(String restrictAccess) {
        this.restrictAccess = restrictAccess;
    }

    public void addAccess(InvAccess a) {
        this.accessLocal.add(a);
        this.hashCode = 0;
    }

    public void addAccess(List<InvAccess> a) {
        this.accessLocal.addAll(a);
        this.hashCode = 0;
    }

    public List<InvAccess> getAccessLocal() {
        return this.accessLocal;
    }

    public Element getNcmlElement() {
        return this.ncmlElement;
    }

    public void setNcmlElement(Element ncmlElement) {
        this.ncmlElement = ncmlElement;
    }

    public void addDataset(InvDatasetImpl ds) {
        if (ds == null) {
            return;
        }
        ds.setParent(this);
        this.datasets.add(ds);
        this.hashCode = 0;
    }

    public void addDataset(int index, InvDatasetImpl ds) {
        if (ds == null) {
            return;
        }
        ds.setParent(this);
        this.datasets.add(index, ds);
        this.hashCode = 0;
    }

    public boolean removeDataset(InvDatasetImpl ds) {
        if (this.datasets.remove(ds)) {
            ds.setParent(null);
            InvCatalogImpl cat = (InvCatalogImpl)this.getParentCatalog();
            if (cat != null) {
                cat.removeDatasetByID(ds);
            }
            return true;
        }
        return false;
    }

    public boolean replaceDataset(InvDatasetImpl remove, InvDatasetImpl add) {
        for (int i = 0; i < this.datasets.size(); ++i) {
            InvDataset dataset = (InvDataset)this.datasets.get(i);
            if (!dataset.equals(remove)) continue;
            this.datasets.set(i, add);
            InvCatalogImpl cat = (InvCatalogImpl)this.getParentCatalog();
            if (cat != null) {
                cat.removeDatasetByID(remove);
                cat.addDatasetByID(add);
            }
            return true;
        }
        return false;
    }

    public void addDocumentation(InvDocumentation doc) {
        this.tm.addDocumentation(doc);
        this.hashCode = 0;
    }

    public void addProperty(InvProperty p) {
        this.tm.addProperty(p);
        this.hashCode = 0;
    }

    public void addService(InvService service) {
        this.servicesLocal.add(service);
        this.services.add(service);
        for (InvService nested : service.getServices()) {
            this.services.add(nested);
        }
        this.hashCode = 0;
    }

    public void removeService(InvService service) {
        this.servicesLocal.remove(service);
        this.services.remove(service);
        for (InvService nested : service.getServices()) {
            this.services.remove(nested);
        }
    }

    public List<InvService> getServicesLocal() {
        return this.servicesLocal;
    }

    public void setServicesLocal(List<InvService> s) {
        this.services = new ArrayList();
        this.servicesLocal = new ArrayList<InvService>();
        for (InvService elem : s) {
            this.addService(elem);
        }
        this.hashCode = 0;
    }

    public ThreddsMetadata getLocalMetadata() {
        return this.tm;
    }

    public void setLocalMetadata(ThreddsMetadata tm) {
        this.tm = tm;
        this.hashCode = 0;
    }

    public ThreddsMetadata getLocalMetadataInheritable() {
        return this.tmi;
    }

    public boolean removeLocalMetadata(InvMetadata metadata) {
        InvDatasetImpl parentDataset = (InvDatasetImpl)metadata.getParentDataset();
        List<InvMetadata> localMdata = parentDataset.getLocalMetadata().getMetadata();
        if (localMdata.contains(metadata) && localMdata.remove(metadata)) {
            this.hashCode = 0;
            return true;
        }
        return false;
    }

    public String getServiceName() {
        if (this.defaultService != null) {
            return this.defaultService.getName();
        }
        return null;
    }

    protected boolean getMark() {
        return this.mark;
    }

    protected void setMark(boolean mark) {
        this.mark = mark;
    }

    public Object getUserProperty(Object key) {
        if (this.userMap == null) {
            return null;
        }
        return this.userMap.get(key);
    }

    public void setUserProperty(Object key, Object value) {
        if (this.userMap == null) {
            this.userMap = new HashMap();
        }
        this.userMap.put(key, value);
    }

    public String toString() {
        return this.getName();
    }

    public static void writeHtmlDescription(StringBuilder buff, InvDatasetImpl ds, boolean complete, boolean isServer, boolean datasetEvents, boolean catrefEvents) {
        InvDatasetImpl.writeHtmlDescription(buff, ds, complete, isServer, datasetEvents, catrefEvents, true);
    }

    public static void writeHtmlDescription(StringBuilder buff, InvDatasetImpl ds, boolean complete, boolean isServer, boolean datasetEvents, boolean catrefEvents, boolean resolveRelativeUrls) {
        List<InvProperty> props;
        DateRange tc;
        ThreddsMetadata.GeospatialCoverage gc;
        List<ThreddsMetadata.Variables> vars;
        List<ThreddsMetadata.Source> publishers;
        List<ThreddsMetadata.Source> creators;
        List<ThreddsMetadata.Vocab> projects;
        List<DateType> dates;
        List<ThreddsMetadata.Vocab> keywords;
        List<ThreddsMetadata.Contributor> contributors;
        List<InvAccess> access;
        if (ds == null) {
            return;
        }
        if (complete) {
            buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n");
            buff.append("<head>");
            buff.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            buff.append("</head>");
            buff.append("<body>\n");
        }
        buff.append("<h2>Dataset: ").append(ds.getFullName()).append("</h2>\n<ul>\n");
        if (ds.getDataFormatType() != null && ds.getDataFormatType() != DataFormatType.NONE) {
            buff.append(" <li><em>Data format: </em>").append(StringUtil.quoteHtmlContent(ds.getDataFormatType().toString())).append("</li>\n");
        }
        if (ds.getDataSize() != 0.0 && !Double.isNaN(ds.getDataSize())) {
            buff.append(" <li><em>Data size: </em>").append(Format.formatByteSize(ds.getDataSize())).append("</li>\n");
        }
        if (ds.getDataType() != null && ds.getDataType() != FeatureType.NONE) {
            buff.append(" <li><em>Data type: </em>").append(StringUtil.quoteHtmlContent(ds.getDataType().toString())).append("</li>\n");
        }
        if (ds.getCollectionType() != null && ds.getCollectionType() != CollectionType.NONE) {
            buff.append(" <li><em>Collection type: </em>").append(StringUtil.quoteHtmlContent(ds.getCollectionType().toString())).append("</li>\n");
        }
        if (ds.isHarvest()) {
            buff.append(" <li><em>Harvest: </em>").append(ds.isHarvest()).append("</li>\n");
        }
        if (ds.getAuthority() != null) {
            buff.append(" <li><em>Naming Authority: </em>").append(StringUtil.quoteHtmlContent(ds.getAuthority())).append("</li>\n");
        }
        if (ds.getID() != null) {
            buff.append(" <li><em>ID: </em>").append(StringUtil.quoteHtmlContent(ds.getID())).append("</li>\n");
        }
        if (ds.getRestrictAccess() != null) {
            buff.append(" <li><em>RestrictAccess: </em>").append(StringUtil.quoteHtmlContent(ds.getRestrictAccess())).append("</li>\n");
        }
        if (ds instanceof InvCatalogRef) {
            String href;
            InvCatalogRef catref = (InvCatalogRef)ds;
            String string = href = resolveRelativeUrls || catrefEvents ? InvDatasetImpl.resolve(ds, catref.getXlinkHref()) : catref.getXlinkHref();
            if (catrefEvents) {
                href = "catref:" + href;
            }
            buff.append(" <li><em>CatalogRef: </em>").append(InvDatasetImpl.makeHref(href, null)).append("</li>\n");
        }
        buff.append("</ul>\n");
        List<InvDocumentation> docs = ds.getDocumentation();
        if (docs.size() > 0) {
            buff.append("<h3>Documentation:</h3>\n<ul>\n");
            for (InvDocumentation doc : docs) {
                String type = doc.getType() == null ? "" : "<strong>" + StringUtil.quoteHtmlContent(doc.getType()) + ":</strong> ";
                String inline = doc.getInlineContent();
                if (inline != null && inline.length() > 0) {
                    buff.append(" <li>").append(type).append(StringUtil.quoteHtmlContent(inline)).append("</li>\n");
                }
                if (!doc.hasXlink()) continue;
                buff.append(" <li>").append(type).append(InvDatasetImpl.makeHref(doc.getXlinkHref(), doc.getXlinkTitle())).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((access = ds.getAccess()).size() > 0) {
            buff.append("<h3>Access:</h3>\n<ol>\n");
            for (InvAccess a : access) {
                String urlString;
                InvService s = a.getService();
                String fullUrlString = urlString = resolveRelativeUrls || datasetEvents ? a.getStandardUrlName() : a.getUnresolvedUrlName();
                if (datasetEvents) {
                    fullUrlString = "dataset:" + fullUrlString;
                }
                if (isServer) {
                    ServiceType stype = s.getServiceType();
                    if (stype == ServiceType.OPENDAP || stype == ServiceType.DODS) {
                        fullUrlString = fullUrlString + ".html";
                    } else if (stype == ServiceType.WCS) {
                        fullUrlString = fullUrlString + "?service=WCS&version=1.0.0&request=GetCapabilities";
                    } else if (stype == ServiceType.WMS) {
                        fullUrlString = fullUrlString + "?service=WMS&version=1.3.0&request=GetCapabilities";
                    } else if (stype == ServiceType.NetcdfStream) {
                        fullUrlString = fullUrlString + "?showForm";
                    } else if (stype == ServiceType.NetcdfSubset) {
                        fullUrlString = fullUrlString + "/dataset.html";
                    }
                }
                buff.append(" <li> <b>").append(StringUtil.quoteHtmlContent(s.getServiceType().toString()));
                buff.append(":</b> ").append(InvDatasetImpl.makeHref(fullUrlString, urlString)).append("</li>\n");
            }
            buff.append("</ol>\n");
        }
        if ((contributors = ds.getContributors()).size() > 0) {
            buff.append("<h3>Contributors:</h3>\n<ul>\n");
            for (ThreddsMetadata.Contributor t : contributors) {
                String role = t.getRole() == null ? "" : "<strong> (" + StringUtil.quoteHtmlContent(t.getRole()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil.quoteHtmlContent(t.getName())).append(role).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((keywords = ds.getKeywords()).size() > 0) {
            buff.append("<h3>Keywords:</h3>\n<ul>\n");
            for (ThreddsMetadata.Vocab t : keywords) {
                String vocab = t.getVocabulary() == null ? "" : " <strong>(" + StringUtil.quoteHtmlContent(t.getVocabulary()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil.quoteHtmlContent(t.getText())).append(vocab).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((dates = ds.getDates()).size() > 0) {
            buff.append("<h3>Dates:</h3>\n<ul>\n");
            for (DateType d : dates) {
                String type = d.getType() == null ? "" : " <strong>(" + StringUtil.quoteHtmlContent(d.getType()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil.quoteHtmlContent(d.getText())).append(type).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((projects = ds.getProjects()).size() > 0) {
            buff.append("<h3>Projects:</h3>\n<ul>\n");
            for (ThreddsMetadata.Vocab t : projects) {
                String vocab = t.getVocabulary() == null ? "" : " <strong>(" + StringUtil.quoteHtmlContent(t.getVocabulary()) + ")</strong> ";
                buff.append(" <li>").append(StringUtil.quoteHtmlContent(t.getText())).append(vocab).append("</li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((creators = ds.getCreators()).size() > 0) {
            buff.append("<h3>Creators:</h3>\n<ul>\n");
            for (ThreddsMetadata.Source t : creators) {
                buff.append(" <li><strong>").append(StringUtil.quoteHtmlContent(t.getName())).append("</strong><ul>\n");
                buff.append(" <li><em>email: </em>").append(StringUtil.quoteHtmlContent(t.getEmail())).append("</li>\n");
                if (t.getUrl() != null) {
                    String newUrl = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, t.getUrl(), null) : InvDatasetImpl.makeHref(t.getUrl(), null);
                    buff.append(" <li> <em>").append(newUrl).append("</em></li>\n");
                }
                buff.append(" </ul></li>\n");
            }
            buff.append("</ul>\n");
        }
        if ((publishers = ds.getPublishers()).size() > 0) {
            buff.append("<h3>Publishers:</h3>\n<ul>\n");
            for (ThreddsMetadata.Source t : publishers) {
                buff.append(" <li><strong>").append(StringUtil.quoteHtmlContent(t.getName())).append("</strong><ul>\n");
                buff.append(" <li><em>email: </em>").append(StringUtil.quoteHtmlContent(t.getEmail())).append("\n");
                if (t.getUrl() != null) {
                    String urlLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, t.getUrl(), null) : InvDatasetImpl.makeHref(t.getUrl(), null);
                    buff.append(" <li> <em>").append(urlLink).append("</em>\n");
                }
                buff.append(" </ul>\n");
            }
            buff.append("</ul>\n");
        }
        if ((vars = ds.getVariables()).size() > 0) {
            buff.append("<h3>Variables:</h3>\n<ul>\n");
            for (ThreddsMetadata.Variables t : vars) {
                buff.append("<li><em>Vocabulary</em> [");
                if (t.getVocabUri() != null) {
                    URI uri = t.getVocabUri();
                    String vocabLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, uri.toString(), t.getVocabulary()) : InvDatasetImpl.makeHref(uri.toString(), t.getVocabulary());
                    buff.append(vocabLink);
                } else {
                    buff.append(StringUtil.quoteHtmlContent(t.getVocabulary()));
                }
                buff.append("]:\n<ul>\n");
                List<ThreddsMetadata.Variable> vlist = t.getVariableList();
                if (vlist.size() > 0) {
                    for (ThreddsMetadata.Variable v : vlist) {
                        buff.append(" <li><strong>").append(StringUtil.quoteHtmlContent(v.getName())).append("</strong> = ");
                        String desc = v.getDescription() == null ? "" : " <i>" + StringUtil.quoteHtmlContent(v.getDescription()) + "</i> = ";
                        buff.append(desc);
                        String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                        buff.append(StringUtil.quoteHtmlContent(v.getVocabularyName() + units)).append("\n");
                    }
                    buff.append(" </ul>\n");
                }
                buff.append(" </ul>\n");
            }
            buff.append("</ul>\n");
        }
        if ((gc = ds.getGeospatialCoverage()) != null && !gc.isEmpty()) {
            buff.append("<h3>GeospatialCoverage:</h3>\n<ul>\n");
            if (gc.isGlobal()) {
                buff.append(" <li><em> Global </em></ul>\n");
            } else {
                List<ThreddsMetadata.Vocab> nlist;
                buff.append(" <li><em> Longitude: </em> ").append(InvDatasetImpl.rangeString(gc.getEastWestRange())).append("</li>\n");
                buff.append(" <li><em> Latitude: </em> ").append(InvDatasetImpl.rangeString(gc.getNorthSouthRange())).append("</li>\n");
                if (gc.getUpDownRange() != null) {
                    buff.append(" <li><em> Altitude: </em> ").append(InvDatasetImpl.rangeString(gc.getUpDownRange())).append(" (positive is <strong>").append(StringUtil.quoteHtmlContent(gc.getZPositive())).append(")</strong></li>\n");
                }
                if ((nlist = gc.getNames()) != null && nlist.size() > 0) {
                    buff.append(" <li><em>  Names: </em> <ul>\n");
                    for (ThreddsMetadata.Vocab elem : nlist) {
                        buff.append(" <li>").append(StringUtil.quoteHtmlContent(elem.getText())).append("\n");
                    }
                    buff.append(" </ul>\n");
                }
                buff.append(" </ul>\n");
            }
        }
        if ((tc = ds.getTimeCoverage()) != null) {
            TimeDuration duration;
            DateType end;
            buff.append("<h3>TimeCoverage:</h3>\n<ul>\n");
            DateType start = tc.getStart();
            if (start != null && !start.isBlank()) {
                buff.append(" <li><em>  Start: </em> ").append(start.toDateTimeString()).append("\n");
            }
            if ((end = tc.getEnd()) != null && !end.isBlank()) {
                buff.append(" <li><em>  End: </em> ").append(end.toDateTimeString()).append("\n");
            }
            if ((duration = tc.getDuration()) != null && !duration.isBlank()) {
                buff.append(" <li><em>  Duration: </em> ").append(StringUtil.quoteHtmlContent(duration.toString())).append("\n");
            }
            TimeDuration resolution = tc.getResolution();
            if (tc.useResolution() && resolution != null && !resolution.isBlank()) {
                buff.append(" <li><em>  Resolution: </em> ").append(StringUtil.quoteHtmlContent(resolution.toString())).append("\n");
            }
            buff.append(" </ul>\n");
        }
        List<InvMetadata> metadata = ds.getMetadata();
        boolean gotSomeMetadata = false;
        for (InvMetadata m : metadata) {
            if (!m.hasXlink()) continue;
            gotSomeMetadata = true;
        }
        if (gotSomeMetadata) {
            buff.append("<h3>Metadata:</h3>\n<ul>\n");
            for (InvMetadata m : metadata) {
                String type;
                String string = type = m.getMetadataType() == null ? "" : m.getMetadataType();
                if (!m.hasXlink()) continue;
                String title = m.getXlinkTitle() == null ? "Type " + type : m.getXlinkTitle();
                String mdLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, m.getXlinkHref(), title) : InvDatasetImpl.makeHref(m.getXlinkHref(), title);
                buff.append(" <li> ").append(mdLink).append("\n");
            }
            buff.append("</ul>\n");
        }
        if ((props = ds.getProperties()).size() > 0) {
            buff.append("<h3>Properties:</h3>\n<ul>\n");
            for (InvProperty p : props) {
                if (p.getName().equals("attachments")) {
                    String attachLink = resolveRelativeUrls ? InvDatasetImpl.makeHrefResolve(ds, p.getValue(), p.getName()) : InvDatasetImpl.makeHref(p.getValue(), p.getName());
                    buff.append(" <li>").append(attachLink).append("\n");
                    continue;
                }
                buff.append(" <li>").append(StringUtil.quoteHtmlContent(p.getName() + " = \"" + p.getValue())).append("\"\n");
            }
            buff.append("</ul>\n");
        }
        if (complete) {
            buff.append("</body></html>");
        }
    }

    private static String rangeString(ThreddsMetadata.Range r) {
        if (r == null) {
            return "";
        }
        String units = r.getUnits() == null ? "" : " " + r.getUnits();
        String resolution = r.hasResolution() ? " Resolution=" + r.getResolution() : "";
        return StringUtil.quoteHtmlContent(r.getStart() + " to " + (r.getStart() + r.getSize()) + resolution + units);
    }

    public static String resolve(InvDataset ds, String href) {
        InvCatalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                System.err.println("InvDatasetImpl.writeHtml: error parsing URL= " + href);
            }
        }
        return href;
    }

    private static String makeHref(String href, String title) {
        if (title == null) {
            title = href;
        }
        return "<a href='" + StringUtil.quoteHtmlContent(href) + "'>" + StringUtil.quoteHtmlContent(title) + "</a>";
    }

    private static String makeHrefResolve(InvDatasetImpl ds, String href, String title) {
        if (title == null) {
            title = href;
        }
        href = InvDatasetImpl.resolve(ds, href);
        return InvDatasetImpl.makeHref(href, title);
    }

    public String dump() {
        return this.dump(0);
    }

    String dump(int n) {
        String indent;
        StringBuilder buff = new StringBuilder(100);
        buff.append(InvDatasetImpl.indent(n));
        buff.append("Dataset name:<").append(this.getName());
        if (this.dataType != null) {
            buff.append("> dataType:<").append((Object)this.dataType);
        }
        if (this.urlPath != null) {
            buff.append("> urlPath:<").append(this.urlPath);
        }
        if (this.defaultService != null) {
            buff.append("> defaultService <").append(this.defaultService);
        }
        buff.append("> uID:<").append(this.getUniqueID());
        buff.append(">\n");
        List<InvService> svcs = this.getServicesLocal();
        if (svcs.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Services:\n");
            for (InvService s : svcs) {
                buff.append(s.dump(n + 4));
            }
        }
        if (this.access.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            if (this.access.size() == 1) {
                buff.append("Access: ").append(this.access.get(0)).append("\n");
            } else if (this.access.size() > 1) {
                buff.append("Access:\n");
                for (InvAccess a : this.access) {
                    buff.append(InvDatasetImpl.indent(n + 4)).append(a).append("\n");
                }
            }
        }
        buff.append(InvDatasetImpl.indent(n)).append("Thredds Metadata\n");
        buff.append(this.tm.dump(n + 4)).append("\n");
        buff.append(InvDatasetImpl.indent(n)).append("Thredds Metadata Inherited\n");
        buff.append(this.tmi.dump(n + 4)).append("\n");
        buff.append(InvDatasetImpl.indent(n)).append("Thredds Metadata Cat6\n");
        buff.append(this.tmi6.dump(n + 4)).append("\n");
        if (this.datasets.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Datasets:\n");
            for (InvDataset ds : this.datasets) {
                InvDatasetImpl dsi = (InvDatasetImpl)ds;
                buff.append(dsi.dump(n + 4));
            }
        }
        return buff.toString();
    }

    static String indent(int n) {
        StringBuilder blanks = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            blanks.append(" ");
        }
        return blanks.toString();
    }

    boolean check(StringBuilder out, boolean show) {
        boolean isValid = true;
        if (this.log.length() > 0) {
            out.append((CharSequence)this.log);
        }
        for (InvAccess acces : this.access) {
            InvAccessImpl a = (InvAccessImpl)acces;
            isValid &= a.check(out, show);
        }
        for (InvDataset dataset : this.datasets) {
            InvDatasetImpl ds = (InvDatasetImpl)dataset;
            isValid &= ds.check(out, show);
        }
        for (InvMetadata m : this.getMetadata()) {
            m.check(out);
        }
        for (InvService s : this.getServicesLocal()) {
            isValid &= s.check(out);
        }
        if (this.hasAccess() && this.getDataType() == null) {
            out.append("**Warning: Dataset (").append(this.getFullName()).append("): is selectable but no data type declared in it or in a parent element\n");
        }
        if (!this.hasAccess() && !this.hasNestedDatasets()) {
            out.append("**Warning: Dataset (").append(this.getFullName()).append("): is not selectable and does not have nested datasets\n");
        }
        if (show) {
            System.out.println("  dataset " + this.name + " valid = " + isValid);
        }
        return isValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvDatasetImpl)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + ((Object)this.getServicesLocal()).hashCode();
            result = 37 * result + ((Object)this.getDatasets()).hashCode();
            result = 37 * result + ((Object)this.getAccessLocal()).hashCode();
            result = 37 * result + (this.isHarvest() ? 1 : 0);
            if (null != this.getCollectionType()) {
                result = 37 * result + this.getCollectionType().hashCode();
            }
            result = 37 * result + ((Object)this.getDocumentation()).hashCode();
            result = 37 * result + ((Object)this.getProperties()).hashCode();
            result = 37 * result + ((Object)this.getMetadata()).hashCode();
            result = 37 * result + ((Object)this.getCreators()).hashCode();
            result = 37 * result + ((Object)this.getContributors()).hashCode();
            result = 37 * result + ((Object)this.getDates()).hashCode();
            result = 37 * result + ((Object)this.getKeywords()).hashCode();
            result = 37 * result + ((Object)this.getProjects()).hashCode();
            result = 37 * result + ((Object)this.getPublishers()).hashCode();
            result = 37 * result + ((Object)this.getVariables()).hashCode();
            if (null != this.getID()) {
                result = 37 * result + this.getID().hashCode();
            }
            if (null != this.getAlias()) {
                result = 37 * result + this.getAlias().hashCode();
            }
            if (null != this.getAuthority()) {
                result = 37 * result + this.getAuthority().hashCode();
            }
            if (null != this.getDataType()) {
                result = 37 * result + this.getDataType().hashCode();
            }
            if (null != this.getDataFormatType()) {
                result = 37 * result + this.getDataFormatType().hashCode();
            }
            if (null != this.getServiceDefault()) {
                result = 37 * result + this.getServiceDefault().hashCode();
            }
            if (null != this.getUrlPath()) {
                result = 37 * result + this.getUrlPath().hashCode();
            }
            if (null != this.getGeospatialCoverage()) {
                result = 37 * result + this.getGeospatialCoverage().hashCode();
            }
            if (null != this.getTimeCoverage()) {
                result = 37 * result + this.getTimeCoverage().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public static void main(String[] args) {
        InvDatasetImpl topDs = new InvDatasetImpl(null, "topDs", FeatureType.valueOf("GRID"), "myService", "myUrlPath/");
        InvService myS = new InvService("myService", ServiceType.DODS.toString(), "http://motherlode.ucar.edu/cgi-bin/dods/nph-dods", "", null);
        topDs.addService(myS);
        topDs.getLocalMetadata().setServiceName("myService");
        InvDatasetImpl childDs = new InvDatasetImpl(null, "childDs", null, null, "myUrlPath/");
        topDs.addDataset(childDs);
        InvService ts = childDs.findService("myService");
        System.out.println("InvDatasetImpl.main(): " + childDs.getAccess(ServiceType.DODS).toString());
    }
}

