/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.io.Serializable;
import thredds.filesystem.MFile;
import thredds.filesystem.Manager;

public class MDirectory
extends MFile
implements Serializable {
    private String parent;
    private MFile[] children;

    public MDirectory(Manager m, File dir) {
        super(dir);
        this.parent = dir.getParent();
        File[] subs = dir.listFiles();
        if (subs == null) {
            subs = new File[]{};
        }
        this.children = new MFile[subs.length];
        int count = 0;
        for (File f : subs) {
            this.children[count++] = new MFile(f);
        }
        for (File f : subs) {
            if (!f.isDirectory()) continue;
            MDirectory mdir = new MDirectory(m, f);
            m.add(mdir.getPath(), mdir);
        }
    }

    public MDirectory(File dir) {
        super(dir);
        this.parent = dir.getParent();
        File[] subs = dir.listFiles();
        if (subs == null) {
            subs = new File[]{};
        }
        this.children = new MFile[subs.length];
        int count = 0;
        for (File f : subs) {
            this.children[count++] = new MFile(f);
        }
    }

    public boolean notModified() {
        File f = new File(this.name);
        return f.lastModified() <= this.lastModified;
    }

    public String getPath() {
        return this.parent + "/" + this.name;
    }

    public MFile[] getChildren() {
        return this.children;
    }
}

