/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.iosp.netcdf3.SPFactory;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfFileWriteable
extends NetcdfFile {
    private IOServiceProviderWriter spiw;
    private boolean defineMode;
    private boolean isLargeFile;
    private boolean fill;
    private int extraHeader;
    private long preallocateSize;

    public static NetcdfFileWriteable openExisting(String location) throws IOException {
        return new NetcdfFileWriteable(location, true, true);
    }

    public static NetcdfFileWriteable openExisting(String location, boolean fill) throws IOException {
        return new NetcdfFileWriteable(location, fill, true);
    }

    public static NetcdfFileWriteable createNew(String location) throws IOException {
        return new NetcdfFileWriteable(location, true, false);
    }

    public static NetcdfFileWriteable createNew(String location, boolean fill) throws IOException {
        return new NetcdfFileWriteable(location, fill, false);
    }

    private NetcdfFileWriteable(String location, boolean fill, boolean isExisting) throws IOException {
        this.location = location;
        this.fill = fill;
        if (isExisting) {
            RandomAccessFile raf = new RandomAccessFile(location, "rw");
            this.spi = SPFactory.getServiceProvider();
            this.spiw = (IOServiceProviderWriter)this.spi;
            this.spiw.open(raf, this, null);
            this.spiw.setFill(fill);
        } else {
            this.defineMode = true;
        }
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        if (this.spiw != null) {
            this.spiw.setFill(fill);
        }
    }

    public void setLength(long size) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.preallocateSize = size;
    }

    public void setLargeFile(boolean isLargeFile) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.isLargeFile = isLargeFile;
    }

    public void setExtraHeaderBytes(int extraHeaderBytes) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.extraHeader = extraHeaderBytes;
    }

    public boolean isDefineMode() {
        return this.defineMode;
    }

    public Dimension addDimension(String dimName, int length) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("length must be > 0");
        }
        if (!N3iosp.isValidNetcdf3ObjectName(dimName)) {
            throw new IllegalArgumentException("illegal netCDF-3 object name");
        }
        Dimension dim = new Dimension(dimName, length, true, false, false);
        super.addDimension(null, dim);
        return dim;
    }

    public Dimension addDimension(String dimName, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!N3iosp.isValidNetcdf3ObjectName(dimName)) {
            throw new IllegalArgumentException("illegal netCDF-3 object name");
        }
        Dimension dim = new Dimension(dimName, length, isShared, isUnlimited, isVariableLength);
        super.addDimension(null, dim);
        return dim;
    }

    public Dimension addUnlimitedDimension(String dimName) {
        return this.addDimension(dimName, 0, true, true, false);
    }

    public Dimension renameDimension(String oldName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Dimension dim = this.findDimension(oldName);
        if (null != dim) {
            dim.setName(newName);
        }
        return dim;
    }

    public Attribute addGlobalAttribute(Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        return super.addAttribute(null, att);
    }

    public Attribute addGlobalAttribute(String name, String value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        return super.addAttribute(null, new Attribute(name, value));
    }

    public Attribute addGlobalAttribute(String name, Number value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        return super.addAttribute(null, new Attribute(name, value));
    }

    public Attribute addGlobalAttribute(String name, Array values) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        return super.addAttribute(null, new Attribute(name, values));
    }

    public Attribute deleteGlobalAttribute(String attName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute att = this.findGlobalAttribute(attName);
        if (null == att) {
            return null;
        }
        this.rootGroup.remove(att);
        return att;
    }

    public Attribute renameGlobalAttribute(String oldName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute att = this.findGlobalAttribute(oldName);
        if (null == att) {
            return null;
        }
        this.rootGroup.remove(att);
        att = new Attribute(newName, att.getValues());
        this.rootGroup.addAttribute(att);
        return att;
    }

    public Variable addVariable(String varName, DataType dataType, Dimension[] dims) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        list.addAll(Arrays.asList(dims));
        return this.addVariable(varName, dataType, list);
    }

    public Variable addVariable(String varName, DataType dataType, String dims) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        StringTokenizer stoker = new StringTokenizer(dims);
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            Dimension d = this.rootGroup.findDimension(tok);
            if (null == d) {
                throw new IllegalArgumentException("Canat find dimension " + tok);
            }
            list.add(d);
        }
        return this.addVariable(varName, dataType, list);
    }

    public Variable addVariable(String varName, DataType dataType, List<Dimension> dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!N3iosp.isValidNetcdf3ObjectName(varName)) {
            throw new IllegalArgumentException("illegal netCDF-3 object name");
        }
        Variable v = new Variable(this, this.rootGroup, null, varName);
        v.setDataType(dataType);
        v.setDimensions(dims);
        long size = v.getSize() * (long)v.getElementSize();
        if (size > 0xFFFFFFFCL) {
            throw new IllegalArgumentException("Variable size in bytes " + size + " may not exceed " + 0xFFFFFFFCL);
        }
        super.addVariable(null, v);
        return v;
    }

    public Variable addStringVariable(String varName, List<Dimension> dims, int max_strlen) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!N3iosp.isValidNetcdf3ObjectName(varName)) {
            throw new IllegalArgumentException("illegal netCDF-3 object name");
        }
        Variable v = new Variable(this, this.rootGroup, null, varName);
        v.setDataType(DataType.CHAR);
        Dimension d = this.addDimension(varName + "_strlen", max_strlen);
        ArrayList<Dimension> sdims = new ArrayList<Dimension>(dims);
        sdims.add(d);
        v.setDimensions(sdims);
        super.addVariable(null, v);
        return v;
    }

    public Variable renameVariable(String oldName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = this.findVariable(oldName);
        if (null != v) {
            v.setName(newName);
        }
        return v;
    }

    public void addVariableAttribute(String varName, Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!N3iosp.isValidNetcdf3ObjectName(att.getName())) {
            throw new IllegalArgumentException("illegal netCDF-3 object name");
        }
        Variable v = this.rootGroup.findVariable(varName);
        if (null == v) {
            throw new IllegalArgumentException("addVariableAttribute variable name not found = <" + varName + ">");
        }
        v.addAttribute(att);
    }

    public void addVariableAttribute(String varName, String attName, String value) {
        this.addVariableAttribute(varName, new Attribute(attName, value));
    }

    public void addVariableAttribute(String varName, String attName, Number value) {
        this.addVariableAttribute(varName, new Attribute(attName, value));
    }

    public void addVariableAttribute(String varName, String attName, Array value) {
        Attribute att = new Attribute(attName, value);
        this.addVariableAttribute(varName, att);
    }

    public Attribute deleteVariableAttribute(String varName, String attName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = this.findVariable(varName);
        if (v == null) {
            return null;
        }
        Attribute att = v.findAttribute(attName);
        if (null == att) {
            return null;
        }
        v.remove(att);
        return att;
    }

    public Attribute renameVariableAttribute(String varName, String attName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = this.findVariable(varName);
        if (v == null) {
            return null;
        }
        Attribute att = v.findAttribute(attName);
        if (null == att) {
            return null;
        }
        v.remove(att);
        att = new Attribute(newName, att.getValues());
        v.addAttribute(att);
        return att;
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        this.spiw.updateAttribute(v2, att);
    }

    public void create() throws IOException {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.spi = SPFactory.getServiceProvider();
        this.spiw = (IOServiceProviderWriter)this.spi;
        this.spiw.setFill(this.fill);
        this.spiw.create(this.location, this, this.extraHeader, this.preallocateSize, this.isLargeFile);
        this.defineMode = false;
    }

    public boolean setRedefineMode(boolean redefineMode) throws IOException {
        if (redefineMode && !this.defineMode) {
            this.defineMode = true;
        } else if (!redefineMode && this.defineMode) {
            this.defineMode = false;
            this.finish();
            boolean ok = this.spiw.rewriteHeader(this.isLargeFile);
            if (!ok) {
                this.rewrite();
            }
            return !ok;
        }
        return false;
    }

    private void rewrite() throws IOException {
        this.spiw.flush();
        this.spiw.close();
        File prevFile = new File(this.location);
        File tmpFile = new File(this.location + ".tmp");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        if (!prevFile.renameTo(tmpFile)) {
            System.out.println("prevFile.exists " + prevFile.exists() + " canRead = " + prevFile.canRead());
            System.out.println("tmpFile.exists " + tmpFile.exists() + " canWrite " + tmpFile.canWrite());
            throw new RuntimeException("Cant rename " + prevFile.getAbsolutePath() + " to " + tmpFile.getAbsolutePath());
        }
        NetcdfFile oldFile = NetcdfFile.open(tmpFile.getPath());
        Structure recordVar = null;
        if (oldFile.hasUnlimitedDimension()) {
            oldFile.sendIospMessage("AddRecordStructure");
            recordVar = (Structure)oldFile.findVariable("record");
        }
        this.spiw.create(this.location, this, this.extraHeader, this.preallocateSize, this.isLargeFile);
        this.spiw.setFill(this.fill);
        ArrayList<Variable> oldList = new ArrayList<Variable>(this.getVariables().size());
        for (Variable v : this.getVariables()) {
            Variable oldVar = oldFile.findVariable(v.getName());
            if (oldVar == null) continue;
            oldList.add(oldVar);
        }
        FileWriter.copyVarData(this, oldList, recordVar, 0L);
        this.flush();
        oldFile.close();
        if (!tmpFile.delete()) {
            throw new RuntimeException("Cant delete " + this.location);
        }
    }

    public void write(String varName, Array values) throws IOException, InvalidRangeException {
        this.write(varName, new int[values.getRank()], values);
    }

    public void write(String varName, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        Variable v2 = this.findVariable(varName);
        if (v2 == null) {
            throw new IllegalArgumentException("NetcdfFileWriteable.write illegal variable name = " + varName);
        }
        this.spiw.writeData(v2, new Section(origin, values.getShape()), values);
        v2.invalidateCache();
    }

    public void writeStringData(String varName, Array values) throws IOException, InvalidRangeException {
        this.writeStringData(varName, new int[values.getRank()], values);
    }

    public void writeStringData(String varName, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (values.getElementType() != String.class) {
            throw new IllegalArgumentException("Must be ArrayObject of String ");
        }
        Variable v2 = this.findVariable(varName);
        if (v2 == null) {
            throw new IllegalArgumentException("illegal variable name = " + varName);
        }
        if (v2.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("variable " + varName + " is not type CHAR");
        }
        int rank = v2.getRank();
        int strlen = v2.getShape(rank - 1);
        ArrayChar cvalues = ArrayChar.makeFromStringArray((ArrayObject)values, strlen);
        int[] corigin = new int[rank];
        System.arraycopy(origin, 0, corigin, 0, rank - 1);
        this.write(varName, corigin, cvalues);
    }

    public void flush() throws IOException {
        this.spiw.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.spiw != null) {
            this.flush();
            this.spiw.close();
            this.spiw = null;
        }
        this.spi = null;
    }

    public NetcdfFileWriteable(String location, boolean fill) {
        this.location = location;
        this.fill = fill;
        this.defineMode = true;
    }

    public NetcdfFileWriteable() {
        this.defineMode = true;
    }

    public NetcdfFileWriteable(String location) throws IOException {
        this.location = location;
        RandomAccessFile raf = new RandomAccessFile(location, "rw");
        this.spi = SPFactory.getServiceProvider();
        this.spiw = (IOServiceProviderWriter)this.spi;
        this.spiw.open(raf, this, null);
    }

    public void setName(String filename) {
        this.location = filename;
    }

    public Variable addVariable(String varName, Class componentType, Dimension[] dims) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        list.addAll(Arrays.asList(dims));
        return this.addVariable(varName, DataType.getType(componentType), list);
    }
}

