/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class StandardProfileCollectionImpl
extends OneNestedPointCollectionImpl
implements ProfileFeatureCollection {
    private DateUnit timeUnit;
    private NestedTable ft;
    private ProfileIterator localIterator = null;

    protected StandardProfileCollectionImpl(String name) {
        super(name, FeatureType.PROFILE);
    }

    StandardProfileCollectionImpl(NestedTable ft, DateUnit timeUnit) {
        super(ft.getName(), FeatureType.PROFILE);
        this.ft = ft;
        this.timeUnit = timeUnit;
    }

    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new ProfileIterator(this.ft.getFeatureDataIterator(bufferSize));
    }

    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    public ProfileFeature next() throws IOException {
        return this.localIterator.next();
    }

    public void resetIteration() throws IOException {
        this.localIterator = (ProfileIterator)this.getPointFeatureCollectionIterator(-1);
    }

    public ProfileFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return new StandardProfileCollectionSubset(this, boundingBox);
    }

    private class StandardProfileCollectionSubset
    extends StandardProfileCollectionImpl {
        StandardProfileCollectionImpl from;
        LatLonRect boundingBox;

        StandardProfileCollectionSubset(StandardProfileCollectionImpl from, LatLonRect boundingBox) {
            super(from.getName() + "-subset");
            this.from = from;
            this.boundingBox = boundingBox;
        }

        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(bufferSize), new Filter());
        }

        private class Filter
        implements PointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StandardProfileCollectionSubset.this.boundingBox.contains(profileFeature.getLatLon());
            }
        }
    }

    private class StandardProfileFeature
    extends ProfileFeatureImpl {
        Cursor cursor;

        StandardProfileFeature(Cursor cursor) {
            super(StandardProfileCollectionImpl.this.ft.getFeatureName(cursor.tableData[1]), StandardProfileCollectionImpl.this.ft.getLatitude(cursor), StandardProfileCollectionImpl.this.ft.getLongitude(cursor), -1);
            this.cursor = cursor;
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator siter = StandardProfileCollectionImpl.this.ft.getFeatureObsDataIterator(cursorIter, bufferSize);
            return new StandardPointFeatureIterator(StandardProfileCollectionImpl.this.ft, StandardProfileCollectionImpl.this.timeUnit, siter, cursorIter, false);
        }
    }

    private class ProfileIterator
    implements PointFeatureCollectionIterator {
        StructureDataIterator structIter;
        int count = 0;

        ProfileIterator(StructureDataIterator structIter) throws IOException {
            this.structIter = structIter;
        }

        public boolean hasNext() throws IOException {
            return this.structIter.hasNext();
        }

        public ProfileFeature next() throws IOException {
            Cursor cursor = new Cursor(StandardProfileCollectionImpl.this.ft.getNumberOfLevels());
            cursor.tableData[1] = this.structIter.next();
            ++this.count;
            cursor.parentIndex = 1;
            return new StandardProfileFeature(cursor);
        }

        public void setBufferSize(int bytes) {
        }
    }
}

