/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleAdapter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.StructureDataIteratorIndexed;
import ucar.nc2.ft.point.StructureDataIteratorLinked;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;
import ucar.nc2.ft.point.standard.TableConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Table {
    String name;
    FeatureType featureType;
    Table parent;
    Join extraJoin;
    String lat;
    String lon;
    String elev;
    String time;
    String timeNominal;
    String stnId;
    String stnDesc;
    String stnNpts;
    String stnWmoId;
    String stnAlt;
    String limit;
    List<VariableSimpleIF> cols = new ArrayList<VariableSimpleIF>();
    List<String> coordVars = new ArrayList<String>();

    public static Table factory(NetcdfDataset ds, TableConfig config) {
        switch (config.type) {
            case ArrayStructure: {
                return new TableArrayStructure(ds, config);
            }
            case Construct: {
                return new TableConstruct(ds, config);
            }
            case Contiguous: {
                return new TableContiguous(ds, config);
            }
            case LinkedList: {
                return new TableLinkedList(ds, config);
            }
            case MultiDimInner: {
                return new TableMultiDimInner(ds, config);
            }
            case MultiDimOuter: {
                return new TableMultiDimOuter(ds, config);
            }
            case MultiDimStructure: {
                return new TableMultiDimStructure(ds, config);
            }
            case NestedStructure: {
                return new TableNestedStructure(ds, config);
            }
            case ParentIndex: {
                return new TableParentIndex(ds, config);
            }
            case Singleton: {
                return new TableSingleton(ds, config);
            }
            case Structure: {
                return new TableStructure(ds, config);
            }
            case Top: {
                return new TableTop(ds, config);
            }
        }
        throw new IllegalStateException("Unimplemented Table type = " + (Object)((Object)config.type));
    }

    protected Table(NetcdfDataset ds, TableConfig config) {
        this.name = config.name;
        this.featureType = config.featureType;
        this.lat = config.lat;
        this.lon = config.lon;
        this.elev = config.elev;
        this.time = config.time;
        this.timeNominal = config.timeNominal;
        this.stnId = config.stnId;
        this.stnDesc = config.stnDesc;
        this.stnNpts = config.stnNpts;
        this.stnWmoId = config.stnWmoId;
        this.stnAlt = config.stnAlt;
        this.limit = config.limit;
        if (config.parent != null) {
            this.parent = Table.factory(ds, config.parent);
        }
        this.extraJoin = config.extraJoin;
    }

    public abstract StructureDataIterator getStructureDataIterator(Cursor var1, int var2) throws IOException;

    String findCoordinateVariableName(CoordName coordName) {
        switch (coordName) {
            case Elev: {
                return this.elev;
            }
            case Lat: {
                return this.lat;
            }
            case Lon: {
                return this.lon;
            }
            case Time: {
                return this.time;
            }
            case TimeNominal: {
                return this.timeNominal;
            }
            case StnId: {
                return this.stnId;
            }
            case StnDesc: {
                return this.stnDesc;
            }
            case WmoId: {
                return this.stnWmoId;
            }
            case StnAlt: {
                return this.stnAlt;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public List<? super VariableSimpleIF> getDataVariables() {
        return this.cols;
    }

    public Variable findVariable(String axisName) {
        return null;
    }

    public String showDimension() {
        return "";
    }

    public String toString() {
        Formatter formatter = new Formatter();
        formatter.format(" Table %s on dimension %s type=%s\n", this.getName(), this.showDimension(), this.getClass().toString());
        formatter.format("  Coordinates=", new Object[0]);
        formatter.format("\n  Data Variables= %d\n", this.cols.size());
        formatter.format("  Parent= %s\n", this.parent == null ? "none" : this.parent.getName());
        return formatter.toString();
    }

    public String showAll() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Table on dimension ").append(this.showDimension()).append("\n");
        for (VariableSimpleIF v : this.cols) {
            sbuff.append("  ").append(v.getName()).append("\n");
        }
        return sbuff.toString();
    }

    public int show(Formatter f, int indent) {
        if (this.parent != null) {
            indent = this.parent.show(f, indent);
        }
        String s = this.indent(indent);
        String ftDesc = this.featureType == null ? "" : "featureType=" + this.featureType.toString();
        f.format("%n%sTable %s: type=%s %s%n", s, this.getName(), this.getClass().toString(), ftDesc);
        this.showExtra(f);
        this.showCoords(f, s);
        for (VariableSimpleIF v : this.cols) {
            f.format("%s  %s %s\n", s, v.getName(), this.getKind(v.getShortName()));
        }
        return indent + 2;
    }

    String indent(int n) {
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sbuff.append(' ');
        }
        return sbuff.toString();
    }

    protected abstract void showExtra(Formatter var1);

    private String getKind(String v) {
        if (v.equals(this.lat)) {
            return "[Lat]";
        }
        if (v.equals(this.lon)) {
            return "[Lon]";
        }
        if (v.equals(this.elev)) {
            return "[Elev]";
        }
        if (v.equals(this.time)) {
            return "[Time]";
        }
        if (v.equals(this.timeNominal)) {
            return "[timeNominal]";
        }
        if (v.equals(this.stnId)) {
            return "[stnId]";
        }
        if (v.equals(this.stnDesc)) {
            return "[stnDesc]";
        }
        if (v.equals(this.stnNpts)) {
            return "[stnNpts]";
        }
        if (v.equals(this.stnWmoId)) {
            return "[stnWmoId]";
        }
        if (v.equals(this.stnAlt)) {
            return "[stnAlt]";
        }
        if (v.equals(this.limit)) {
            return "[limit]";
        }
        return "";
    }

    private void showCoords(Formatter out, String indent) {
        boolean gotSome = this.showCoord(out, this.lat, indent);
        gotSome |= this.showCoord(out, this.lon, indent);
        gotSome |= this.showCoord(out, this.elev, indent);
        gotSome |= this.showCoord(out, this.time, indent);
        gotSome |= this.showCoord(out, this.timeNominal, indent);
        gotSome |= this.showCoord(out, this.stnId, indent);
        gotSome |= this.showCoord(out, this.stnDesc, indent);
        gotSome |= this.showCoord(out, this.stnNpts, indent);
        gotSome |= this.showCoord(out, this.stnWmoId, indent);
        gotSome |= this.showCoord(out, this.stnAlt, indent);
        if (gotSome |= this.showCoord(out, this.limit, indent)) {
            out.format("\n", new Object[0]);
        }
    }

    private boolean showCoord(Formatter out, String name, String indent) {
        if (name != null) {
            out.format(" %s Coord %s %s\n", indent, name, this.getKind(name));
            return true;
        }
        return false;
    }

    private static class SingletonStructureDataIterator
    implements StructureDataIterator {
        private int count = 0;
        private StructureData sdata;

        SingletonStructureDataIterator(StructureData sdata) {
            this.sdata = sdata;
        }

        public boolean hasNext() throws IOException {
            return this.count == 0;
        }

        public StructureData next() throws IOException {
            ++this.count;
            return this.sdata;
        }

        public void setBufferSize(int bytes) {
        }

        public StructureDataIterator reset() {
            this.count = 0;
            return this;
        }
    }

    public static class TableTop
    extends Table {
        NetcdfDataset ds;

        TableTop(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.ds = ds;
        }

        protected void showExtra(Formatter f) {
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            return new SingletonStructureDataIterator(null);
        }
    }

    public static class TableSingleton
    extends Table {
        StructureData sdata;

        TableSingleton(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.sdata = config.sdata;
            assert (this.sdata != null);
        }

        protected void showExtra(Formatter f) {
            f.format("    StructureData=%s%n", this.sdata.getName());
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            return new SingletonStructureDataIterator(this.sdata);
        }
    }

    public static class TableNestedStructure
    extends Table {
        String nestedTableName;
        Structure struct;

        TableNestedStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.nestedTableName = config.nestedTableName;
            this.struct = (Structure)ds.findVariable(config.structName);
        }

        protected void showExtra(Formatter f) {
            f.format("    struct=%s, nestedTableName=%s%n", this.struct.getNameAndDimensions(), this.nestedTableName);
        }

        public Variable findVariable(String axisName) {
            return this.struct.findVariable(axisName);
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            StructureMembers members = parentStruct.getStructureMembers();
            StructureMembers.Member m = members.findMember(this.nestedTableName);
            if (m.getDataType() == DataType.SEQUENCE) {
                ArraySequence seq = parentStruct.getArraySequence(m);
                return seq.getStructureDataIterator();
            }
            if (m.getDataType() == DataType.STRUCTURE) {
                ArrayStructure as = parentStruct.getArrayStructure(m);
                return as.getStructureDataIterator();
            }
            throw new IllegalStateException("Cant fing memmber " + this.nestedTableName);
        }
    }

    public static class TableMultiDimStructure
    extends TableStructure {
        TableMultiDimStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            int recnum = cursor.getParentRecnum();
            try {
                Section section = new Section().appendRange(recnum, recnum).appendRange(null);
                ArrayStructure data = (ArrayStructure)this.struct.read(section);
                return data.getStructureDataIterator();
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class TableMultiDimInner
    extends Table {
        StructureMembers sm;
        Dimension dim;
        NetcdfDataset ds;

        TableMultiDimInner(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.ds = ds;
            this.dim = config.dim;
            assert (this.dim != null);
            this.sm = new StructureMembers(config.name);
            for (Variable v : ds.getVariables()) {
                if (v.getRank() < 2 || !v.getDimension(0).equals(config.outer) || !v.getDimension(1).equals(config.dim)) continue;
                this.cols.add(v);
                int rank = v.getRank();
                int[] shape = new int[rank - 2];
                System.arraycopy(v.getShape(), 2, shape, 0, rank - 2);
                this.sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
            }
        }

        protected void showExtra(Formatter f) {
            f.format("    StructureMembers=%s, dim=%s%n", this.sm.getName(), this.dim.getName());
        }

        public String showDimension() {
            return this.dim.getName();
        }

        public Variable findVariable(String axisName) {
            return this.ds.findVariable(axisName);
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            ArrayStructureMA asma = new ArrayStructureMA(this.sm, new int[]{this.dim.getLength()});
            for (VariableSimpleIF v : this.cols) {
                Array data = parentStruct.getArray(v.getShortName());
                StructureMembers.Member childm = this.sm.findMember(v.getShortName());
                childm.setDataArray(data);
            }
            return asma.getStructureDataIterator();
        }
    }

    public static class TableMultiDimOuter
    extends TableStructure {
        TableMultiDimOuter(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
        }
    }

    public static class TableLinkedList
    extends TableStructure {
        private String start;
        private String next;

        TableLinkedList(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.start = config.start;
            this.next = config.next;
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            int firstRecno = parentStruct.getScalarInt(this.start);
            return new StructureDataIteratorLinked(this.struct, firstRecno, -1, this.next);
        }
    }

    public static class TableParentIndex
    extends TableStructure {
        private Map<Integer, List<Integer>> indexMap;
        private String parentIndexName;

        TableParentIndex(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.indexMap = config.indexMap;
            this.parentIndexName = config.parentIndex;
        }

        protected void showExtra(Formatter f) {
            f.format("    parentIndexName=%s, indexMap.size=%d%n", this.parentIndexName, this.indexMap.size());
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            int parentIndex = parentStruct.getScalarInt(this.parentIndexName);
            List<Integer> index = this.indexMap.get(parentIndex);
            return new StructureDataIteratorIndexed(this.struct, index);
        }
    }

    public static class TableContiguous
    extends TableStructure {
        private String start;
        private String numRecords;

        TableContiguous(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.start = config.start;
            this.numRecords = config.numRecords;
        }

        protected void showExtra(Formatter f) {
            f.format("    start=%s, numRecords=%s%n", this.start, this.numRecords);
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            int firstRecno = parentStruct.getScalarInt(this.start);
            int n = parentStruct.getScalarInt(this.numRecords);
            return new StructureDataIteratorLinked(this.struct, firstRecno, n, null);
        }
    }

    public static class TableConstruct
    extends Table {
        Structure struct;

        TableConstruct(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.struct = (Structure)ds.findVariable(config.structName);
            if (this.struct == null) {
                throw new IllegalStateException("Cant find Structure " + config.structName);
            }
        }

        protected void showExtra(Formatter f) {
            f.format("    ArrayStruct=%s%n", this.struct.getNameAndDimensions());
        }

        public Variable findVariable(String axisName) {
            return this.struct.findVariable(axisName);
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            return this.struct.getStructureIterator(bufferSize);
        }
    }

    public static class TableArrayStructure
    extends Table {
        ArrayStructure as;
        Dimension dim;

        TableArrayStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.as = config.as;
            this.dim = new Dimension(config.name, (int)config.as.getSize(), false);
            assert (this.as != null);
            for (StructureMembers.Member m : config.as.getStructureMembers().getMembers()) {
                this.cols.add(new VariableSimpleAdapter(m));
            }
        }

        protected void showExtra(Formatter f) {
            f.format("    ArrayStruct=%s, dim=%s%n", new Section(this.as.getShape()), this.dim.getName());
        }

        public String showDimension() {
            return this.dim.getName();
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            return this.as.getStructureDataIterator();
        }
    }

    public static class TableStructure
    extends Table {
        Structure struct;
        Dimension dim;
        boolean addIndex;

        TableStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            if (config.isPsuedoStructure) {
                this.dim = config.dim;
                assert (this.dim != null);
                this.struct = new StructurePseudo((NetcdfFile)ds, this.dim.getGroup(), config.structName, config.dim);
            } else {
                this.struct = (Structure)ds.findVariable(config.structName);
                if (this.struct == null) {
                    throw new IllegalStateException("Cant find Structure " + config.structName);
                }
                this.dim = this.struct.getDimension(0);
            }
            for (Variable v : this.struct.getVariables()) {
                if (v.getDataType() == DataType.STRUCTURE) {
                    if (!config.isPsuedoStructure) continue;
                    this.struct.removeMemberVariable(v);
                    continue;
                }
                this.cols.add(v);
            }
        }

        protected void showExtra(Formatter f) {
            f.format("    struct=%s, dim=%s pseudo=%s%n", this.struct.getNameAndDimensions(), this.dim.getName(), this.struct instanceof StructurePseudo);
        }

        public Variable findVariable(String axisName) {
            return this.struct.findVariable(axisName);
        }

        public String showDimension() {
            return this.dim.getName();
        }

        public StructureDataIterator getStructureDataIterator(Cursor cursor, int bufferSize) throws IOException {
            return this.struct.getStructureIterator(bufferSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ArrayStructure,
        Construct,
        Contiguous,
        LinkedList,
        MultiDimInner,
        MultiDimOuter,
        MultiDimStructure,
        NestedStructure,
        ParentIndex,
        Singleton,
        Structure,
        Top;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordName {
        Lat,
        Lon,
        Elev,
        Time,
        TimeNominal,
        StnId,
        StnDesc,
        WmoId,
        StnAlt;

    }
}

