/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.util.List;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.iosp.Indexer;

public class RegularIndexer
extends Indexer {
    private int elemSize;
    private long startPos;
    private int[] wantShape;
    private FileIndex index;
    private Indexer.Chunk chunk;
    private int nelems;
    private int total;
    private int done;
    private boolean debug = false;
    private boolean debugNext = false;

    public RegularIndexer(int[] varShape, int elemSize, long startPos, List section, int recSize) throws InvalidRangeException {
        int ii;
        int rank;
        int lastDim;
        int ii2;
        this.elemSize = elemSize;
        this.startPos = startPos;
        boolean isRecord = recSize > 0;
        int varRank = varShape.length;
        int[] wantOrigin = new int[varRank];
        int[] wantStride = new int[varRank];
        for (ii2 = 0; ii2 < varRank; ++ii2) {
            wantStride[ii2] = 1;
        }
        if (section == null) {
            this.wantShape = new int[varShape.length];
            System.arraycopy(varShape, 0, this.wantShape, 0, varShape.length);
        } else {
            if (section.size() != varRank) {
                throw new InvalidRangeException("Bad section rank");
            }
            this.wantShape = new int[varRank];
            for (ii2 = 0; ii2 < varRank; ++ii2) {
                Range r = (Range)section.get(ii2);
                if (r == null) {
                    this.wantShape[ii2] = varShape[ii2];
                    continue;
                }
                if (r.last() >= varShape[ii2]) {
                    throw new InvalidRangeException("Bad range for dimension " + ii2 + " = " + r.last());
                }
                wantOrigin[ii2] = r.first();
                this.wantShape[ii2] = r.length();
                wantStride[ii2] = r.stride();
            }
        }
        this.total = (int)Index.computeSize(this.wantShape);
        this.done = 0;
        int[] stride = new int[varRank];
        int product = 1;
        for (int ii3 = varRank - 1; ii3 >= 0; --ii3) {
            stride[ii3] = product;
            product *= varShape[ii3];
        }
        long offset = 0L;
        for (int ii4 = 0; ii4 < varRank; ++ii4) {
            long realStride = isRecord && ii4 == 0 ? (long)recSize : (long)(elemSize * stride[ii4]);
            long pos = realStride * (long)wantOrigin[ii4];
            offset += pos;
        }
        int[] mergeShape = new int[this.wantShape.length];
        System.arraycopy(this.wantShape, 0, mergeShape, 0, this.wantShape.length);
        int n = lastDim = isRecord ? 2 : 1;
        for (rank = varRank; rank > lastDim && varShape[rank - 1] == this.wantShape[rank - 1] && wantStride[rank - 2] == 1; --rank) {
            int n2 = rank - 2;
            mergeShape[n2] = mergeShape[n2] * mergeShape[rank - 1];
        }
        if (rank == 0 || isRecord && rank == 1 || wantStride[rank - 1] > 1) {
            this.nelems = 1;
        } else {
            this.nelems = mergeShape[rank - 1];
            mergeShape[rank - 1] = 1;
        }
        int[] finalStride = new int[varRank];
        product = 1;
        for (ii = varRank - 1; ii >= 0; --ii) {
            finalStride[ii] = product * wantStride[ii];
            product *= varShape[ii];
        }
        ii = 0;
        while (ii < rank) {
            int n3 = ii++;
            finalStride[n3] = finalStride[n3] * elemSize;
        }
        if (isRecord && rank > 0) {
            finalStride[0] = recSize * wantStride[0];
        }
        int[] finalShape = new int[rank];
        for (int ii5 = 0; ii5 < rank; ++ii5) {
            finalShape[ii5] = mergeShape[ii5];
        }
        this.index = new FileIndex(offset, finalShape, finalStride);
        if (this.debug) {
            System.out.println("*************************");
            this.printa(" varShape", varShape);
            this.printa(" wantOrigin", wantOrigin);
            this.printa(" wantShape", this.wantShape);
            this.printa(" wantStride", wantStride);
            this.printa(" shape", finalShape, rank);
            this.printa(" stride", finalStride, rank);
            System.out.println("offset= " + offset);
            System.out.println("total= " + this.total);
            System.out.println("nelems= " + this.nelems);
            System.out.println("rank= " + rank + " varRank= " + varRank);
            System.out.println("isRecord= " + isRecord);
        }
    }

    private void printa(String name, int[] a, int rank) {
        System.out.print(name + "= ");
        for (int i = 0; i < rank; ++i) {
            System.out.print(a[i] + " ");
        }
        System.out.println();
    }

    public int getChunkSize() {
        return this.nelems;
    }

    public int[] getWantShape() {
        return this.wantShape;
    }

    public long getTotalNelems() {
        return this.total;
    }

    public int getElemSize() {
        return this.elemSize;
    }

    public boolean hasNext() {
        return this.done < this.total;
    }

    public Indexer.Chunk next() {
        if (this.chunk == null) {
            this.chunk = new Indexer.Chunk(this.startPos, this.nelems, 0L);
        } else {
            this.index.incr();
            this.chunk.incrStartElem(this.nelems);
        }
        this.chunk.setFilePos(this.startPos + this.index.currentPos());
        if (this.debugNext) {
            this.printa("-- current index= ", this.index.current);
            System.out.println(" pos= " + this.index.currentPos());
            System.out.println(" next chunk = " + this.chunk);
        }
        this.done += this.nelems;
        return this.chunk;
    }

    private class FileIndex {
        long startPos;
        int[] shape;
        int[] stride;
        int[] origin;
        int[] current;
        int rank;

        FileIndex(long startPos, int[] shape, int[] stride) {
            this.startPos = startPos;
            this.shape = shape;
            this.stride = stride;
            this.rank = shape.length;
            this.current = new int[this.rank];
        }

        void incr() {
            for (int digit = this.rank - 1; digit >= 0; --digit) {
                int n = digit;
                this.current[n] = this.current[n] + 1;
                if (this.current[digit] < this.shape[digit]) break;
                this.current[digit] = 0;
            }
        }

        long currentPos() {
            long value = this.startPos;
            for (int ii = 0; ii < this.rank; ++ii) {
                value += (long)this.current[ii] * (long)this.stride[ii];
            }
            return value;
        }
    }
}

