/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.TableLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDescriptorTreeConstructor {
    private static Logger log = LoggerFactory.getLogger(DataDescriptorTreeConstructor.class);
    private DataDescriptor root;
    private DataDescriptor changeWidth = null;
    private DataDescriptor changeScale = null;
    private DataDescriptor changeRefval = null;

    public DataDescriptor factory(TableLookup lookup, BufrDataDescriptionSection dds) {
        this.root = new DataDescriptor();
        List<DataDescriptor> keys = this.convert(dds.getDataDescriptors(), lookup);
        List<DataDescriptor> tree = this.replicate(keys);
        this.root.subKeys = new ArrayList<DataDescriptor>();
        this.flatten(this.root.subKeys, tree);
        this.operate(this.root.subKeys);
        this.root.total_nbits = this.root.countBits();
        return this.root;
    }

    private List<DataDescriptor> convert(List<Short> keyDesc, TableLookup lookup) {
        if (keyDesc == null) {
            return null;
        }
        ArrayList<DataDescriptor> keys = new ArrayList<DataDescriptor>();
        for (short id : keyDesc) {
            DataDescriptor dd = new DataDescriptor(id, lookup);
            keys.add(dd);
            if (dd.f != 3) continue;
            List<Short> subDesc = lookup.getDescriptorsTableD(dd.fxy);
            if (subDesc == null) {
                dd.bad = true;
                continue;
            }
            dd.subKeys = this.convert(subDesc, lookup);
        }
        return keys;
    }

    private List<DataDescriptor> replicate(List<DataDescriptor> keys) {
        ArrayList<DataDescriptor> tree = new ArrayList<DataDescriptor>();
        Iterator<DataDescriptor> dkIter = keys.iterator();
        while (dkIter.hasNext()) {
            DataDescriptor dk = dkIter.next();
            if (dk.f == 1) {
                dk.subKeys = new ArrayList<DataDescriptor>();
                dk.replication = dk.y;
                if (dk.replication == 0) {
                    this.root.isVarLength = true;
                    DataDescriptor replication = dkIter.next();
                    if (replication.y == 0) {
                        dk.replicationCountSize = 1;
                    } else if (replication.y == 1) {
                        dk.replicationCountSize = 8;
                    } else if (replication.y == 2) {
                        dk.replicationCountSize = 16;
                    } else if (replication.y == 11) {
                        dk.repetitionCountSize = 8;
                    } else if (replication.y == 12) {
                        dk.repetitionCountSize = 16;
                    } else {
                        log.error("Unknown replication type= " + replication);
                    }
                }
                for (int j = 0; j < dk.x && dkIter.hasNext(); ++j) {
                    dk.subKeys.add(dkIter.next());
                }
                dk.subKeys = this.replicate(dk.subKeys);
            } else if (dk.f == 3 && dk.subKeys != null) {
                dk.subKeys = this.replicate(dk.subKeys);
            }
            tree.add(dk);
        }
        return tree;
    }

    private void flatten(List<DataDescriptor> result, List<DataDescriptor> tree) {
        for (DataDescriptor key : tree) {
            if (key.bad) {
                this.root.isBad = true;
                continue;
            }
            if (key.f == 3 && key.subKeys != null) {
                this.flatten(result, key.subKeys);
                continue;
            }
            if (key.f == 1) {
                ArrayList<DataDescriptor> subTree = new ArrayList<DataDescriptor>();
                this.flatten(subTree, key.subKeys);
                key.subKeys = subTree;
                result.add(key);
                continue;
            }
            result.add(key);
        }
    }

    private void operate(List<DataDescriptor> tree) {
        if (tree == null) {
            return;
        }
        boolean hasAssFields = false;
        DataDescriptor.AssociatedField assField = null;
        Iterator<DataDescriptor> iter = tree.iterator();
        while (iter.hasNext()) {
            DataDescriptor dd = iter.next();
            if (dd.f == 2) {
                if (dd.x == 1) {
                    this.changeWidth = dd.y == 0 ? null : dd;
                    iter.remove();
                    continue;
                }
                if (dd.x == 2) {
                    this.changeScale = dd.y == 0 ? null : dd;
                    iter.remove();
                    continue;
                }
                if (dd.x == 3) {
                    this.changeRefval = dd.y == 255 ? null : dd;
                    iter.remove();
                    continue;
                }
                if (dd.x == 4) {
                    assField = dd.y == 0 ? null : new DataDescriptor.AssociatedField(dd.y);
                    iter.remove();
                    hasAssFields = true;
                    continue;
                }
                if (dd.x == 6) {
                    iter.remove();
                    if (!iter.hasNext()) continue;
                    DataDescriptor next = iter.next();
                    next.bitWidth = dd.y;
                    continue;
                }
                iter.remove();
                continue;
            }
            if (dd.subKeys != null) {
                this.operate(dd.subKeys);
                continue;
            }
            if (dd.f != 0) continue;
            if (dd.type == 0) {
                if (this.changeWidth != null) {
                    dd.bitWidth += this.changeWidth.y - 128;
                }
                if (this.changeScale != null) {
                    dd.scale += this.changeScale.y - 128;
                }
                if (this.changeRefval != null) {
                    dd.refVal += this.changeRefval.y - 128;
                }
            }
            if (dd.f != 0 || assField == null) continue;
            ++assField.nfields;
            dd.assField = assField;
            assField.dataFldName = dd.name;
        }
        if (hasAssFields) {
            this.addAssFields(tree);
        }
    }

    private void addAssFields(List<DataDescriptor> tree) {
        if (tree == null) {
            return;
        }
        for (int index = 0; index < tree.size(); ++index) {
            DataDescriptor dd = tree.get(index);
            if (dd.assField == null) continue;
            DataDescriptor.AssociatedField assField = dd.assField;
            if (dd.f == 0 && dd.x == 31 && dd.y == 21) {
                dd.name = assField.dataFldName + "_associated_field_significance";
                dd.assField = null;
                continue;
            }
            DataDescriptor assDD = new DataDescriptor(dd, assField.nbits);
            tree.add(index, assDD);
            ++index;
        }
    }
}

