/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.gempak.GempakGridParameterTable;
import ucar.nc2.iosp.gempak.GempakGridReader;
import ucar.nc2.iosp.gempak.GempakGridRecord;
import ucar.nc2.iosp.gempak.GempakLookup;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class GempakGridServiceProvider
extends GridServiceProvider {
    protected GempakGridReader gemreader;
    public static boolean extendIndex = true;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            this.gemreader = new GempakGridReader();
            this.gemreader.init(raf, false);
        }
        catch (Exception ioe) {
            return false;
        }
        return true;
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        long start = System.currentTimeMillis();
        if (this.gemreader == null) {
            this.gemreader = new GempakGridReader();
        }
        this.initTables();
        this.gemreader.init(raf, true);
        GridIndex index = this.gemreader.getGridIndex();
        this.open(index, cancelTask);
        if (debugOpen) {
            System.out.println(" GridServiceProvider.open " + ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
        }
    }

    protected void open(GridIndex index, CancelTask cancelTask) throws IOException {
        GempakLookup lookup = new GempakLookup((GempakGridRecord)index.getGridRecords().get(0));
        GridIndexToNC delegate = new GridIndexToNC();
        delegate.setUseDescriptionForVariableName(false);
        delegate.open(index, lookup, 4, this.ncfile, this.fmrcCoordSys, cancelTask);
        this.ncfile.finish();
    }

    public boolean sync() throws IOException {
        if (this.gemreader.getInitFileSize() < this.raf.length() && extendIndex) {
            this.gemreader.init(true);
            GridIndex index = this.gemreader.getGridIndex();
            this.ncfile.empty();
            this.open(index, null);
            return true;
        }
        return false;
    }

    protected float[] _readData(GridRecord gr) throws IOException {
        return this.gemreader.readGrid((GempakGridRecord)gr);
    }

    public static void main(String[] args) throws IOException {
        GempakGridServiceProvider mciosp = new GempakGridServiceProvider();
        RandomAccessFile rf = new RandomAccessFile(args[0], "r", 2048);
        MakeNetcdfFile ncfile = new MakeNetcdfFile(mciosp, rf, args[0], null);
    }

    private void initTables() {
        try {
            GempakGridParameterTable.addParameters("resources/nj22/tables/gempak/wmogrib3.tbl");
            GempakGridParameterTable.addParameters("resources/nj22/tables/gempak/ncepgrib2.tbl");
        }
        catch (Exception e) {
            System.out.println("unable to init tables");
        }
    }

    public static void setExtendIndex(boolean b) {
        extendIndex = b;
    }

    protected static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

