/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableParser {
    static String testName = "C:/data/station/adde/STNDB.TXT";
    static String testName2 = "http://localhost:8080/test/STNDB.TXT";
    static String testName3 = "C:/dev/thredds/cdm/src/main/resources/resources/nj22/tables/nexrad.tbl";

    public static List<Record> readTable(String urlString, String format, int maxLines) throws IOException, NumberFormatException {
        InputStream ios;
        if (urlString.startsWith("http:")) {
            URL url = new URL(urlString);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(urlString);
        }
        return TableParser.readTable(ios, format, maxLines);
    }

    public static List<Record> readTable(InputStream ios, String format, int maxLines) throws IOException, NumberFormatException {
        String line;
        ArrayList<Field> fields = new ArrayList<Field>();
        int start = 0;
        StringTokenizer stoker = new StringTokenizer(format, " ,");
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            Class type = String.class;
            char last = tok.charAt(tok.length() - 1);
            if (last == 'i') {
                type = Integer.TYPE;
            }
            if (last == 'd') {
                type = Double.TYPE;
            }
            if (type != String.class) {
                tok = tok.substring(0, tok.length() - 1);
            }
            int end = Integer.parseInt(tok);
            fields.add(new Field(start, end, type));
            start = end + 1;
        }
        ArrayList<Record> records = new ArrayList<Record>();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        for (int count = 0; (maxLines < 0 || count < maxLines) && (line = dataIS.readLine()) != null; ++count) {
            records.add(new Record(line, fields));
        }
        dataIS.close();
        return records;
    }

    public static void main(String[] args) throws IOException {
        List<Record> recs = TableParser.readTable(testName3, "3,15,54,60d,67d,73d", 50000);
        for (int i = 0; i < recs.size(); ++i) {
            Record record = recs.get(i);
            for (int j = 0; j < record.values.size(); ++j) {
                Object s = record.values.get(j);
                System.out.print(" " + s.toString());
            }
            System.out.println();
        }
    }

    public static class Record {
        private List<Object> values = new ArrayList<Object>();

        Record(String line, List fields) {
            for (Object field : fields) {
                Field f = (Field)field;
                this.values.add(f.parse(line));
            }
        }

        public Object get(int k) {
            return this.values.get(k);
        }
    }

    private static class Field {
        int start;
        int end;
        Class type;

        Field(int start, int end, Class type) {
            this.start = start;
            this.end = end;
            this.type = type;
        }

        Object parse(String line) throws NumberFormatException {
            String svalue = line.substring(this.start, this.end).trim();
            if (this.type == String.class) {
                return svalue;
            }
            try {
                if (this.type == Double.TYPE) {
                    return new Double(svalue);
                }
                if (this.type == Integer.TYPE) {
                    return new Integer(svalue);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

